/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data;

import com.sun.tck.bvtool.etsi.data.HeaderTLV;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.me.utils.Utils;

public class ResponseHeader
extends HeaderTLV {
    public static final int PoR_OK = 0;
    public static final int RC_CC_DS_Failed = 1;
    public static final int CNTR_Low = 2;
    public static final int CNTR_High = 3;
    public static final int CNTR_Blocked = 4;
    public static final int Ciphering_Error = 5;
    public static final int Undefined_Security_Error = 6;
    public static final int Insufficient_Memory = 7;
    public static final int More_Time = 8;
    public static final int TAR_Unknown = 9;
    public static final int Insufficient_Security_Level = 10;
    private int status;
    private TLVBuffer securedDataBuff;

    public int getStatus() {
        return this.status;
    }

    public int status() {
        return this.status;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "\n    TAR=0x" + Integer.toHexString(0xFFFFFF & this.getTAR()) + "\n    CNTR=0x" + Long.toHexString(this.counter & 0xFFFFFFFFFFL) + "\n    PCNTR=0x" + Integer.toHexString(0xFF & this.PCNTR) + "\n    Status=" + Utils.findName(this.status, ResponseHeader.class) + "\n    RC/CC/DS=0x" + Utils.canonize(this.checkSum) + "}";
    }

    public void writeHeaderData(TLVBuffer out) {
        out.write(this.getTAR(), 3);
        this.startEncryptedData = out.createPosition();
        out.write(this.counter, 5);
        out.write(this.PCNTR);
        out.write(this.status);
    }

    public void parseHeader() throws EncodingException {
        this.headerlength = this.buffer.read();
        this.setTAR((int)this.buffer.read(3));
        this.startEncryptedData = this.buffer.createPosition();
    }

    public void parseDecryptedHeader() throws EncodingException {
        this.counter = this.buffer.read(5);
        this.PCNTR = (byte)this.buffer.read();
        this.status = this.buffer.read();
        int sigLength = this.headerlength - this.buffer.getPos() + this.startValue.pos + 1;
        this.checkSum = this.buffer.readArray(sigLength);
        this.securedDataBuff = this.buffer.createChild(this.buffer.available() - this.PCNTR);
    }

    public TLVBuffer getSecuredData() {
        return this.securedDataBuff;
    }
}

