/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.Script;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.util.StringArray;
import com.sun.jck.lib.I18n;
import com.sun.jck.lib.MessageSwitch;
import com.sun.jck.lib.RemoteManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;

public class JCKScript
extends Script {
    public static final int COMPILER = 1;
    public static final int RUNTIME = 2;
    private int product;
    public static final int CERTIFY = 1;
    public static final int PRECOMPILE = 2;
    public static final int DEVELOPER = 3;
    private int mode;
    private String precompileClassDir;
    private boolean compilerKey;
    private boolean coreAPIKey;
    private boolean extensionAPIKey;
    private boolean idlInheritKey;
    private boolean idlTieKey;
    private boolean interactiveKey;
    private boolean javaCompilerKey;
    private boolean negativeKey;
    private boolean optionalAPIKey;
    private boolean positiveKey;
    private boolean rmicKey;
    private boolean rmiIIOPKey;
    private boolean rmiV11Key;
    private boolean runtimeKey;
    private boolean serialKey;
    private boolean vmKey;
    private String contextArgs;
    private static final String REF_COMPILE = "refCompile";
    private static final String REF_EXECUTE = "refExecute";
    private static final String REF_RMIC = "refRMIC";
    private static final String TEST_COMPILE = "testCompile";
    private static final String TEST_EXECUTE = "testExecute";
    private static final String TEST_EXECUTE_NATIVE = "testExecuteNative";
    private static final String TEST_RMIC = "testRMIC";
    private static final Status error_badModeFlags = Status.error((String)I18n.getString("error.bad.mode.flags"));
    private static final Status error_bothCompilerRuntimeFlag = Status.error((String)I18n.getString("error.both.compiler.runtime.flag"));
    private static final Status error_noCompilerRuntimeFlag = Status.error((String)I18n.getString("error.no.compiler.runtime.flag"));
    private static final Status error_notACompilerTest = Status.error((String)I18n.getString("error.not.compiler.test"));
    private static final Status error_notARuntimeTest = Status.error((String)I18n.getString("error.not.runtime.test"));
    private static final Status error_notJavaSource = Status.error((String)I18n.getString("error.not.java.source"));
    private static final Status error_precompileCompilerTest = Status.error((String)I18n.getString("error.precompile.compiler.test"));
    private static final Status error_unrecognizedArg = Status.error((String)I18n.getString("error.unrecognized.arg"));
    private static final String[] nullArgs = new String[0];

    public void initTestDescription(TestDescription td) {
        super.initTestDescription(td);
        Set keys = td.getKeywordTable();
        this.compilerKey = keys.contains("compiler");
        this.coreAPIKey = keys.contains("coreapi");
        this.extensionAPIKey = keys.contains("extensionapi");
        this.idlInheritKey = keys.contains("idl_inherit");
        this.idlTieKey = keys.contains("idl_tie");
        this.interactiveKey = keys.contains("interactive");
        this.javaCompilerKey = keys.contains("javacompiler");
        this.negativeKey = keys.contains("negative");
        this.optionalAPIKey = keys.contains("optionalapi");
        this.positiveKey = keys.contains("positive");
        this.rmicKey = keys.contains("rmic");
        this.rmiIIOPKey = keys.contains("rmi_iiop");
        this.rmiV11Key = keys.contains("rmi_v11");
        this.runtimeKey = keys.contains("runtime");
        this.serialKey = keys.contains("serial");
        this.vmKey = keys.contains("virtualmachine");
    }

    public Status run(String[] args, TestDescription td, TestEnvironment env) {
        Status s;
        if (args != null && (s = this.init(args)) != null) {
            return s;
        }
        String[] context = StringArray.split((String)td.getParameter("context"));
        if (context != null && (this.mode == 3 || this.mode == 1)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < context.length; ++i) {
                try {
                    String[] contextValue = env.lookup(context[i]);
                    if (contextValue == null || contextValue.length == 0) {
                        return Status.error((String)I18n.getString("undefined.context", context[i]));
                    }
                    if (contextValue.length != 1) {
                        return Status.error((String)I18n.getString("bad.context", context[i], StringArray.join((String[])contextValue)));
                    }
                    sb.append('-');
                    sb.append(context[i]);
                    sb.append(' ');
                    sb.append(contextValue[0]);
                    sb.append(' ');
                    continue;
                }
                catch (TestEnvironment.Fault e) {
                    return Status.error((String)I18n.getString("bad.context", context[i], e.getMessage()));
                }
            }
            this.contextArgs = sb.toString();
        }
        switch (this.product) {
            case 1: {
                return this.runCompilerTest();
            }
            case 2: {
                return this.runRuntimeTest();
            }
        }
        throw new IllegalStateException(I18n.getString("invalid.product"));
    }

    public void setProduct(int p) {
        this.product = p;
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public void setPrecompileClassDir(String d) {
        this.precompileClassDir = d;
    }

    public int getTestTimeout() {
        if (this.interactiveKey) {
            return 0;
        }
        String s = this.td.getParameter("timeout");
        int t = s == null ? 600 : Integer.parseInt(s);
        float factor = 1.0f;
        try {
            String f = this.env.lookup("javatestTimeoutFactor")[0];
            if (f != null) {
                factor = Float.parseFloat(f);
            }
        }
        catch (TestEnvironment.Fault f) {
            // empty catch block
        }
        return (int)((float)t * factor);
    }

    private Status init(String[] args) {
        boolean compilerFlag = false;
        boolean runtimeFlag = false;
        boolean certifyFlag = false;
        boolean precompileFlag = false;
        boolean developerFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-compiler")) {
                this.product = 1;
                compilerFlag = true;
                continue;
            }
            if (args[i].equals("-runtime")) {
                this.product = 2;
                runtimeFlag = true;
                continue;
            }
            if (args[i].equals("-certify")) {
                this.mode = 1;
                certifyFlag = true;
                continue;
            }
            if (args[i].equals("-developer")) {
                this.mode = 3;
                developerFlag = true;
                continue;
            }
            if (args[i].equals("-precompile")) {
                this.mode = 2;
                precompileFlag = true;
                continue;
            }
            if (args[i].equals("-noJTRIfPass")) {
                this.setJTRIfPassed(false);
                continue;
            }
            if (args[i].equals("-precompileClassDir") && i + 1 < args.length) {
                this.precompileClassDir = args[++i];
                continue;
            }
            return error_unrecognizedArg.augment(args[i]);
        }
        if (!compilerFlag && !runtimeFlag) {
            return error_noCompilerRuntimeFlag;
        }
        if (compilerFlag && runtimeFlag) {
            return error_bothCompilerRuntimeFlag;
        }
        if (certifyFlag && developerFlag || developerFlag && precompileFlag || precompileFlag && certifyFlag) {
            return error_badModeFlags;
        }
        if (!(certifyFlag || developerFlag || precompileFlag)) {
            certifyFlag = true;
            this.mode = 1;
        }
        if (precompileFlag && compilerFlag) {
            return error_precompileCompilerTest;
        }
        return null;
    }

    private Status runCompilerTest() {
        boolean isCompilerTest;
        PrintWriter trOut = this.getTestResult().getTestCommentWriter();
        boolean bl = isCompilerTest = this.compilerKey || this.javaCompilerKey || this.rmicKey;
        if (!isCompilerTest) {
            return error_notACompilerTest;
        }
        trOut.println(I18n.getString("testing.java.compiler"));
        File[] srcs = this.td.getSourceFiles();
        for (int i = 0; i < srcs.length; ++i) {
            String srcPath = srcs[i].getPath();
            if (srcPath.endsWith(".java")) continue;
            return error_notJavaSource.augment(srcPath);
        }
        Status compileStatus = this.serialKey ? this.compileIndividually(TEST_COMPILE, srcs) : this.compileTogether(TEST_COMPILE, srcs);
        String rmiClasses = this.td.getParameter("rmicClasses");
        if (rmiClasses == null) {
            rmiClasses = this.td.getParameter("rmicClass");
        }
        if (rmiClasses != null) {
            if (!compileStatus.isPassed()) {
                return error_compFailUnexp.augment(compileStatus);
            }
            trOut.println(I18n.getString("testing.rmi.compiler"));
            String rmicCmd = TEST_RMIC;
            if (this.rmiIIOPKey) {
                rmicCmd = rmicCmd + ".iiop";
            } else if (this.rmiV11Key) {
                rmicCmd = rmicCmd + ".v11";
            }
            compileStatus = this.rmiCompile(rmicCmd, StringArray.split((String)rmiClasses));
        }
        if (this.negativeKey) {
            trOut.println(I18n.getString("negative.test.check"));
            switch (compileStatus.getType()) {
                case 0: {
                    return fail_compSuccUnexp;
                }
                case 1: {
                    return pass_compFailExp;
                }
            }
            return compileStatus;
        }
        if (compileStatus.isPassed()) {
            trOut.println(I18n.getString("positive.test.check"));
            String executeClass = this.td.getParameter("executeClass");
            String executeArgs = this.getExecuteArgs(this.td);
            if (executeClass == null || executeClass.length() == 0) {
                return error_noExecuteClass;
            }
            return this.execute(REF_EXECUTE, executeClass, executeArgs);
        }
        return fail_compFailUnexp.augment(compileStatus);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status runRuntimeTest() {
        boolean isRuntimeTest;
        PrintWriter trOut = this.getTestResult().getTestCommentWriter();
        boolean bl = isRuntimeTest = this.runtimeKey || this.javaCompilerKey && this.positiveKey || this.vmKey || this.coreAPIKey || this.optionalAPIKey || this.extensionAPIKey;
        if (!isRuntimeTest) {
            return error_notARuntimeTest;
        }
        if (this.mode == 3 || this.mode == 2) {
            trOut.println("precompiling.sources");
            File[] srcs = this.td.getSourceFiles();
            boolean allJavaSrc = true;
            for (int i = 0; i < srcs.length && allJavaSrc; ++i) {
                String srcPath = srcs[i].getPath();
                allJavaSrc = srcPath.endsWith(".java");
            }
            Status compileStatus = this.serialKey || !allJavaSrc ? this.compileIndividually(REF_COMPILE, srcs) : (this.precompileClassDir != null ? this.compileIfNecessary(REF_COMPILE, srcs, this.precompileClassDir) : this.compileTogether(REF_COMPILE, srcs));
            String rmiClasses = this.td.getParameter("rmicClasses");
            if (rmiClasses == null) {
                rmiClasses = this.td.getParameter("rmicClass");
            }
            if (rmiClasses != null) {
                if (!compileStatus.isPassed()) {
                    return error_compFailUnexp.augment(compileStatus);
                }
                trOut.println(I18n.getString("precompiling.rmi"));
                String rmicCmd = REF_RMIC;
                if (this.rmiIIOPKey) {
                    rmicCmd = rmicCmd + ".iiop";
                } else if (this.rmiV11Key) {
                    rmicCmd = rmicCmd + ".v11";
                }
                compileStatus = this.rmiCompile(rmicCmd, StringArray.split((String)rmiClasses));
            }
            if (!compileStatus.isPassed()) {
                return error_compFailUnexp.augment(compileStatus);
            }
        }
        if (this.mode == 3 || this.mode == 1) {
            Status executeStatus;
            String executeArgs = this.getExecuteArgs(this.td);
            String executeClass = this.td.getParameter("executeClass");
            if (executeClass != null) {
                String remote = this.td.getParameter("remote");
                if (remote == null) {
                    trOut.println(I18n.getString("executing.test"));
                    executeStatus = this.execute(TEST_EXECUTE, executeClass, executeArgs);
                } else {
                    try {
                        trOut.println(I18n.getString("starting.remote"));
                        MessageSwitch ms = new MessageSwitch();
                        this.env.put("testMsgSwitch", ms.getHostAndPort());
                        RemoteManager rMgr = new RemoteManager(remote, this.env, this.getTestResult());
                        try {
                            trOut.println(I18n.getString("executing.test"));
                            executeStatus = this.execute(TEST_EXECUTE, executeClass, executeArgs);
                            ms.close();
                            rMgr.waitUntilDone(15);
                            Status rms = rMgr.getStatus();
                            executeStatus = RemoteManager.mergeStatus(executeStatus, rms);
                        }
                        finally {
                            rMgr.dispose();
                        }
                    }
                    catch (InterruptedException e) {
                        executeStatus = Status.error((String)I18n.getString("remote.exit.timeout"));
                    }
                    catch (IOException e) {
                        executeStatus = Status.error((String)I18n.getString("cant.create.msgswitch", e));
                    }
                    catch (RemoteManager.Fault e) {
                        executeStatus = Status.error((String)e.getMessage());
                    }
                }
            } else {
                String executeNative = this.td.getParameter("executeNative");
                if (executeNative != null) {
                    executeStatus = this.executeNative(executeNative, executeArgs);
                } else {
                    return error_noExecuteClass;
                }
            }
            if (this.negativeKey) {
                switch (executeStatus.getType()) {
                    case 0: {
                        return fail_execSuccUnexp;
                    }
                    case 1: {
                        return pass_execFailExp.augment(executeStatus);
                    }
                }
                return executeStatus;
            }
            return executeStatus;
        }
        return pass_compSuccExp;
    }

    protected Status compileOne(String command, String src) {
        if (src.endsWith(".idl") && (this.idlTieKey || this.idlInheritKey)) {
            Status s;
            if (!(!this.idlInheritKey || (s = super.compileOne(command + ".inherit", src)).isPassed() && this.idlTieKey)) {
                return s;
            }
            return super.compileOne(command + ".tie", src);
        }
        return super.compileOne(command, src);
    }

    private String getExecuteArgs(TestDescription td) {
        String executeArgs = td.getParameter("executeArgs");
        if (this.contextArgs == null) {
            return executeArgs;
        }
        if (executeArgs == null) {
            return this.contextArgs;
        }
        return this.contextArgs + ' ' + executeArgs;
    }

    private Status executeNative(String executeNative, String executeArgs) {
        try {
            String[] args;
            String[] stringArray = args = executeArgs == null ? nullArgs : this.env.resolve(executeArgs);
            if (this.excludedTestCases != null) {
                args = this.exclude(args, this.excludedTestCases);
            }
            this.env.put(TEST_EXECUTE_NATIVE, executeNative);
            this.env.put("testExecuteArgs", args);
            return this.invokeCommand(TEST_EXECUTE_NATIVE);
        }
        catch (TestEnvironment.Fault e) {
            this.trOut.println(I18n.getString("evaluating.exec.args", executeArgs));
            this.trOut.println(e.toString());
            return error_badExecuteArgs;
        }
    }
}

