/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.util.WriterStream;
import com.sun.jck.lib.Deprecated;
import com.sun.jck.lib.I18n;
import com.sun.jck.lib.MessageClient;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javasoft.sqe.javatest.Status;
import javasoft.sqe.javatest.Test;

public class DistributedTest
implements Test {
    private String name;
    protected PrintWriter log;
    protected PrintWriter ref;
    private String msgSwitchAddr;
    private MessageClient msgClient;
    private Status msgStatus = Status.passed((String)"OK");
    private static final Class[] handleXXXArgs = new Class[]{String.class, String[].class};

    protected DistributedTest() {
    }

    protected DistributedTest(String name) {
        this.name = name;
    }

    public Status run(String[] args, PrintWriter log, PrintWriter ref) {
        this.log = log;
        this.ref = ref;
        try {
            this.decodeAllArgs(args);
            this.msgClient = new MessageClient(this.name, this.msgSwitchAddr){

                public void handleMessage(String from, String[] args) {
                    DistributedTest.this.handleMessage(from, args);
                }

                public void handleException(Exception e) {
                    DistributedTest.this.handleException(I18n.getString("msg.client.problem"), e);
                }
            };
            Status goStatus = this.go();
            return goStatus.getType() >= this.msgStatus.getType() ? goStatus : this.msgStatus;
        }
        catch (IOException e) {
            this.printStackTrace(e);
            return Status.error((String)I18n.getString("msg.client.cant.start", e));
        }
        catch (Fault e) {
            return Status.error((String)e.getMessage());
        }
    }

    protected Status go() {
        this.msgClient.run();
        return Status.passed((String)"OK");
    }

    protected final void decodeAllArgs(String[] args) throws Fault {
        int elementsConsumed;
        for (int i = 0; i < args.length; i += elementsConsumed) {
            elementsConsumed = this.decodeArg(args, i);
            if (elementsConsumed != 0) continue;
            throw new Fault(I18n.getString("recognize.arg.error", args[i]));
        }
    }

    protected int decodeArg(String[] args, int index) throws Fault {
        if (args[index].equals("-msgSwitch")) {
            if (index + 1 < args.length) {
                this.msgSwitchAddr = args[++index];
                return 2;
            }
            throw new Fault(I18n.getString("msgswitch.no.value"));
        }
        return 0;
    }

    public void broadcast(String[] args) throws IOException {
        this.msgClient.broadcast(args);
    }

    public void send(String name, String[] args) throws IOException {
        this.msgClient.send(name, args);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.name != null) {
            throw new IllegalStateException(I18n.getString("already.named.exception"));
        }
        this.name = name;
    }

    public void handleMessages() throws InterruptedException {
        this.msgClient.start();
    }

    void handleMessage(String from, String[] args) {
        try {
            Method m = this.getClass().getDeclaredMethod("handle_" + args[0], handleXXXArgs);
            String[] restOfArgs = new String[args.length - 1];
            System.arraycopy(args, 1, restOfArgs, 0, restOfArgs.length);
            Status s = (Status)m.invoke((Object)this, from, restOfArgs);
            if (s != null) {
                this.setMsgStatus(s);
            }
        }
        catch (IllegalAccessException e) {
            this.handleException(I18n.getString("msg.handling.noaccess", args[0]), e);
        }
        catch (InvocationTargetException e) {
            Throwable et = e.getTargetException();
            if (et instanceof Fault) {
                this.setMsgStatus(Status.failed((String)et.getMessage()));
            } else {
                this.handleException(I18n.getString("msg.handling.exception", args[0]), et);
            }
        }
        catch (NoSuchMethodException e) {
            this.handleUnknownMessage(from, args);
        }
    }

    protected void handleUnknownMessage(String from, String[] args) {
        this.log.println(I18n.getString("msg.unknown", args[0]));
        this.setMsgStatus(Status.error((String)I18n.getString("msg.unknown", args[0])));
    }

    protected void printStackTrace(Throwable t) {
        PrintStream ps = Deprecated.createPrintStream((OutputStream)new WriterStream((Writer)this.log));
        t.printStackTrace(ps);
        ps.close();
    }

    private void setMsgStatus(Status s) {
        if (s.getType() > this.msgStatus.getType()) {
            this.msgStatus = s;
        }
    }

    private void handleException(String s, Throwable t) {
        this.log.println(s);
        this.printStackTrace(t);
        this.setMsgStatus(Status.error((String)s));
    }

    public static class Fault
    extends Exception {
        public Fault(String s) {
            super(s);
        }
    }
}

