/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.userinterface;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.APDU;
import com.sun.tck.me.utils.Utils;

public class ResponseAPDU
extends APDU {
    public ResponseAPDU(byte[] data) {
        super(data);
    }

    public int sw() {
        if (this.data == null || this.data.length < 2) {
            return -1;
        }
        return (this.data[this.data.length - 2] << 8 | 0xFF & this.data[this.data.length - 1]) & 0xFFFF;
    }

    public int getLe() {
        return this.data.length < 2 ? 0 : this.data.length - 2;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("Le: ");
        int Le = this.getLe();
        buff.append(this.byteToHex(Le));
        if (Le > 0) {
            buff.append(", Data:0x").append(Utils.canonize(this.data, 0, Le));
        }
        buff.append(" SW: ");
        buff.append(this.byteToHex(this.data[this.data.length - 2]));
        buff.append(this.byteToHexDigits(this.data[this.data.length - 1]));
        return buff.toString();
    }

    public int getData(int index) {
        if (index < 0 || index >= this.getLe()) {
            throw new IndexOutOfBoundsException(I18n.getString("incorrect.index", Integer.toHexString(index), Integer.toHexString(this.getLe())));
        }
        return this.data[index] & 0xFF;
    }

    public byte[] getResponseData() {
        byte[] retVal = new byte[this.data.length - 2];
        System.arraycopy(this.data, 0, retVal, 0, retVal.length);
        return retVal;
    }
}

