/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.userinterface;

import com.sun.javacard.cjck.userinterface.OutOfMemoryOnCardException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;

public class OnCardException
extends RuntimeException {
    private String exceptionName;
    private int exceptionReason;
    private ResponseAPDU answer;

    public OnCardException(String name, ResponseAPDU answer) {
        this(name, 0, answer);
    }

    public OnCardException(String name, int reason, ResponseAPDU apdu) {
        super("(name=" + name + " reason=" + reason + ")");
        this.exceptionName = name;
        this.exceptionReason = 0xFFFF & reason;
        this.answer = apdu;
    }

    public String getName() {
        return this.exceptionName;
    }

    public int getReason() {
        return this.exceptionReason;
    }

    public ResponseAPDU getAnswer() {
        return this.answer;
    }

    public static OnCardException create(int sw2, ResponseAPDU answer) {
        return OnCardException.create(sw2, 0, answer);
    }

    public static OnCardException create(int sw2, int reason, ResponseAPDU answer) {
        sw2 = 0xFF & sw2;
        switch (sw2) {
            case 18: 
            case 21: {
                return new OutOfMemoryOnCardException(sw2 & 0xF, answer);
            }
            case 16: {
                return new OnCardException("javacard.framework.SystemException", reason, answer);
            }
            case 32: {
                return new OnCardException("javacard.security.CryptoException", reason, answer);
            }
            case 48: {
                return new OnCardException("javacard.framework.APDUException", reason, answer);
            }
            case 240: {
                return new OnCardException("java.lang.ArithmeticException", reason, answer);
            }
            case 241: {
                return new OnCardException("java.lang.ArrayIndexOutOfBoundsException", reason, answer);
            }
            case 242: {
                return new OnCardException("java.lang.ArrayStoreException", reason, answer);
            }
            case 243: {
                return new OnCardException("java.lang.ClassCastException", reason, answer);
            }
            case 244: {
                return new OnCardException("java.lang.IndexOutOfBoundsException", reason, answer);
            }
            case 245: {
                return new OnCardException("java.lang.NegativeArraySizeException", reason, answer);
            }
            case 246: {
                return new OnCardException("java.lang.NullPointerException", reason, answer);
            }
            case 247: {
                return new OnCardException("java.lang.SecurityException", reason, answer);
            }
            case 248: {
                return new OnCardException("java.lang.RuntimeException", reason, answer);
            }
            case 249: {
                return new OnCardException("java.lang.Exception", reason, answer);
            }
            case 250: {
                return new OnCardException("java.lang.Throwable", reason, answer);
            }
        }
        int newReason = sw2 & 0xF;
        int newSw2 = sw2 & 0xF0;
        if (newReason == 0) {
            return new OnCardException("Unknown:code=0x" + Integer.toHexString(sw2), reason, answer);
        }
        return OnCardException.create(newSw2, newReason, answer);
    }
}

