/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConfiguredScript;
import com.sun.javacard.cjck.invoke.CustomizableScript;
import com.sun.javacard.cjck.invoke.Utils;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.OnCardException;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.javatest.Status;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class StdScript
implements ConfiguredScript,
CustomizableScript {
    public static final byte NOTHING = 0;
    public static final byte APPLETS = 1;
    public static final byte PACKAGES = 2;
    public static final byte ALL = 3;
    protected CJCKCardService cardService;
    protected ConfigFileReader configFile;
    protected CardProxyArguments args;
    protected PrintWriter out;
    protected PrintWriter ref;
    private boolean isExcluded;
    protected int apduCount;
    private Hashtable excluded_testcases = new Hashtable();
    protected byte DEFAULT_LE = (byte)127;
    protected byte DELETE_POLICY = (byte)3;
    private byte GET_RESPONSE_CLA_BYTE = 0;
    private String name;

    public void setConfigFileReader(ConfigFileReader configFile) {
        this.configFile = configFile;
    }

    public ConfigFileReader getConfigFileReader() {
        return this.configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(CJCKCardService cardService, PrintWriter out, PrintWriter ref) throws CardProxyException {
        this.init(cardService, out, ref);
        this.apduCount = 0;
        if (this.isExcluded) {
            return Status.passed((String)I18n.getString("script.excluded"));
        }
        try {
            cardService.powerUp();
            Status status = this.runScript();
            return status;
        }
        catch (ScriptFailException e) {
            Status status = e.getStatus();
            return status;
        }
        finally {
            cardService.powerDown();
        }
    }

    protected void init(CJCKCardService cardService, PrintWriter out, PrintWriter ref) {
        this.cardService = cardService;
        this.out = out;
        this.ref = ref;
    }

    public abstract Status runScript() throws CardProxyException;

    public void sendAPDU(CommandAPDU apdu, short expectedResponse) throws CardProxyException {
        ++this.apduCount;
        ResponseAPDU answer = this.sendAPDU(apdu);
        int sw = answer.sw();
        if ((sw & 0xFFFF) != (0xFFFF & expectedResponse)) {
            this.log(I18n.getString("incorrect.response", new Integer(this.apduCount), Integer.toHexString(0xFFFF & expectedResponse), Integer.toHexString(0xFFFF & sw)));
            throw new ScriptFailException(I18n.getString("incorrect.response.1", new Integer(this.apduCount)));
        }
    }

    public ResponseAPDU checkExceptionStatus(ResponseAPDU answer) {
        if (answer != null) {
            int status = 0xFFFF & answer.sw();
            int sw1 = StdScript.extractByte(status, 1);
            int sw2 = StdScript.extractByte(status, 0);
            if (sw1 == 156) {
                throw OnCardException.create(sw2, answer);
            }
        }
        return answer;
    }

    private static int extractByte(int value, int count) {
        return value >> count * 8 & 0xFF;
    }

    public ResponseAPDU sendAPDU(CommandAPDU apdu) throws CardProxyException {
        ++this.apduCount;
        ResponseAPDU answer2 = this.cardService.sendAPDU(apdu);
        int sw = answer2.sw();
        if ((sw & 0xFF00) != 24832) {
            return this.checkExceptionStatus(answer2);
        }
        ArrayList<ResponseAPDU> list = new ArrayList<ResponseAPDU>();
        int length = 0;
        while ((sw & 0xFF00) == 24832 || (sw & 0xFF00) == 25088) {
            list.add(answer2);
            length += answer2.getLe();
            answer2 = this.cardService.sendAPDU(this.getGetResponseAPDU(apdu.getCLA(), sw));
            sw = answer2.sw();
        }
        list.add(answer2);
        byte[] data = new byte[(length += answer2.getLe()) + 2];
        int offset = 0;
        for (ResponseAPDU answer2 : list) {
            for (int i = 0; i < answer2.getLe(); ++i) {
                data[offset++] = (byte)answer2.getData(i);
            }
        }
        data[offset++] = (byte)(sw >> 8);
        data[offset++] = (byte)sw;
        return this.checkExceptionStatus(new ResponseAPDU(data));
    }

    private CommandAPDU getGetResponseAPDU(byte original_cla, int sw) {
        return new CommandAPDU(new byte[]{(byte)(this.GET_RESPONSE_CLA_BYTE & 0xF0 | original_cla & 0xF), -64, 0, 0, (byte)sw});
    }

    public boolean deleteApplets(String[] names, boolean shouldRemove) throws CardProxyException {
        AppletProperties[] applets = new AppletProperties[names.length];
        for (int i = 0; i < names.length; ++i) {
            applets[i] = this.findApplet(names[i]);
        }
        return this.deleteApplets(applets, shouldRemove);
    }

    public boolean deletePackage(String name, boolean shouldRemove) throws CardProxyException {
        return this.deletePackage(this.findPackageName(name), shouldRemove);
    }

    public boolean deletePackageAndInstances(String name, boolean shouldRemove) throws CardProxyException {
        return this.deletePackageAndInstances(this.findPackageName(name), shouldRemove);
    }

    public void select(String name, short expected) throws CardProxyException {
        this.select(this.findApplet(name), expected);
    }

    public void select(String name) throws CardProxyException {
        this.log(I18n.getString("try.select.applet", name));
        this.select(this.findApplet(name), (short)-25856);
    }

    private boolean deleteApplets(AppletProperties[] applets, boolean shouldRemove) throws CardProxyException {
        this.log(I18n.getString("start.delete.applet", StdScript.createAppletList(applets), shouldRemove ? Boolean.TRUE : Boolean.FALSE));
        boolean status = this.cardService.deleteAppletInstances(applets);
        if (shouldRemove) {
            if (!status && this.DELETE_POLICY >= 1) {
                throw new ScriptFailException(I18n.getString("applet.deletion.incorrect.rejected"));
            }
        } else if (status) {
            throw new ScriptFailException(I18n.getString("applet.incorrectly.deleted"));
        }
        return status;
    }

    private boolean deletePackage(AppletID packageAID, boolean shouldRemove) throws CardProxyException {
        this.log(I18n.getString("start.delete.package", packageAID, shouldRemove ? Boolean.TRUE : Boolean.FALSE));
        boolean status = this.cardService.deletePackage(packageAID, this.getPackageName(packageAID));
        if (shouldRemove) {
            if (!status && this.DELETE_POLICY >= 2) {
                throw new ScriptFailException(I18n.getString("package.deletion.incorrectly.rejected"));
            }
        } else if (status) {
            throw new ScriptFailException(I18n.getString("package.incorrectly.deleted"));
        }
        return status;
    }

    protected String getPackageName(AppletID aid) {
        Enumeration e = this.configFile.getPackages();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (!aid.equals(this.configFile.getPackageAID(name))) continue;
            return name;
        }
        throw new IllegalArgumentException(I18n.getString("package.does.not.exist", aid));
    }

    private boolean deletePackageAndInstances(AppletID packageAID, boolean shouldRemove) throws CardProxyException {
        this.log(I18n.getString("start.delete.package_and_instances", packageAID, shouldRemove ? Boolean.TRUE : Boolean.FALSE));
        boolean status = this.cardService.deletePackageAndInstances(packageAID, this.getPackageName(packageAID));
        if (shouldRemove) {
            if (!status && this.DELETE_POLICY >= 2) {
                throw new ScriptFailException(I18n.getString("package.ins.deletion.incorrectly.rejected"));
            }
        } else if (status) {
            throw new ScriptFailException(I18n.getString("package.ins.incorrectly.deleted"));
        }
        return status;
    }

    private void select(AppletProperties applet, short expected) throws CardProxyException {
        this.log(I18n.getString("start.select.applet", applet.getClassName(), Integer.toHexString(expected)));
        this.sendAPDU(new CommandAPDU(0, -92, 4, 0, applet.getAID().getBytes(), this.DEFAULT_LE), expected);
    }

    public AppletProperties findApplet(String name) throws CardProxyException {
        NameSet set = new NameSet();
        set.check();
        return (AppletProperties)this.findObject(name, set);
    }

    public AppletID findPackageName(String name) throws CardProxyException {
        NameSet set = new NameSet(){

            public Enumeration keyObjects() {
                return StdScript.this.configFile.getPackages();
            }

            public String getName(Object applet) {
                return (String)applet;
            }

            public Object getObject(Object key) {
                return StdScript.this.configFile.getPackageAID((String)key);
            }
        };
        set.check();
        return (AppletID)this.findObject(name, set);
    }

    private Object findObject(String name, NameSet set) throws IllegalArgumentException {
        Object key = null;
        String suffix = name.startsWith(".") ? name : "." + name;
        boolean isAmbiguous = false;
        Enumeration e = set.keyObjects();
        while (e.hasMoreElements()) {
            Object current = e.nextElement();
            String objectName = set.getName(current);
            if (name.equals(objectName)) {
                return set.getObject(current);
            }
            if (!objectName.endsWith(suffix)) continue;
            if (key != null) {
                isAmbiguous = true;
                continue;
            }
            key = current;
        }
        if (isAmbiguous) {
            throw new IllegalArgumentException(I18n.getString("more.object.exist.with.given.suffix"));
        }
        if (key == null) {
            throw new IllegalArgumentException(I18n.getString("can.not.resolve.object.by.name"));
        }
        Object result = set.getObject(key);
        return result;
    }

    public static int makeInt(byte high, byte low) {
        return 0xFF00 & high << 8 | 0xFF & low;
    }

    protected void log(Object o) {
        if (this.out != null) {
            this.out.println(I18n.getString("stdscript.script.log", this.getName(), o));
        }
    }

    protected void ref(Object o) {
        this.log(o);
        if (this.ref != null) {
            this.ref.println(o);
        }
    }

    public void setExcludeEntries(String[] entries) {
        String name = this.getName();
        for (int i = 0; i < entries.length; ++i) {
            this.excluded_testcases.put(entries[i], "OK");
            if (!name.equals(entries[i])) continue;
            this.isExcluded = true;
            this.excluded_testcases.clear();
            return;
        }
    }

    public boolean checkTestCase(String name) {
        return name == null || this.excluded_testcases.get(name) == null;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getClass().getName();
            int pos = this.name.lastIndexOf(".");
            this.name = pos > 0 ? this.name.substring(pos + 1) : this.name;
        }
        return this.name;
    }

    public void setArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-DeletePolicy") || i + 1 >= args.length) continue;
            if (args[i + 1].equals("packages")) {
                this.DELETE_POLICY = (byte)2;
                continue;
            }
            if (args[i + 1].equals("applets")) {
                this.DELETE_POLICY = 1;
                continue;
            }
            if (args[i + 1].equals("all")) {
                this.DELETE_POLICY = (byte)3;
                continue;
            }
            if (!args[i + 1].equals("nothing")) continue;
            this.DELETE_POLICY = 0;
        }
    }

    public void installCapFile(String fileName, String[] applets) throws CardProxyException {
        this.installCapFileInt(this.args.getCapFileDir(), fileName, this.findAppletProperties(applets));
    }

    public void installCapFile(String fileName) throws CardProxyException {
        this.installCapFileInt(this.args.getCapFileDir(), fileName, this.configFile.getPropertiesByCapFile(fileName));
    }

    public void installRefCapFile(String fileName, String[] applets) throws CardProxyException {
        this.installCapFileInt(this.args.getRefCapFileDir(), fileName, this.findAppletProperties(applets));
    }

    public void installRefCapFile(String fileName) throws CardProxyException {
        this.installCapFileInt(this.args.getRefCapFileDir(), fileName, this.configFile.getPropertiesByCapFile(fileName));
    }

    private AppletProperties[] findAppletProperties(String[] names) throws CardProxyException {
        AppletProperties[] retVal = new AppletProperties[names.length];
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = this.findApplet(names[i]);
        }
        return retVal;
    }

    private void installCapFileInt(String dir, String capFileName, AppletProperties[] applets) throws CardProxyException {
        ConfigFileReader config = this.getConfigFileReader();
        String name = Utils.getCanonicalName(dir, capFileName);
        this.log(I18n.getString("start.installing.capfile.name", name));
        String info = Utils.fileInfo(name);
        if (info == null) {
            throw new ScriptFailException(I18n.getString("can.not.find.capfile.name", name));
        }
        boolean s = this.cardService.installCAPFile(applets, name, this.args.getOutputDir());
        if (!s) {
            throw new ScriptFailException(I18n.getString("installcapfile.failed", name));
        }
    }

    public void setCardProxyArguments(CardProxyArguments arguments) {
        this.args = arguments;
        this.GET_RESPONSE_CLA_BYTE = arguments.getGET_RESPONSE_CLA_BYTE();
    }

    private static String createAppletList(AppletProperties[] list) {
        if (list == null) {
            return "null";
        }
        StringBuffer retVal = new StringBuffer("[");
        for (int i = 0; i < list.length; ++i) {
            retVal.append(list[i].getClassName());
            retVal.append(", ");
        }
        retVal.append("]");
        return retVal.toString();
    }

    private class NameSet {
        private NameSet() {
        }

        protected void check() throws IllegalArgumentException {
            if (StdScript.this.configFile == null) {
                throw new IllegalArgumentException(I18n.getString("can.not.resolve.object.config.undefined"));
            }
        }

        public Enumeration keyObjects() {
            return StdScript.this.configFile.getAppletVector().elements();
        }

        public String getName(Object applet) {
            return ((AppletProperties)applet).getClassName();
        }

        public Object getObject(Object key) {
            return key;
        }
    }
}

