/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.rmi.Parameter;
import com.sun.javacard.cjck.scripts.rmi.RemoteRef;
import com.sun.javatest.Status;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;

public class RemoteMethod {
    private RemoteRef remote;
    private String name;
    private String signature;
    private Vector parameters = new Vector();

    public RemoteMethod(RemoteRef object) {
        this.remote = object;
    }

    public RemoteMethod(RemoteRef object, String name, String signature) {
        this.remote = object;
        this.setMethod(name, signature);
    }

    public void setMethod(String name, String signature) {
        this.name = name;
        this.signature = signature;
    }

    public void addParameter(Parameter arg) {
        this.parameters.addElement(arg);
    }

    public void addParameters(Parameter[] args) {
        int i = 0;
        while (i < args.length) {
            this.parameters.addElement(args[i++]);
        }
    }

    public void clear() {
        this.parameters.clear();
    }

    public byte[] getData() {
        int length = 4;
        Enumeration e = this.parameters.elements();
        while (e.hasMoreElements()) {
            length += ((Parameter)e.nextElement()).getBytes().length;
        }
        byte[] retVal = new byte[length];
        int objectID = this.remote.getRefID();
        short methodID = RemoteMethod.calculateMethodId(this.remote.getHashModifier(), this.name, this.signature);
        int offset = 0;
        retVal[offset++] = (byte)(objectID >> 8);
        retVal[offset++] = (byte)objectID;
        retVal[offset++] = (byte)(methodID >> 8);
        retVal[offset++] = (byte)methodID;
        Enumeration e2 = this.parameters.elements();
        while (e2.hasMoreElements()) {
            byte[] data = ((Parameter)e2.nextElement()).getBytes();
            System.arraycopy(data, 0, retVal, offset, data.length);
            offset += data.length;
        }
        return retVal;
    }

    public static short calculateMethodId(String hash_prefix, String name, String signature) {
        Status reason = null;
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA");
            byte[] name_id = (hash_prefix + name + signature).getBytes("UTF-8");
            sha.update(name_id);
            byte[] data = sha.digest();
            return (short)(0xFF00 & data[0] << 8 | 0xFF & data[1]);
        }
        catch (UnsupportedEncodingException e) {
            reason = Status.error((String)I18n.getString("unsupported.utf.encoding"));
        }
        catch (NoSuchAlgorithmException e1) {
            reason = Status.error((String)I18n.getString("unsupported.sha.algorithm"));
        }
        throw new ScriptFailException(reason);
    }

    public String toString() {
        return I18n.getString("remotemethod.name.signature", this.name, this.signature);
    }
}

