/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.MultiStdScript;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import java.util.HashMap;

public abstract class ECScript
extends MultiStdScript {
    public static final byte CREATE_SIG = 1;
    public static final byte CREATE_KA = 2;
    public static final byte CREATE_KA2 = 3;
    public static final byte CREATE_PRIVATE_KEY = 4;
    public static final byte CREATE_PUBLIC_KEY = 5;
    public static final byte SET_P = 6;
    public static final byte SET_A = 7;
    public static final byte SET_B = 8;
    public static final byte SET_G = 9;
    public static final byte SET_R = 10;
    public static final byte SET_K = 11;
    public static final byte SET_S = 12;
    public static final byte SET_W = 13;
    public static final byte SET_PRIVATE_KEY = 14;
    public static final byte SET_PUBLIC_KEY = 15;
    private static HashMap keydata = new HashMap();

    public ECScript(String[] cases) {
        super(cases);
    }

    protected KeyData getKeyData(byte set, short length) {
        KeyData current = (KeyData)keydata.get(set + "_" + length);
        if (current == null) {
            throw new IllegalArgumentException(I18n.getString("ecscript.no.dataset", new Byte(set), new Short(length)));
        }
        return current;
    }

    private byte[] encodeKeyCreateData(short keyLength) {
        return new byte[]{(byte)(keyLength >> 8), (byte)keyLength};
    }

    private boolean createKey(byte step, short keyLength) throws CardProxyException {
        CommandAPDU apdu = new CommandAPDU(-128, 32, step, 0, this.encodeKeyCreateData(keyLength), 127);
        ResponseAPDU answer = this.sendAPDU(apdu);
        int sw = answer.sw();
        if ((sw & 0xFFFF) != 39680 && (sw & 0xFFFF) != 39681) {
            this.log(I18n.getString("ecscript.incorrect.response", new Integer(this.apduCount), Integer.toHexString(0xFFFF & sw)));
            throw new ScriptFailException(I18n.getString("ecscript.exception", new Integer(this.apduCount)));
        }
        return (sw & 0xFFFF) == 39680;
    }

    public boolean createPrivateKey(short keyLength) throws CardProxyException {
        return this.createKey((byte)4, keyLength);
    }

    public boolean createPublicKey(short keyLength) throws CardProxyException {
        return this.createKey((byte)5, keyLength);
    }

    private byte[] encodeObjCreateData(byte algorithm, boolean externalAccess) {
        return new byte[]{algorithm, (byte)(externalAccess ? 1 : 0)};
    }

    private boolean createObj(byte step, byte algorithm, boolean external_access) throws CardProxyException {
        CommandAPDU apdu = new CommandAPDU(-128, 32, step, 0, this.encodeObjCreateData(algorithm, external_access), 127);
        ResponseAPDU answer = this.sendAPDU(apdu);
        int sw = answer.sw();
        if ((sw & 0xFFFF) != 39680 && (sw & 0xFFFF) != 39681) {
            this.log(I18n.getString("ecscript.incorrect.response", new Integer(this.apduCount), Integer.toHexString(0xFFFF & sw)));
            throw new ScriptFailException(I18n.getString("ecscript.exception", new Integer(this.apduCount)));
        }
        return (sw & 0xFFFF) == 39680;
    }

    public boolean createSignature(byte algorithm, boolean external_access) throws CardProxyException {
        return this.createObj((byte)1, algorithm, external_access);
    }

    public boolean createKeyAgreement(byte algorithm, boolean external_access) throws CardProxyException {
        return this.createObj((byte)2, algorithm, external_access);
    }

    public boolean createKeyAgreement2(byte algorithm, boolean external_access) throws CardProxyException {
        return this.createObj((byte)3, algorithm, external_access);
    }

    public void setECDomainParameters(byte set, short length) throws CardProxyException {
        KeyData current = this.getKeyData(set, length);
        this.sendAPDU(new CommandAPDU(-128, 32, 6, 0, current.P, 127), (short)-25856);
        this.sendAPDU(new CommandAPDU(-128, 32, 7, 0, current.A, 127), (short)-25856);
        this.sendAPDU(new CommandAPDU(-128, 32, 8, 0, current.B, 127), (short)-25856);
        this.sendAPDU(new CommandAPDU(-128, 32, 9, 0, current.G, 127), (short)-25856);
        this.sendAPDU(new CommandAPDU(-128, 32, 10, 0, current.R, 127), (short)-25856);
    }

    public void setCofactor(byte set, short length) throws CardProxyException {
        KeyData current = this.getKeyData(set, length);
        this.sendAPDU(new CommandAPDU(-128, 32, 11, 0, current.K, 127), (short)-25856);
    }

    public void setPrivateKeyData(byte set, short length) throws CardProxyException {
        KeyData current = this.getKeyData(set, length);
        this.sendAPDU(new CommandAPDU(-128, 32, 12, 0, current.S, 127), (short)-25856);
    }

    public void setPublicKeyData(byte set, short length) throws CardProxyException {
        KeyData current = this.getKeyData(set, length);
        this.sendAPDU(new CommandAPDU(-128, 32, 13, 0, current.W, 127), (short)-25856);
    }

    public void setPrivateKey() throws CardProxyException {
        this.sendAPDU(new CommandAPDU(new byte[]{-128, 32, 14, 0}), (short)-25856);
    }

    public void setPublicKey() throws CardProxyException {
        this.sendAPDU(new CommandAPDU(new byte[]{-128, 32, 15, 0}), (short)-25856);
    }

    static {
        keydata.put("1_112", new KeyData(new byte[]{-37, 124, 42, -65, 98, -29, 94, 102, -128, 118, -66, -83, 32, -117}, new byte[]{-37, 124, 42, -65, 98, -29, 94, 102, -128, 118, -66, -83, 32, -120}, new byte[]{101, -98, -8, -70, 4, 57, 22, -18, -34, -119, 17, 112, 43, 34}, new byte[]{4, 9, 72, 114, 57, -103, 90, 94, -25, 107, 85, -7, -62, -16, -104, -88, -100, -27, -81, -121, 36, -64, -94, 62, 14, 15, -9, 117, 0}, new byte[]{-37, 124, 42, -65, 98, -29, 94, 118, 40, -33, -84, 101, 97, -59}, new byte[]{0, 1}, new byte[]{89, 93, -96, 94, 97, -115, -91, -90, 100, -17, 106, -109, 18, 114}, new byte[]{4, -67, 99, 63, -124, -122, 116, 40, -98, -84, -67, -74, -93, -49, 40, 116, -11, 103, -32, -78, -50, 62, -64, -71, 55, 114, -110, -87, 84}));
        keydata.put("2_112", new KeyData(new byte[]{-37, 124, 42, -65, 98, -29, 94, 102, -128, 118, -66, -83, 32, -117}, new byte[]{-37, 124, 42, -65, 98, -29, 94, 102, -128, 118, -66, -83, 32, -120}, new byte[]{101, -98, -8, -70, 4, 57, 22, -18, -34, -119, 17, 112, 43, 34}, new byte[]{4, 9, 72, 114, 57, -103, 90, 94, -25, 107, 85, -7, -62, -16, -104, -88, -100, -27, -81, -121, 36, -64, -94, 62, 14, 15, -9, 117, 0}, new byte[]{-37, 124, 42, -65, 98, -29, 94, 118, 40, -33, -84, 101, 97, -59}, new byte[]{0, 1}, new byte[]{-53, 107, 31, 78, 68, -16, 105, 125, 26, -37, 91, 38, 14, -99}, new byte[]{4, 43, 80, -117, 72, 65, 30, -118, -89, 90, -74, 50, -37, -7, 70, -46, -32, -126, 48, -42, -80, -88, 61, 41, -89, -83, -75, -97, 54}));
        keydata.put("1_128", new KeyData(new byte[]{-1, -1, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{-24, 117, 121, -63, 16, 121, -12, 61, -40, 36, -103, 60, 44, -18, 94, -45}, new byte[]{4, 22, 31, -9, 82, -117, -119, -101, 45, 12, 40, 96, 124, -91, 44, 91, -122, -49, 90, -56, 57, 91, -81, -21, 19, -64, 45, -94, -110, -35, -19, 122, -125}, new byte[]{-1, -1, -1, -2, 0, 0, 0, 0, 117, -93, 13, 27, -112, 56, -95, 21}, new byte[]{0, 1}, new byte[]{1, 15, -98, 127, -41, 89, 101, -69, -4, 83, -110, -118, 60, -10, 119, 5}, new byte[]{4, -6, -61, -91, -65, -29, -90, 121, -8, -12, -102, 102, 26, -18, 115, -115, 66, 90, 104, -84, -115, -109, 106, -71, 93, 16, -53, 38, -111, 61, -125, -47, 53}));
        keydata.put("2_128", new KeyData(new byte[]{-1, -1, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{-24, 117, 121, -63, 16, 121, -12, 61, -40, 36, -103, 60, 44, -18, 94, -45}, new byte[]{4, 22, 31, -9, 82, -117, -119, -101, 45, 12, 40, 96, 124, -91, 44, 91, -122, -49, 90, -56, 57, 91, -81, -21, 19, -64, 45, -94, -110, -35, -19, 122, -125}, new byte[]{-1, -1, -1, -2, 0, 0, 0, 0, 117, -93, 13, 27, -112, 56, -95, 21}, new byte[]{0, 1}, new byte[]{-53, 107, 31, 78, 68, -16, 105, 125, 26, -37, 91, 38, 14, -99, 28, 22}, new byte[]{4, -85, -39, -69, -14, 16, -4, -43, 19, 19, 80, 56, -60, -76, 44, -114, 29, -4, -32, 27, -34, -94, 127, 88, -83, -57, -26, -34, -117, 64, 23, -82, -98}));
        keydata.put("1_160", new KeyData(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -84, 115}, new byte[]{0}, new byte[]{7}, new byte[]{4, 59, 76, 56, 44, -29, 122, -95, -110, -92, 1, -98, 118, 48, 54, -12, -11, -35, 77, 126, -69, -109, -116, -7, 53, 49, -113, -36, -19, 107, -62, -126, -122, 83, 23, 51, -61, -16, 60, 79, -18}, new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -72, -6, 22, -33, -85, -102, -54, 22, -74, -77}, new byte[]{0, 1}, new byte[]{90, -65, -51, 117, -21, 47, -76, -72, 122, 107, -127, 114, 89, 114, 88, -104, 110, 55, 109, -44}, new byte[]{4, 37, 27, 34, -115, 75, 17, -81, -13, 36, -8, 111, 2, -14, 5, 67, -78, 120, -3, -118, -96, -84, -106, -7, 39, 59, -93, 90, 30, 93, -62, -36, -50, -13, -48, 90, -117, -97, 45, 113, -92}));
        keydata.put("2_160", new KeyData(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -84, 115}, new byte[]{0}, new byte[]{7}, new byte[]{4, 59, 76, 56, 44, -29, 122, -95, -110, -92, 1, -98, 118, 48, 54, -12, -11, -35, 77, 126, -69, -109, -116, -7, 53, 49, -113, -36, -19, 107, -62, -126, -122, 83, 23, 51, -61, -16, 60, 79, -18}, new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -72, -6, 22, -33, -85, -102, -54, 22, -74, -77}, new byte[]{0, 1}, new byte[]{-53, 107, 31, 78, 68, -16, 105, 125, 26, -37, 91, 38, 14, -99, 28, 22, 81, -40, 93, 90}, new byte[]{4, -81, -112, -10, -74, 80, 123, -43, 92, -66, 20, -126, -102, 42, -43, -8, -10, 82, 43, 87, 6, -105, 0, 85, -41, 114, -118, -3, -11, -61, -37, -98, -103, 29, 20, -29, 4, -23, -118, -97, -78}));
        keydata.put("1_192", new KeyData(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{100, 33, 5, 25, -27, -100, -128, -25, 15, -89, -23, -85, 114, 36, 48, 73, -2, -72, -34, -20, -63, 70, -71, -79}, new byte[]{4, 24, -115, -88, 14, -80, 48, -112, -10, 124, -65, 32, -21, 67, -95, -120, 0, -12, -1, 10, -3, -126, -1, 16, 18, 7, 25, 43, -107, -1, -56, -38, 120, 99, 16, 17, -19, 107, 36, -51, -43, 115, -7, 119, -95, 30, 121, 72, 17}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -103, -34, -8, 54, 20, 107, -55, -79, -76, -46, 40, 49}, new byte[]{0, 1}, new byte[]{26, -115, 89, -113, -63, 91, -16, -3, -119, 3, 11, 92, -79, 17, 26, -21, -110, -82, -117, -81, 94, -92, 117, -5}, new byte[]{4, 98, -79, 45, 96, 105, 12, -36, -13, 48, -70, -70, -74, -26, -105, 99, -76, 113, -7, -108, -35, 112, 45, 22, -91, 99, -65, 94, -64, -128, 105, 112, 95, -1, -10, 94, 92, -91, -64, -42, -105, 22, -33, -53, 52, 116, 55, 57, 2}));
        keydata.put("2_192", new KeyData(new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -1, -1, -4}, new byte[]{100, 33, 5, 25, -27, -100, -128, -25, 15, -89, -23, -85, 114, 36, 48, 73, -2, -72, -34, -20, -63, 70, -71, -79}, new byte[]{4, 24, -115, -88, 14, -80, 48, -112, -10, 124, -65, 32, -21, 67, -95, -120, 0, -12, -1, 10, -3, -126, -1, 16, 18, 7, 25, 43, -107, -1, -56, -38, 120, 99, 16, 17, -19, 107, 36, -51, -43, 115, -7, 119, -95, 30, 121, 72, 17}, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -103, -34, -8, 54, 20, 107, -55, -79, -76, -46, 40, 49}, new byte[]{0, 1}, new byte[]{26, 114, 52, 15, 17, 4, -94, 52, 49, 3, 28, 6, -63, 33, 6, 28, 35, 53, 107, -51, 80, 20, 37, 11}, new byte[]{4, 27, -2, -119, 5, 93, -104, 46, 125, -65, 7, 35, -3, 67, -108, -126, 8, -62, -73, -74, 36, 57, -28, -1, -90, 52, 35, -28, 89, 19, 81, 121, 20, -67, -52, 81, -127, -114, 68, -7, 29, -66, 86, -123, 99, -40, -43, 71, 39}));
    }

    public static class KeyData {
        public byte[] P;
        public byte[] A;
        public byte[] B;
        public byte[] G;
        public byte[] R;
        public byte[] K;
        public byte[] S;
        public byte[] W;

        public KeyData(byte[] P, byte[] A, byte[] B, byte[] G, byte[] R, byte[] K, byte[] S, byte[] W) {
            this.P = P;
            this.A = A;
            this.B = B;
            this.G = G;
            this.R = R;
            this.K = K;
            this.S = S;
            this.W = W;
        }
    }
}

