/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;

public class Channel {
    private int id;
    private short sw_status;
    private ResponseAPDU apdu;

    public Channel(int id, ResponseAPDU apdu) {
        this.id = id;
        this.apdu = apdu;
        this.sw_status = (short)apdu.sw();
    }

    public int getChannelNumber() {
        return this.id;
    }

    public short getSWStatus() {
        return this.sw_status;
    }

    public CommandAPDU createAPDUtoChannel(byte[] data) {
        if (this.id < 0) {
            throw new IllegalArgumentException(I18n.getString("channel.not.open"));
        }
        int cla = data[0] & 0xF0;
        if (cla != 0 && cla != 128 && cla != 144 && cla != 160) {
            throw new IllegalArgumentException(I18n.getString("incorrect.cla"));
        }
        data[0] = (byte)(data[0] | this.id & 3);
        return new CommandAPDU(data);
    }

    public ResponseAPDU getApdu() {
        return this.apdu;
    }

    public String toString() {
        return I18n.getString("channel.number", new Integer(this.getChannelNumber()), Integer.toHexString(this.getSWStatus() & 0xFFFF));
    }
}

