/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ArgumentParser {
    private Hashtable set = new Hashtable();
    private Hashtable duplicates;
    private Hashtable one;
    private Hashtable two;

    public ArgumentParser() {
        this(null, null, null);
    }

    public ArgumentParser(String[] onePosition, String[] twoPosition, String[] allowDuplicate) {
        this.duplicates = this.createKeyHash(allowDuplicate);
        this.one = this.createKeyHash(onePosition);
        this.two = this.createKeyHash(twoPosition);
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (this.one.get(args[i]) != null) {
                this.setOption(args[i], "");
                continue;
            }
            if (this.two.get(args[i]) != null) {
                if (i < args.length - 1) {
                    this.setOption(args[i], args[++i]);
                    continue;
                }
                throw new IllegalArgumentException(I18n.getString("bad.argument", args[i]));
            }
            throw new IllegalArgumentException(I18n.getString("argument.not.specified", args[i]));
        }
    }

    private Hashtable createKeyHash(String[] keys) {
        Hashtable<String, String> retVal = new Hashtable<String, String>();
        if (keys != null) {
            for (int i = 0; i < keys.length; ++i) {
                retVal.put(keys[i], "ok");
            }
        }
        return retVal;
    }

    public void setOption(String option, String value, boolean isDuplicate) {
        Vector<String> h = (Vector<String>)this.set.get(option);
        if (h == null) {
            h = new Vector<String>();
            this.set.put(option, h);
        } else if (!isDuplicate) {
            throw new IllegalArgumentException(I18n.getString("option.can.not.duplicated", option));
        }
        h.addElement(value);
    }

    public void setOption(String option, String value) {
        this.setOption(option, value, this.duplicates.get(option) != null);
    }

    public String getSingleOption(String option, String defaultOption) {
        String retVal = this.getSingleOption(option, true);
        return retVal == null ? defaultOption : retVal;
    }

    public String getSingleOption(String option, boolean returnNull) {
        Vector h = (Vector)this.set.get(option);
        if (h == null) {
            if (returnNull) {
                return null;
            }
            throw new IllegalArgumentException(I18n.getString("undefined.option", option));
        }
        if (h.size() != 1) {
            throw new IllegalArgumentException(I18n.getString("not.single.option", option, h));
        }
        return (String)h.elementAt(0);
    }

    public Enumeration getOption(String option) {
        Vector h = (Vector)this.set.get(option);
        if (h == null) {
            return new Vector().elements();
        }
        return h.elements();
    }

    public Vector getOptionVector(String option) {
        return (Vector)this.set.get(option);
    }

    public int getOptionCount(String option) {
        Vector h = (Vector)this.set.get(option);
        if (h == null) {
            return 0;
        }
        return h.size();
    }

    public boolean contains(String option) {
        return this.set.get(option) != null;
    }

    public String getFirstSingleOptionFromList(String[] options, boolean returnNull) {
        String retVal = null;
        if (options == null || options.length == 0) {
            return this.getSingleOption(null, returnNull);
        }
        for (int i = 0; i < options.length - 1; ++i) {
            retVal = this.getSingleOption(options[i], true);
            if (retVal == null) continue;
            return retVal;
        }
        return this.getSingleOption(options[options.length - 1], returnNull);
    }

    public static String getDirname(String name) {
        int pos = name.lastIndexOf(File.separator);
        return pos > 0 ? name.substring(0, pos) : "";
    }

    public static String getBasename(String name) {
        int pos = name.lastIndexOf(File.separator);
        if (pos < 0) {
            return name;
        }
        return pos < name.length() - 1 ? name.substring(pos + 1) : name;
    }
}

