/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.ToolsVersion;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.CompareVersion;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.io.File;

class VerifyRev {
    static int verbose = 1;
    static boolean printTrace = false;

    VerifyRev() {
    }

    public static void main(String[] stringArray) {
        String string;
        boolean bl = true;
        int n = 0;
        while (n < stringArray.length && stringArray[n].length() > 0 && stringArray[n].charAt(0) == '-') {
            string = stringArray[n];
            if (string.equals("-verbose")) {
                ++verbose;
            } else if (string.equals("-nobanner")) {
                bl = false;
            } else if (string.equals("-nowarn")) {
                VerifierError.noWarn = true;
            } else if (string.equals("-help")) {
                VerifyRev.printUsageAndExit();
            } else if (string.equals("-version")) {
                Messages.println("MainRev.3", new Object[]{ToolsVersion.getProductName(), ToolsVersion.getVersion(2)});
                Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
                System.exit(2);
            } else {
                VerifyRev.printUsageAndExit();
            }
            ++n;
        }
        if (n + 2 != stringArray.length) {
            VerifyRev.printUsageAndExit();
        }
        if (verbose >= 1 && bl) {
            Messages.println("MainRev.3", ToolsVersion.getVersion(2));
        }
        Messages.exactPrintLn(ToolsVersion.getCopyrightBanner());
        string = stringArray[n];
        String string2 = stringArray[n + 1];
        if (string == string2) {
            VerifyRev.printUsageAndExit();
        }
        if (!string.endsWith(".exp") || !string2.endsWith(".exp")) {
            VerifyRev.printUsageAndExit();
        }
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.getName().equals(file2.getName())) {
            VerifyRev.printUsageAndExit();
        }
        if (verbose >= 1) {
            Messages.println("MainRev.4", string, (Object)string2);
        }
        try {
            ExportFile exportFile = ExportFile.readFromFile(file);
            ExportFile exportFile2 = ExportFile.readFromFile(file2);
            CompareVersion.compare(exportFile, exportFile2);
        }
        catch (VerifierError verifierError) {
            Messages.printTo(System.err);
            Messages.println("MainRev.2", Messages.numWarning, (Object)verifierError.getMessage(), (Object)Messages.format("MainRev.7"));
            System.exit(2);
        }
        Messages.println("MainRev.5", Messages.numWarning);
    }

    private static void printUsageAndExit() {
        Messages.printTo(System.err);
        Messages.println("MainRev.1");
        System.exit(2);
    }
}

