/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.AID;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassAndFieldDescriptor;
import com.sun.javacard.offcardverifier.ClassAndMethodDescriptor;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.FieldTypeAndFlags;
import com.sun.javacard.offcardverifier.Fieldref;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.MethodTypeAndFlags;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.PackageInfo;
import com.sun.javacard.offcardverifier.Safeptr;
import com.sun.javacard.offcardverifier.Type;
import com.sun.javacard.offcardverifier.TypeMethod;
import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.TreeSet;
import java.util.Vector;

class ExportComponent
extends Safeptr {
    ExportFile exportfile = null;
    ExportFile thisExportFile = null;
    Vector alreadyVerified = new Vector();

    ExportComponent(byte[] byArray) {
        super(byArray, "Export");
    }

    int classCount() {
        return this.u1(0);
    }

    ExportedClass firstExportedClass() {
        return new ExportedClass(this.offset(1));
    }

    void findExportFile() {
        PackageInfo packageInfo = Cap.Header.thisPackage();
        this.exportfile = ImportComponent.findExportByAidAndVersion(packageInfo);
        this.thisExportFile = ImportComponent.findExportByAidAndVersion(packageInfo);
        if (this.exportfile == null) {
            throw new VerifierError("ExportComponent.1", (Object)AID.pretty(packageInfo), packageInfo.majorVersion(), packageInfo.minorVersion());
        }
    }

    void verify() {
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.101");
        }
        if (this.classCount() >= 256) {
            throw new VerifierError("ExportComponent.2", this.classCount());
        }
        if (this.classCount() == 0) {
            throw new VerifierError("ExportComponent.44");
        }
        ExportedClass exportedClass = this.firstExportedClass();
        int n = 0;
        while (n < this.classCount()) {
            this.verifyClass(n, exportedClass);
            exportedClass.next();
            ++n;
        }
        if (!exportedClass.atComponentEnd()) {
            throw new VerifierError("ExportComponent.3");
        }
        if (Verifier.verbose >= 2) {
            Messages.println("ExportComponent.102", this.exportfile.file);
        }
        this.verifyExport();
    }

    private void verifyClass(int n, ExportedClass exportedClass) {
        Object object;
        int n2;
        ClassDescriptor classDescriptor = Classref.checkInternal(exportedClass.classOffset());
        if ((classDescriptor.flags() & 1) == 0) {
            throw new VerifierError("ExportComponent.6", n);
        }
        if (classDescriptor.token() != n) {
            throw new VerifierError("ExportComponent.7", classDescriptor.token(), n);
        }
        if (exportedClass.staticFieldCount() > 256) {
            throw new VerifierError("ExportComponent.8", n, exportedClass.staticFieldCount());
        }
        int n3 = 0;
        while (n3 < exportedClass.staticFieldCount()) {
            n2 = exportedClass.staticFieldOffset(n3);
            ClassAndFieldDescriptor classAndFieldDescriptor = Fieldref.findDescr(n2);
            object = classAndFieldDescriptor.fieldDescr;
            if ((((FieldDescriptor)object).flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.9", n2);
            }
            if (((FieldDescriptor)object).token() != n3) {
                throw new VerifierError("ExportComponent.10", ((FieldDescriptor)object).token(), n3);
            }
            if (classAndFieldDescriptor.classDescr.thisClass() != exportedClass.classOffset()) {
                throw new VerifierError("ExportComponent.47", n3, classAndFieldDescriptor.classDescr.thisClass(), exportedClass.classOffset());
            }
            ++n3;
        }
        if (exportedClass.staticFieldCount() != classDescriptor.num_exported_static_fields()) {
            throw new VerifierError("ExportComponent.45", exportedClass.classOffset());
        }
        if (exportedClass.staticMethodCount() > 256) {
            throw new VerifierError("ExportComponent.11", n);
        }
        n2 = 0;
        while (n2 < exportedClass.staticMethodCount()) {
            int n4 = exportedClass.staticMethodOffset(n2);
            object = Methodref.findDescr(n4);
            MethodDescriptor methodDescriptor = ((ClassAndMethodDescriptor)object).methodDescr;
            if ((methodDescriptor.flags() & 0x88) == 0) {
                throw new VerifierError("ExportComponent.12", n4);
            }
            if ((methodDescriptor.flags() & 5) == 0) {
                throw new VerifierError("ExportComponent.13", n4);
            }
            if (methodDescriptor.token() != n2) {
                throw new VerifierError("ExportComponent.14", methodDescriptor.token(), n2);
            }
            if (((ClassAndMethodDescriptor)object).classDescr.thisClass() != exportedClass.classOffset()) {
                throw new VerifierError("ExportComponent.48", n2, ((ClassAndMethodDescriptor)object).classDescr.thisClass(), exportedClass.classOffset());
            }
            ++n2;
        }
        if (exportedClass.staticMethodCount() != classDescriptor.num_exported_static_methods()) {
            throw new VerifierError("ExportComponent.46", exportedClass.classOffset());
        }
    }

    private void verifyExport() {
        boolean bl;
        if (!Cap.packageDirectory.equals(this.exportfile.thisName())) {
            throw new VerifierError("ExportComponent.39", (Object)this.exportfile.thisName(), (Object)Cap.packageDirectory);
        }
        boolean bl2 = (this.exportfile.thisPackage().flags & 1) != 0;
        if (bl2 != !(bl = (Cap.Header.flags() & 4) != 0)) {
            throw new VerifierError("ExportComponent.40");
        }
        int n = 0;
        while (n < this.exportfile.classes.length) {
            EfClass efClass = this.exportfile.classes[n];
            this.checkExportClass(efClass);
            ++n;
        }
        if (this.exportfile.classes.length != Cap.Export.classCount()) {
            throw new VerifierError("ExportComponent.41");
        }
    }

    private void checkExportClass(EfClass efClass) {
        try {
            int n = Classref.forExportToken(efClass.token);
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            int n2 = 0;
            if ((efClass.accessFlag & 1) != 0) {
                n2 |= 1;
            }
            if ((efClass.accessFlag & 0x10) != 0) {
                n2 |= 0x10;
            }
            if ((efClass.accessFlag & 0x200) != 0) {
                n2 |= 0x40;
            }
            if ((efClass.accessFlag & 0x400) != 0) {
                n2 |= 0x80;
            }
            if (n2 != classDescriptor.flags()) {
                throw new VerifierError("ExportComponent.18");
            }
            if (!this.allClaimedInterfaces(efClass).equals(this.allActualInterfaces(n))) {
                throw new VerifierError("ExportComponent.19");
            }
            if (!this.allClaimedSuperclasses(efClass).equals(this.allActualSuperclasses(n))) {
                throw new VerifierError("ExportComponent.20");
            }
            int n3 = 0;
            int n4 = 0;
            while (n4 < efClass.fields.length) {
                EfField efField = efClass.fields[n4];
                if (efField.token == 255) {
                    if (efField.sig().equals("I")) {
                        Cap.Header.useInts();
                    }
                } else {
                    this.checkExportField(efClass, efField, classDescriptor.thisClass());
                    ++n3;
                }
                ++n4;
            }
            if (n3 != this.numPublicFields(classDescriptor)) {
                throw new VerifierError("ExportComponent.42");
            }
            int n5 = 0;
            while (n5 < efClass.methods.length) {
                EfMethod efMethod = efClass.methods[n5];
                ExportComponent.checkExportMethod(efClass, efMethod, classDescriptor.thisClass());
                ++n5;
            }
            if (efClass.methods.length != this.numPublicMethods(classDescriptor)) {
                throw new VerifierError("ExportComponent.43");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportComponent.21", (Object)efClass, (Object)verifierError.getMessage());
        }
    }

    private void checkExportField(EfClass efClass, EfField efField, int n) {
        try {
            boolean bl = (efField.accessFlag & 8) != 0;
            FieldTypeAndFlags fieldTypeAndFlags = Fieldref.findByToken(n, efField.token, bl);
            int n2 = 0;
            if ((efField.accessFlag & 1) != 0) {
                n2 |= 1;
            }
            if ((efField.accessFlag & 4) != 0) {
                n2 |= 4;
            }
            if ((efField.accessFlag & 8) != 0) {
                n2 |= 8;
            }
            if ((efField.accessFlag & 0x10) != 0) {
                n2 |= 0x10;
            }
            if (n2 != fieldTypeAndFlags.flags) {
                throw new VerifierError("ExportComponent.28");
            }
            Type type = Type.parseExport(efField.sig());
            if (!type.equals(fieldTypeAndFlags.fty)) {
                throw new VerifierError("ExportComponent.29");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportComponent.30", (Object)efField, (Object)verifierError.getMessage());
        }
    }

    public static void checkExportMethod(EfClass efClass, EfMethod efMethod, int n) {
        try {
            boolean bl = (efMethod.accessFlag & 8) != 0 || efMethod.name().equals("<init>");
            MethodTypeAndFlags methodTypeAndFlags = Methodref.findByToken(n, efMethod.token, bl);
            if (methodTypeAndFlags == null) {
                throw new VerifierError("ExportComponent.38");
            }
            int n2 = 0;
            if ((efMethod.accessFlag & 1) != 0) {
                n2 |= 1;
            }
            if ((efMethod.accessFlag & 4) != 0) {
                n2 |= 4;
            }
            if ((efMethod.accessFlag & 8) != 0) {
                n2 |= 8;
            }
            if ((efMethod.accessFlag & 0x10) != 0) {
                n2 |= 0x10;
            }
            if ((efMethod.accessFlag & 0x400) != 0) {
                n2 |= 0x40;
            }
            if (efMethod.name().equals("<init>")) {
                n2 |= 0x80;
            }
            if (n2 != methodTypeAndFlags.flags) {
                throw new VerifierError("ExportComponent.33");
            }
            TypeMethod typeMethod = TypeMethod.parseExport(efMethod.sig());
            if (!typeMethod.equals(methodTypeAndFlags.mty)) {
                throw new VerifierError("ExportComponent.34");
            }
        }
        catch (VerifierError verifierError) {
            throw new VerifierError("ExportComponent.35", (Object)efMethod, (Object)verifierError.getMessage());
        }
    }

    private TreeSet allClaimedSuperclasses(EfClass efClass) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < efClass.supers.length) {
            treeSet.add(efClass.superName(n));
            ++n;
        }
        return treeSet;
    }

    private TreeSet allClaimedInterfaces(EfClass efClass) {
        TreeSet<String> treeSet = new TreeSet<String>();
        int n = 0;
        while (n < efClass.interfaces.length) {
            treeSet.add(efClass.interfaceName(n));
            ++n;
        }
        return treeSet;
    }

    private TreeSet allActualSuperclasses(int n) {
        EfClass efClass;
        TreeSet<String> treeSet = new TreeSet<String>();
        if ((Cap.Class.infoOfs(n).flags() & 8) != 0) {
            treeSet.add("java/lang/Object");
            return treeSet;
        }
        do {
            if ((n = Cap.Class.infoOfs(n).superclass()) == 65535) {
                return treeSet;
            }
            efClass = Classref.toExportClass(n);
            if (efClass == null) continue;
            treeSet.add(efClass.thisName());
        } while (!Classref.isExternal(n));
        efClass = Classref.toExportClass(n);
        treeSet.add(efClass.thisName());
        int n2 = 0;
        while (n2 < efClass.supers.length) {
            treeSet.add(efClass.superName(n2));
            ++n2;
        }
        return treeSet;
    }

    private TreeSet allActualInterfaces(int n) {
        TreeSet<String> treeSet = new TreeSet<String>();
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        if ((classInfo.flags() & 8) != 0) {
            int n2 = 0;
            while (n2 < classInfo.interfaceCount()) {
                int n3 = classInfo.superinterface(n2);
                this.addInterfaceAndSuperinterfaces(treeSet, n3);
                ++n2;
            }
        } else {
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            int n4 = 0;
            while (n4 < classDescriptor.interfaceCount()) {
                int n5 = classDescriptor.interfaceRef(n4);
                EfClass efClass = Classref.toExportClass(n5);
                if (efClass != null) {
                    treeSet.add(efClass.thisName());
                }
                ++n4;
            }
        }
        return treeSet;
    }

    private void addInterfaceAndSuperinterfaces(TreeSet treeSet, int n) {
        EfClass efClass = Classref.toExportClass(n);
        treeSet.add(efClass.thisName());
        if (Classref.isExternal(n)) {
            int n2 = 0;
            while (n2 < efClass.interfaces.length) {
                treeSet.add(efClass.interfaceName(n2));
                ++n2;
            }
        } else {
            ClassInfo classInfo = Cap.Class.infoOfs(n);
            int n3 = 0;
            while (n3 < classInfo.interfaceCount()) {
                int n4 = classInfo.superinterface(n3);
                this.addInterfaceAndSuperinterfaces(treeSet, n4);
                ++n3;
            }
        }
    }

    private boolean checkImplementedInterface(int n, String string) {
        if (!Classref.isExternal(n)) {
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            int n2 = 0;
            while (n2 < classDescriptor.interfaceCount()) {
                int n3 = classDescriptor.interfaceRef(n2);
                EfClass efClass = Classref.toExportClass(n3);
                if (efClass != null && string.equals(efClass.thisName())) {
                    return true;
                }
                if (this.checkImplementedInterface(n3, string)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        EfClass efClass = Classref.toExportClass(n);
        int n4 = 0;
        while (n4 < efClass.interfaces.length) {
            if (string.equals(efClass.interfaceName(n4))) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    EfClass exportclassForToken(int n) {
        int n2 = 0;
        while (n2 < this.exportfile.classes.length) {
            EfClass efClass = this.exportfile.classes[n2];
            if (efClass.token == n) {
                return efClass;
            }
            ++n2;
        }
        throw new VerifierError("ExportComponent.36", n);
    }

    private int numPublicFields(ClassDescriptor classDescriptor) {
        int n = 0;
        int n2 = 0;
        while (n2 < classDescriptor.fieldCount()) {
            FieldDescriptor fieldDescriptor = classDescriptor.fieldDescr(n2);
            if ((fieldDescriptor.flags() & 5) != 0) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private int numPublicMethods(ClassDescriptor classDescriptor) {
        int n = 0;
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = 0;
        while (n2 < classDescriptor.methodCount()) {
            MethodDescriptor methodDescriptor = classDescriptor.methodDescr(n2);
            if ((methodDescriptor.flags() & 5) != 0) {
                if ((methodDescriptor.flags() & 0x88) != 0) {
                    ++n;
                } else {
                    treeSet.add(new Integer(methodDescriptor.token()));
                }
            }
            ++n2;
        }
        if ((classDescriptor.flags() & 0x40) == 0) {
            Object object;
            int n3;
            Object object2;
            int n4 = classDescriptor.thisClass();
            while (!Classref.isExternal(n4 = Cap.Class.infoOfs(n4).superclass())) {
                object2 = Classref.checkInternal(n4);
                n3 = 0;
                while (n3 < ((ClassDescriptor)object2).methodCount()) {
                    object = ((ClassDescriptor)object2).methodDescr(n3);
                    if ((((MethodDescriptor)object).flags() & 5) != 0 && (((MethodDescriptor)object).flags() & 0x88) == 0) {
                        treeSet.add(new Integer(((MethodDescriptor)object).token()));
                    }
                    ++n3;
                }
            }
            if (n4 != 65535) {
                object2 = Classref.checkExternal(n4);
                n3 = 0;
                while (n3 < ((EfClass)object2).methods.length) {
                    object = ((EfClass)object2).methods[n3];
                    if (!((EfMethod)object).isStaticOrInit()) {
                        treeSet.add(new Integer(((EfMethod)object).token));
                    }
                    ++n3;
                }
            }
        }
        return n + treeSet.size();
    }
}

