/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier;

import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.ExportedClass;
import com.sun.javacard.offcardverifier.ImportComponent;
import com.sun.javacard.offcardverifier.Messages;
import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;

class Classref {
    static int multiSelectable = -1;
    static int Object;
    static int Throwable;
    static int Shareable;
    static int Remote;

    Classref() {
    }

    static boolean isExternal(int n) {
        return (n & 0x8000) != 0;
    }

    static int packageToken(int n) {
        return n >> 8 & 0x7F;
    }

    static int classToken(int n) {
        return n & 0xFF;
    }

    static ClassDescriptor checkInternal(int n) {
        ClassDescriptor classDescriptor = Cap.Descriptor.firstClassDescriptor();
        int n2 = Cap.Descriptor.classCount();
        while (n2 > 0) {
            if (n == classDescriptor.thisClass()) {
                return classDescriptor;
            }
            --n2;
            classDescriptor.next();
        }
        throw new VerifierError("Classref.1", n);
    }

    static EfClass checkExternal(int n) {
        int n2 = Classref.packageToken(n);
        int n3 = Classref.classToken(n);
        ExportFile exportFile = Cap.Import.importPackage(n2);
        if (exportFile == null) {
            throw new VerifierError("Classref.2", n, n2);
        }
        int n4 = 0;
        while (n4 < exportFile.classes.length) {
            EfClass efClass = exportFile.classes[n4];
            if (efClass.token == n3) {
                return efClass;
            }
            ++n4;
        }
        throw new VerifierError("Classref.3", n, n3);
    }

    static EfClass exportclassForExternal(int n) {
        int n2 = Classref.packageToken(n);
        int n3 = Classref.classToken(n);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n2);
        if (exportFile == null) {
            throw new VerifierError("Classref.4", n, n2);
        }
        int n4 = 0;
        while (n4 < exportFile.classes.length) {
            EfClass efClass = exportFile.classes[n4];
            if (efClass.token == n3) {
                return efClass;
            }
            ++n4;
        }
        throw new VerifierError("Classref.5", n, n3);
    }

    static void check(int n) {
        if (Classref.isExternal(n)) {
            Classref.checkExternal(n);
        } else {
            Classref.checkInternal(n);
        }
    }

    static int checkAndGetAccessFlags(int n) {
        if (!Classref.isExternal(n)) {
            ClassDescriptor classDescriptor = Classref.checkInternal(n);
            return classDescriptor.flags();
        }
        EfClass efClass = Classref.checkExternal(n);
        int n2 = 0;
        if ((efClass.accessFlag & 1) != 0) {
            n2 |= 1;
        }
        if ((efClass.accessFlag & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((efClass.accessFlag & 0x200) != 0) {
            n2 |= 0x40;
        }
        if ((efClass.accessFlag & 0x400) != 0) {
            n2 |= 0x80;
        }
        return n2;
    }

    static boolean isSubclass(int n, int n2) {
        while (!Classref.isExternal(n)) {
            if (n == n2) {
                return true;
            }
            n = Cap.Class.infoOfs(n).superclass();
        }
        if (n == n2) {
            return true;
        }
        if (!Classref.isExternal(n2)) {
            return false;
        }
        EfClass efClass = Classref.exportclassForExternal(n);
        EfClass efClass2 = Classref.exportclassForExternal(n2);
        int n3 = 0;
        while (n3 < efClass.supers.length) {
            if (efClass.superName(n3).equals(efClass2.thisName())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static int lub(int n, int n2) {
        int n3;
        EfClass efClass;
        String string;
        while (!Classref.isExternal(n) && !Classref.isExternal(n2)) {
            if (n == n2) {
                return n;
            }
            if (Classref.isSubclass(n, n2)) {
                return n2;
            }
            if (Classref.isSubclass(n2, n)) {
                return n;
            }
            n = Cap.Class.infoOfs(n).superclass();
            n2 = Cap.Class.infoOfs(n2).superclass();
        }
        while (!Classref.isExternal(n)) {
            n = Cap.Class.infoOfs(n).superclass();
        }
        while (!Classref.isExternal(n2)) {
            n2 = Cap.Class.infoOfs(n2).superclass();
        }
        if (n == n2) {
            return n;
        }
        EfClass efClass2 = Classref.exportclassForExternal(n);
        String string2 = efClass2.thisName();
        if (string2.equals(string = (efClass = Classref.exportclassForExternal(n2)).thisName())) {
            return n;
        }
        int n4 = 0;
        while (n4 < efClass2.supers.length) {
            if (efClass2.superName(n4).equals(string)) {
                return n2;
            }
            ++n4;
        }
        int n5 = 0;
        while (n5 < efClass.supers.length) {
            if (efClass.superName(n5).equals(string2)) {
                return n;
            }
            ++n5;
        }
        int[] nArray = new int[efClass2.supers.length + efClass.supers.length];
        int n6 = 0;
        int n7 = 0;
        while (n7 < efClass2.supers.length) {
            String string3 = efClass2.superName(n7);
            n3 = 0;
            while (n3 < efClass.supers.length) {
                if (string3.equals(efClass.superName(n3))) {
                    nArray[n6] = Classref.refForName(string3);
                    ++n6;
                    break;
                }
                ++n3;
            }
            ++n7;
        }
        int n8 = 0;
        while (n8 < n6) {
            n3 = nArray[n8];
            int n9 = 0;
            while (n9 < n6 && Classref.isSubclass(n3, nArray[n9])) {
                ++n9;
            }
            if (n9 == n6) {
                return n3;
            }
            ++n8;
        }
        throw new VerifierError("Classref.9", (Object)efClass2.thisName(), (Object)efClass.thisName());
    }

    static boolean isSameOrSuper(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (!Classref.isExternal(n)) {
            return n2 == Cap.Class.infoOfs(n).superclass();
        }
        if (!Classref.isExternal(n2)) {
            return false;
        }
        EfClass efClass = Classref.exportclassForExternal(n);
        EfClass efClass2 = Classref.exportclassForExternal(n2);
        int n3 = 0;
        while (n3 < efClass.supers.length) {
            if (efClass.superName(n3).equals(efClass2.thisName())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    static EfClass exportclassForName(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            throw new VerifierError("Classref.6", string);
        }
        String string2 = string.substring(0, n);
        int n2 = Cap.Import.tokenForPackage(string2);
        ExportFile exportFile = Cap.Import.exportfileForPackageToken(n2);
        int n3 = 0;
        while (n3 < exportFile.classes.length) {
            EfClass efClass = exportFile.classes[n3];
            if (string.equals(efClass.thisName())) {
                return efClass;
            }
            ++n3;
        }
        return null;
    }

    static int refForName(String string) {
        Object object;
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 == -1) {
            throw new VerifierError("Classref.6", string);
        }
        String string2 = string.substring(0, n2);
        if (Cap.Export != null && string2.equals(Cap.Export.exportfile.thisName())) {
            n = 0;
            while (n < Cap.Export.exportfile.classes.length) {
                object = Cap.Export.exportfile.classes[n];
                if (string.equals(((EfClass)object).thisName())) {
                    return Classref.forExportToken(((EfClass)object).token);
                }
                ++n;
            }
        }
        n = Cap.Import.tokenForPackage(string2);
        object = Cap.Import.exportfileForPackageToken(n);
        int n3 = 0;
        while (n3 < ((ExportFile)object).classes.length) {
            EfClass efClass = ((ExportFile)object).classes[n3];
            if (string.equals(efClass.thisName())) {
                return 0x8000 | n << 8 | efClass.token;
            }
            ++n3;
        }
        throw new VerifierError("Classref.7", (Object)string, (Object)string2);
    }

    static int forExportToken(int n) {
        ExportedClass exportedClass = Cap.Export.firstExportedClass();
        int n2 = 0;
        while (n2 < Cap.Export.classCount()) {
            if (n2 == n) {
                return exportedClass.classOffset();
            }
            exportedClass.next();
            ++n2;
        }
        throw new VerifierError("Classref.8", n);
    }

    static EfClass toExportClass(int n) {
        if (Classref.isExternal(n)) {
            return Classref.checkExternal(n);
        }
        ClassDescriptor classDescriptor = Classref.checkInternal(n);
        if (classDescriptor.token() == 255) {
            return null;
        }
        return Cap.Export.exportclassForToken(classDescriptor.token());
    }

    static boolean implementsInterface(int n, int n2) {
        if (Classref.isExternal(n)) {
            if (!Classref.isExternal(n2)) {
                return false;
            }
            EfClass efClass = Classref.exportclassForExternal(n);
            EfClass efClass2 = Classref.exportclassForExternal(n2);
            int n3 = 0;
            while (n3 < efClass.interfaces.length) {
                if (efClass.interfaceName(n3).equals(efClass2.thisName())) {
                    return true;
                }
                ++n3;
            }
            int n4 = 0;
            while (n4 < efClass.supers.length) {
                EfClass efClass3 = Classref.exportclassForName(efClass.superName(n4));
                if (efClass3 != null) {
                    int n5 = 0;
                    while (n4 < efClass3.interfaces.length) {
                        if (efClass3.interfaceName(n5).equals(efClass2.thisName())) {
                            return true;
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
            return false;
        }
        ClassDescriptor classDescriptor = Classref.checkInternal(n);
        int n6 = 0;
        while (n6 < classDescriptor.interfaceCount()) {
            if (Classref.extendsInterface(classDescriptor.interfaceRef(n6), n2)) {
                return true;
            }
            ++n6;
        }
        if ((classDescriptor.flags() & 0x40) != 0) {
            return false;
        }
        int n7 = Cap.Class.infoOfs(n).superclass();
        if (n7 == 65535) {
            return false;
        }
        return Classref.implementsInterface(n7, n2);
    }

    static boolean extendsInterface(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (Classref.isExternal(n)) {
            if (!Classref.isExternal(n2)) {
                return false;
            }
            EfClass efClass = Classref.exportclassForExternal(n);
            EfClass efClass2 = Classref.exportclassForExternal(n2);
            int n3 = 0;
            while (n3 < efClass.interfaces.length) {
                if (efClass.interfaceName(n3).equals(efClass2.thisName())) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        int n4 = 0;
        while (n4 < classInfo.interfaceCount()) {
            if (classInfo.superinterface(n4) == n2) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    static int numberOfMethods(int n) {
        if (Classref.isExternal(n)) {
            return Classref.checkExternal((int)n).methods.length;
        }
        return Classref.checkInternal(n).methodCount();
    }

    static int totalInstanceSize(int n) {
        if (Classref.isExternal(n)) {
            EfClass efClass = Classref.checkExternal(n);
            int n2 = efClass.declaredInstanceSize();
            int n3 = 0;
            while (n3 < efClass.supers.length) {
                n2 += Classref.exportclassForName(efClass.superName(n3)).declaredInstanceSize();
                ++n3;
            }
            return n2;
        }
        ClassInfo classInfo = Cap.Class.infoOfs(n);
        if ((classInfo.flags() & 8) != 0) {
            return 0;
        }
        if (classInfo.superclass() == 65535) {
            return classInfo.declaredInstanceSize();
        }
        return Classref.totalInstanceSize(classInfo.superclass()) + classInfo.declaredInstanceSize();
    }

    static String pretty(int n) {
        if (Classref.isExternal(n)) {
            EfClass efClass = Classref.checkExternal(n);
            return efClass.thisName().replace('/', '.');
        }
        return Messages.format("Classref.10", n);
    }

    static boolean isMultiSelectable(int n) {
        if (multiSelectable == -1) {
            try {
                multiSelectable = Classref.refForName("javacard/framework/MultiSelectable");
            }
            catch (VerifierError verifierError) {
                return false;
            }
        }
        return Classref.implementsInterface(n, multiSelectable);
    }

    static boolean isRemote(int n, boolean bl) {
        if (Remote == -1) {
            try {
                Remote = Classref.refForName("java/rmi/Remote");
            }
            catch (VerifierError verifierError) {
                return false;
            }
        }
        if (bl) {
            return Classref.implementsInterface(n, Remote);
        }
        return Classref.extendsInterface(n, Remote);
    }

    static void initialize() {
        Object = Classref.refForName("java/lang/Object");
        Throwable = Classref.refForName("java/lang/Throwable");
        try {
            Shareable = Classref.refForName("javacard/framework/Shareable");
        }
        catch (VerifierError verifierError) {
            if (ImportComponent.findExportByName("javacard/framework") != null) {
                VerifierError.warning("Classref.100");
            }
            Shareable = -1;
        }
    }

    static {
        Remote = -1;
    }
}

