/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.mask;

import com.sun.javacard.jcasm.AppletDeclarator;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.mask.CrefOutputFormatter;
import com.sun.javacard.jcasm.mask.Main;
import com.sun.javacard.jcasm.mask.PackageTableEntry;
import com.sun.javacard.jcasm.mask.RomMask;
import java.util.Enumeration;

class PackageTableManager {
    private static final byte TYPE_SIMPLE_OBJECT = 32;
    private static final byte TYPE_BYTE_ARRAY = -128;
    private static final byte TYPE_REFERENCE_ARRAY = -32;
    protected static final byte JCRE_CONTEXT = 0;
    public static final int MAX_AID_SIZE = 16;
    public static final int PACKAGE_MAX = 33;
    public static final int APPLET_PACKAGE_MAX = 16;
    public static final String SINGLE_BYTE_FILLER = "0x00, ";
    public static final int CLASS_COMPONENT = 0;
    public static final int METHOD_COMPONENT = 1;
    public static final int STATIC_FIELD_COMPONENT = 2;
    public static final int EXPORT_COMPONENT = 3;
    private static final int AID_OBJECT_SIZE = 7;
    protected static final int REF_ARRAY_HEADER_SIZE = 10;
    protected static final int REF_SIZE = 2;
    static int byteClassOffset;
    static int refClassOffset;
    static int VMArrayImplementationPkg;
    static int AIDClassOffset;
    static int AIDClassPkgId;
    protected static int packageEntryClassRef;
    static int pkgEntryPkgId;
    protected static int appletEntryClassOffset;
    protected static int appletEntryPkgId;
    static int packageTableReference;
    static int packageContextTableReference;
    RomMask rommask;
    static PackageTableEntry[] packages;
    static byte[] appletPkgContextTable;
    int packageCount = 0;
    int currentPackageEntryCount = 0;
    int packageLocTableAddress;
    private static byte[] targetPackageMgrTable;
    protected static StringBuffer packageTableManagerBuffer;

    PackageTableManager() {
        packageEntryClassRef = 0;
        appletPkgContextTable = new byte[16];
        packages = new PackageTableEntry[33];
        packageTableManagerBuffer = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            PackageTableManager.appletPkgContextTable[i] = -1;
        }
    }

    PackageTableEntry addPackage(JCPackage p) {
        PackageTableEntry pe = new PackageTableEntry(p);
        if (this.packageCount >= 33) {
            Msg.error("cref.5", null);
            Main.printStatus();
        }
        PackageTableManager.packages[this.packageCount] = pe;
        ++this.packageCount;
        return pe;
    }

    PackageTableEntry getPackageEntry(JCPackage p) {
        for (int i = 0; i < 33; ++i) {
            if (packages[i] == null || !PackageTableManager.packages[i].packageInfo.equals(p)) continue;
            return packages[i];
        }
        return null;
    }

    void addAppletPackageContext(int pkgContext) {
        int i;
        for (i = 0; i < 16; ++i) {
            if (appletPkgContextTable[i] != -1) continue;
            PackageTableManager.appletPkgContextTable[i] = (byte)pkgContext;
            break;
        }
        if (i >= 16) {
            Msg.error("cref.6", null);
            Main.printStatus();
        }
    }

    byte getPkgContextForIndex(int index) {
        for (byte i = 0; i < 16; i = (byte)(i + 1)) {
            if (appletPkgContextTable[i] != index) continue;
            return i;
        }
        return -1;
    }

    static int getCompBaseAddress(JCPackage p, int compId) {
        for (int i = 0; i < 33; ++i) {
            PackageTableEntry pe = packages[i];
            if (!pe.packageInfo.equals(p)) continue;
            return pe.componentInfoReference[compId].compLocation;
        }
        return 0;
    }

    protected static int createAIDObject(byte[] aidBytes, boolean isEntryPointObject) {
        int currentROMAddr = CrefOutputFormatter.cof.currentRomAddr;
        byte[] aidArray = PackageTableManager.createByteArrayObject((short)aidBytes.length, aidBytes, (byte)0, false);
        int aidArrayRef = CrefOutputFormatter.objectManager.addObject(currentROMAddr);
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID Array @" + Msg.toAddressString(currentROMAddr) + " */");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(aidArray, ", ") + "," + Msg.eol);
        byte[] aidObject = new byte[7];
        PackageTableManager.createSimpleObjectHeader(aidObject, AIDClassOffset, (byte)0, isEntryPointObject, AIDClassPkgId);
        aidObject[5] = (byte)(aidArrayRef >> 8);
        aidObject[6] = (byte)aidArrayRef;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID Object @" + Msg.toAddressString(currentROMAddr += aidArray.length) + " */");
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.toHexString(aidObject, ", ") + "," + Msg.eol);
        int aidObjectRef = CrefOutputFormatter.objectManager.addObject(currentROMAddr);
        CrefOutputFormatter.cof.currentRomAddr = currentROMAddr += 7;
        return aidObjectRef;
    }

    void setClassAddrresses() {
        JCClass byteArrayClass = (JCClass)this.rommask.classSymbolTable.get("[B");
        byteClassOffset = byteArrayClass.getRelocAddr();
        VMArrayImplementationPkg = CrefOutputFormatter.cof.packageDirectory.indexOf(byteArrayClass.getParentPackage().getIdentifier());
        JCClass refArrayClass = (JCClass)this.rommask.classSymbolTable.get("[L;");
        refClassOffset = refArrayClass.getRelocAddr();
        JCClass aidClass = (JCClass)this.rommask.classSymbolTable.get("javacard/framework/AID");
        if (aidClass != null) {
            AIDClassOffset = aidClass.getRelocAddr();
            AIDClassPkgId = CrefOutputFormatter.cof.packageDirectory.indexOf(aidClass.getParentPackage().getIdentifier());
        } else {
            Msg.warn("cref.7", null);
            AIDClassOffset = 0;
        }
        JCClass appletEntryClass = (JCClass)this.rommask.classSymbolTable.get("com/sun/javacard/impl/AppletInfo");
        appletEntryClassOffset = appletEntryClass.getRelocAddr();
        appletEntryPkgId = CrefOutputFormatter.cof.packageDirectory.indexOf(appletEntryClass.getParentPackage().getIdentifier());
        JCClass pkgEntryClass = (JCClass)this.rommask.classSymbolTable.get("com/sun/javacard/impl/PackageEntry");
        packageEntryClassRef = pkgEntryClass.getRelocAddr();
        pkgEntryPkgId = CrefOutputFormatter.cof.packageDirectory.indexOf(pkgEntryClass.getParentPackage().getIdentifier());
    }

    private void createPackageTable() {
        int packageTableSize = 76;
        targetPackageMgrTable = new byte[packageTableSize];
        PackageTableManager.createRefArrayObjectHeader(targetPackageMgrTable, 33, (byte)0, packageEntryClassRef, pkgEntryPkgId);
        this.createPackageTableEntries();
        int currentEEPROMAddr = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        packageTableManagerBuffer.append("/* Main Package Table @" + Msg.toAddressString(currentEEPROMAddr) + "*/" + Msg.eol);
        for (int i = 0; i < targetPackageMgrTable.length; ++i) {
            packageTableManagerBuffer.append(Msg.toHexString(targetPackageMgrTable[i]) + ", ");
            if (i % 12 != 11) continue;
            packageTableManagerBuffer.append(Msg.eol);
        }
        packageTableManagerBuffer.append(Msg.eol);
        packageTableReference = CrefOutputFormatter.objectManager.addObject(currentEEPROMAddr);
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(currentEEPROMAddr + packageTableSize);
        CrefOutputFormatter.initializedArrays.append(packageTableManagerBuffer.toString());
    }

    private void createPackageTableEntries() {
        boolean ref = false;
        int newIndex = 10;
        CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append(Msg.eol + "/*Package Table start*/" + Msg.eol);
        for (int i = 0; i < 33; ++i) {
            if (packages[i] == null) continue;
            int packageEntryRef = packages[i].addToMask();
            PackageTableManager.targetPackageMgrTable[newIndex] = (byte)(packageEntryRef >> 8);
            PackageTableManager.targetPackageMgrTable[newIndex + 1] = (byte)packageEntryRef;
            newIndex += 2;
        }
    }

    void createAndAddPackageContextTable() {
        int currentEEPROMAddr = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        byte[] pkgContextTable = PackageTableManager.createByteArrayObject((short)16, appletPkgContextTable, (byte)0, false);
        packageTableManagerBuffer.append(Msg.eol + "/* Package Context Table @" + Msg.toAddressString(currentEEPROMAddr) + " */" + Msg.eol);
        for (int i = 0; i < pkgContextTable.length; ++i) {
            packageTableManagerBuffer.append(Msg.toHexString(pkgContextTable[i]) + ", ");
            if (i % 12 != 11) continue;
            packageTableManagerBuffer.append(Msg.eol);
        }
        packageTableManagerBuffer.append(Msg.eol);
        packageContextTableReference = CrefOutputFormatter.objectManager.addObject(currentEEPROMAddr);
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(currentEEPROMAddr + pkgContextTable.length);
    }

    void createAndAddPackageTableInfo(RomMask r) {
        this.rommask = r;
        this.setClassAddrresses();
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i] == null) continue;
            PackageTableEntry pe = packages[i];
            CrefOutputFormatter.cof.rom_AidAndPkgTblEntries.append("/* AID for " + pe.packageInfo.getName() + " */" + Msg.eol);
            pe.pkgAID = PackageTableManager.createAIDObject(pe.packageInfo.getIdentifier().getAid().toByteArray(), false);
            Enumeration f = pe.packageInfo.appletElements();
            while (f.hasMoreElements()) {
                pe.setAppletInformation((AppletDeclarator)f.nextElement());
            }
        }
        this.createAndAddPackageContextTable();
        this.createPackageTable();
    }

    int createAndAddPackageLocTable(StringBuffer buffer) {
        int currentAddress = CrefOutputFormatter.cof.getCurrentEEPROMAddr();
        int curROMAddress = CrefOutputFormatter.cof.currentRomAddr;
        int startLoc = currentAddress;
        CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable.append("/* Package Location Table @" + Msg.toAddressString(curROMAddress) + "*/" + Msg.eol);
        for (int i = 0; i < packages.length; ++i) {
            if (packages[i] == null) continue;
            PackageTableEntry pe = packages[i];
            curROMAddress += pe.addPackageLocInfoToMask(CrefOutputFormatter.cof.rom_GrtObjectPkgFilledTable, curROMAddress);
        }
        CrefOutputFormatter.cof.currentRomAddr = curROMAddress;
        buffer.append("/* Package Location Table: Main Table @" + Msg.toAddressString(currentAddress) + "*/" + Msg.eol);
        this.packageLocTableAddress = currentAddress;
        String filler = "0x00, 0x00, ";
        if (Main.FLAG_32_BIT) {
            filler = "0x00, 0x00, 0x00, 0x00, ";
        }
        for (int i = 0; i < 33; ++i) {
            if (packages[i] != null) {
                PackageTableEntry pe = packages[i];
                if (Main.FLAG_32_BIT) {
                    buffer.append(Msg.to32BitHexString(PackageTableManager.packages[i].comInfoTableAddress));
                } else {
                    buffer.append(Msg.to16BitHexString(PackageTableManager.packages[i].comInfoTableAddress));
                }
            } else {
                buffer.append(filler);
            }
            if (i % 8 != 7) continue;
            buffer.append(Msg.eol);
        }
        currentAddress = Main.FLAG_32_BIT ? (currentAddress += 132) : (currentAddress += 66);
        CrefOutputFormatter.cof.setCurrentEEPROMAddr(currentAddress);
        return currentAddress - startLoc;
    }

    protected static void createSimpleObjectHeader(byte[] objectData, int classOffset, byte context, boolean isEntryPointObject, int pkgId) {
        objectData[0] = isEntryPointObject ? 44 : 32;
        objectData[1] = context;
        objectData[2] = (byte)(classOffset >> 8);
        objectData[3] = (byte)classOffset;
        objectData[4] = (byte)pkgId;
    }

    protected static byte[] createByteArrayObject(short count, byte[] data, byte context, boolean isJCREEntryPointObject) {
        int byteArrayHeaderSize = 7;
        int totalSize = byteArrayHeaderSize + count;
        byte[] targetObject = new byte[totalSize];
        targetObject[0] = -128;
        targetObject[1] = context;
        targetObject[2] = (byte)(byteClassOffset >> 8);
        targetObject[3] = (byte)byteClassOffset;
        targetObject[4] = (byte)VMArrayImplementationPkg;
        targetObject[5] = (byte)(count >> 8);
        targetObject[6] = (byte)count;
        for (int i = 0; i < count; ++i) {
            targetObject[byteArrayHeaderSize + i] = data[i];
        }
        return targetObject;
    }

    protected static void createRefArrayObjectHeader(byte[] objectData, int count, byte context, int classOffset, int pkgId) {
        objectData[0] = -32;
        objectData[1] = context;
        objectData[2] = (byte)(refClassOffset >> 8);
        objectData[3] = (byte)refClassOffset;
        objectData[4] = (byte)VMArrayImplementationPkg;
        objectData[5] = (byte)(count >> 8);
        objectData[6] = (byte)count;
        objectData[7] = (byte)(classOffset >> 8);
        objectData[8] = (byte)classOffset;
        objectData[9] = (byte)pkgId;
    }
}

