/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.Assert;
import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.Field;
import com.sun.javacard.jcasm.FieldDescriptor;
import com.sun.javacard.jcasm.FieldIdentifier;
import com.sun.javacard.jcasm.InterfaceTable;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.MethodIdentifier;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.PackageIdentifier;
import com.sun.javacard.jcasm.cap.Component;
import com.sun.javacard.jcasm.cap.TypeDescriptorInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class DescriptorComponent
extends Component {
    protected Vector classVector = new Vector();
    protected TypeDescriptorInfo typeDescInfo;

    public DescriptorComponent(JCPackage p) {
        super(p);
        this.typeDescInfo = new TypeDescriptorInfo(p);
    }

    public void add(JCClass c) {
        if (this.classVector.size() < 255) {
            ClassDescriptorInfo cd = new ClassDescriptorInfo(c, this.typeDescInfo);
            this.classVector.addElement(cd);
        } else {
            Msg.error("cap.5", null);
            System.exit(1);
        }
    }

    public int dataSize() {
        int size = 1;
        Enumeration e = this.classVector.elements();
        while (e.hasMoreElements()) {
            ClassDescriptorInfo cd = (ClassDescriptorInfo)e.nextElement();
            size += cd.size();
        }
        return size += this.typeDescInfo.size();
    }

    protected byte[] toByteArray() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            byte[] header = super.toByteArray();
            dos.write(header, 0, header.length);
            dos.writeByte(this.classVector.size());
            Enumeration e = this.classVector.elements();
            while (e.hasMoreElements()) {
                ClassDescriptorInfo cd = (ClassDescriptorInfo)e.nextElement();
                byte[] array = cd.toByteArray();
                dos.write(array, 0, array.length);
            }
            byte[] types = this.typeDescInfo.toByteArray();
            dos.write(types, 0, types.length);
            dos.flush();
        }
        catch (IOException e) {
            return null;
        }
        Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
        return bos.toByteArray();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Count: " + this.classVector.size() + Msg.eol);
        Enumeration e = this.classVector.elements();
        while (e.hasMoreElements()) {
            ClassDescriptorInfo cd = (ClassDescriptorInfo)e.nextElement();
            sb.append("Class_descriptor_info: " + Msg.eol);
            sb.append(cd);
            sb.append(Msg.eol);
        }
        sb.append("type_descriptor_info:" + Msg.eol);
        sb.append(this.typeDescInfo);
        return sb.toString();
    }

    static class MethodDescriptorInfo {
        private JCMethod method;
        private TypeDescriptorInfo typeInfo;
        private int token;
        private int access_flags;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_PRIVATE = 2;
        private static final int ACC_PROTECTED = 4;
        private static final int ACC_STATIC = 8;
        private static final int ACC_FINAL = 16;
        private static final int ACC_ABSTRACT = 64;
        private static final int ACC_INIT = 128;

        MethodDescriptorInfo(JCMethod method, TypeDescriptorInfo typeInfo) {
            this.method = method;
            this.typeInfo = typeInfo;
            MethodIdentifier mid = method.getMethodIdentifier();
            this.token = mid == null ? 255 : mid.getMethodToken();
            int flags = method.getAttributes();
            this.access_flags |= Modifier.isPublic(flags) ? 1 : 0;
            this.access_flags |= Modifier.isPrivate(flags) ? 2 : 0;
            this.access_flags |= Modifier.isProtected(flags) ? 4 : 0;
            this.access_flags |= Modifier.isStatic(flags) ? 8 : 0;
            this.access_flags |= Modifier.isFinal(flags) ? 16 : 0;
            this.access_flags |= Modifier.isAbstract(flags) ? 64 : 0;
            if (method.getName().indexOf("<init>(") != -1) {
                this.access_flags |= 0x80;
            }
        }

        int size() {
            return 12;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeByte(this.token);
                dos.writeByte(this.access_flags);
                JCClass parent = this.method.getParentClass();
                if (Modifier.isInterface(parent.getAttributes()) && Modifier.isAbstract(this.method.getAttributes())) {
                    dos.writeShort(0);
                } else {
                    dos.writeShort(this.method.getRelocAddr());
                }
                dos.writeShort(this.typeInfo.getOffset(this.method));
                dos.writeShort(this.method.size() - this.method.getMethodHeader().length);
                ExceptionTable eTbl = this.method.getExceptionTable();
                if (eTbl != null) {
                    dos.writeShort(eTbl.count());
                    dos.writeShort((eTbl.getRelocAddr() - 1) / 8);
                } else {
                    dos.writeShort(0);
                    dos.writeShort(0);
                }
                dos.flush();
            }
            catch (IOException e) {
                return null;
            }
            Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
            return bos.toByteArray();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Token: " + this.token + ", access_flags: " + Msg.toHexString((byte)this.access_flags) + Msg.eol);
            JCClass parent = this.method.getParentClass();
            if (Modifier.isInterface(parent.getAttributes()) && Modifier.isAbstract(this.method.getAttributes())) {
                sb.append("method_offset: 0x0000");
            } else {
                sb.append("method_offset: " + Msg.toHexString((short)this.method.getRelocAddr()));
            }
            sb.append(", type_offset: " + Msg.toHexString((short)this.typeInfo.getOffset(this.method)));
            sb.append(", bytecode_count: " + (this.method.size() - this.method.getMethodHeader().length));
            sb.append(Msg.eol);
            ExceptionTable eTbl = this.method.getExceptionTable();
            if (eTbl != null) {
                sb.append("exception table count: " + eTbl.count());
                sb.append(", exception table index: " + (eTbl.getRelocAddr() - 4) / 8);
            } else {
                sb.append("exception table size: 0");
                sb.append(", exception table index: 0");
            }
            return sb.toString();
        }
    }

    static class FieldDescriptorInfo {
        private Field field;
        private JCClass c;
        private TypeDescriptorInfo typeInfo;
        private int token;
        private int type;
        private int tag1;
        private int tag2;
        private int tag3;
        private int access_flags;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_PRIVATE = 2;
        private static final int ACC_PROTECTED = 4;
        private static final int ACC_STATIC = 8;
        private static final int ACC_FINAL = 16;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        FieldDescriptorInfo(JCClass cl, Field field, TypeDescriptorInfo typeInfo) {
            this.c = cl;
            this.field = field;
            this.typeInfo = typeInfo;
            FieldIdentifier fid = field.getFieldIdentifier();
            this.token = fid == null ? 255 : fid.getFieldToken();
            int flags = field.getAttributes();
            this.access_flags |= Modifier.isPublic(flags) ? 1 : 0;
            this.access_flags |= Modifier.isPrivate(flags) ? 2 : 0;
            this.access_flags |= Modifier.isProtected(flags) ? 4 : 0;
            this.access_flags |= Modifier.isStatic(flags) ? 8 : 0;
            this.access_flags |= Modifier.isFinal(flags) ? 16 : 0;
            if ((this.access_flags & 8) != 0) {
                this.tag2 = (field.getRelocAddr() & 0xFF00) >> 8;
                this.tag3 = field.getRelocAddr() & 0xFF;
            } else {
                this.tag1 = (this.c.getRelocAddr() & 0xFF00) >> 8;
                this.tag2 = this.c.getRelocAddr() & 0xFF;
                this.tag3 = fid.getFieldToken();
            }
            FieldDescriptor fdesc = field.getDescriptor();
            if (fdesc.isPrimitive()) {
                String desc = fdesc.getDescriptorString();
                if (desc.equals("Z")) {
                    this.type = 32770;
                    return;
                } else if (desc.equals("B")) {
                    this.type = 32771;
                    return;
                } else if (desc.equals("S")) {
                    this.type = 32772;
                    return;
                } else {
                    if (!desc.equals("I")) throw new InternalError();
                    this.type = 32773;
                }
                return;
            } else {
                this.type = typeInfo.getOffset(field);
            }
        }

        int size() {
            return 7;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                dos.writeByte(this.token);
                dos.writeByte(this.access_flags);
                dos.writeByte(this.tag1);
                dos.writeByte(this.tag2);
                dos.writeByte(this.tag3);
                dos.writeShort(this.type);
                dos.flush();
            }
            catch (IOException e) {
                return null;
            }
            Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
            return bos.toByteArray();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("token: " + this.token + ", access_flags: " + Msg.toHexString((byte)this.access_flags));
            sb.append(" // " + this.field.getName() + Msg.eol);
            sb.append("field_ref: 0x" + Msg.toHexString((byte)this.tag1));
            sb.append(":0x" + Msg.toHexString((byte)this.tag2));
            sb.append(":0x" + Msg.toHexString((byte)this.tag3));
            sb.append(", type: 0x" + Msg.toHexString((short)this.type));
            return sb.toString();
        }
    }

    static class ClassDescriptorInfo {
        private JCClass c;
        private Vector interfaceVector;
        private Vector fieldVector;
        private Vector methodVector;
        private TypeDescriptorInfo typeInfo;
        private int token;
        private int access_flags;
        private static final int ACC_PUBLIC = 1;
        private static final int ACC_FINAL = 16;
        private static final int ACC_INTERFACE = 64;
        private static final int ACC_ABSTRACT = 128;

        ClassDescriptorInfo(JCClass c, TypeDescriptorInfo typeInfo) {
            Object desc;
            int flags;
            this.c = c;
            this.typeInfo = typeInfo;
            this.token = c.getClassIdentifier().getClassToken();
            if (this.token >= Short.MAX_VALUE) {
                this.token = 255;
            }
            this.access_flags |= Modifier.isPublic(flags = c.getAttributes()) ? 1 : 0;
            this.access_flags |= Modifier.isFinal(flags) ? 16 : 0;
            this.access_flags |= Modifier.isInterface(flags) ? 64 : 0;
            this.access_flags |= Modifier.isAbstract(flags) ? 128 : 0;
            this.interfaceVector = new Vector();
            this.fieldVector = new Vector();
            this.methodVector = new Vector();
            Enumeration e = c.interfaceElements();
            while (e.hasMoreElements()) {
                InterfaceTable table = (InterfaceTable)e.nextElement();
                this.interfaceVector.addElement(table);
            }
            e = c.fieldElements();
            while (e.hasMoreElements()) {
                Field field = (Field)e.nextElement();
                if (Modifier.isFinal(field.getAttributes()) && Modifier.isStatic(field.getAttributes()) && field.getDescriptor().isPrimitive()) continue;
                desc = new FieldDescriptorInfo(c, field, typeInfo);
                this.fieldVector.addElement(desc);
            }
            e = c.methodElements();
            while (e.hasMoreElements()) {
                JCMethod method = (JCMethod)e.nextElement();
                desc = new MethodDescriptorInfo(method, typeInfo);
                this.methodVector.addElement(desc);
            }
        }

        int size() {
            Object info;
            int size = 9;
            size += this.interfaceVector.size() * 2;
            Enumeration e = this.fieldVector.elements();
            while (e.hasMoreElements()) {
                info = (FieldDescriptorInfo)e.nextElement();
                size += ((FieldDescriptorInfo)info).size();
            }
            e = this.methodVector.elements();
            while (e.hasMoreElements()) {
                info = (MethodDescriptorInfo)e.nextElement();
                size += ((MethodDescriptorInfo)info).size();
            }
            return size;
        }

        byte[] toByteArray() {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(this.size());
            DataOutputStream dos = new DataOutputStream(bos);
            try {
                Object info;
                dos.writeByte(this.token);
                dos.writeByte(this.access_flags);
                dos.writeShort(this.c.getRelocAddr());
                dos.writeByte(this.interfaceVector.size());
                dos.writeShort(this.fieldVector.size());
                dos.writeShort(this.methodVector.size());
                Enumeration e = this.interfaceVector.elements();
                while (e.hasMoreElements()) {
                    InterfaceTable table = (InterfaceTable)e.nextElement();
                    if (table.isResolved()) {
                        int addr = table.resolve().getRelocAddr();
                        dos.writeShort(addr);
                        continue;
                    }
                    JCPackage p = table.getParentClass().getParentPackage();
                    PackageIdentifier pid = table.getClassIdentifier().getPackageIdentifier();
                    dos.writeByte(p.getPackageToken(pid) | 0x80);
                    dos.writeByte(table.getClassIdentifier().getClassToken());
                }
                e = this.fieldVector.elements();
                while (e.hasMoreElements()) {
                    info = (FieldDescriptorInfo)e.nextElement();
                    byte[] array = ((FieldDescriptorInfo)info).toByteArray();
                    dos.write(array, 0, array.length);
                }
                e = this.methodVector.elements();
                while (e.hasMoreElements()) {
                    info = (MethodDescriptorInfo)e.nextElement();
                    byte[] array = ((MethodDescriptorInfo)info).toByteArray();
                    dos.write(array, 0, array.length);
                }
                dos.flush();
            }
            catch (IOException e) {
                return null;
            }
            Assert.PostCondition(this.size() == bos.size(), "size() != bos.size()");
            return bos.toByteArray();
        }

        public String toString() {
            Object info;
            StringBuffer sb = new StringBuffer();
            sb.append("token: " + this.token + ", access_flags: " + Msg.toHexString((byte)this.access_flags) + Msg.eol);
            sb.append("interface_count: " + this.interfaceVector.size());
            sb.append(", field_count: " + this.fieldVector.size());
            sb.append(", method_count: " + this.methodVector.size() + Msg.eol);
            sb.append("interfaces:" + Msg.eol);
            Enumeration e = this.interfaceVector.elements();
            while (e.hasMoreElements()) {
                InterfaceTable table = (InterfaceTable)e.nextElement();
                if (table.isResolved()) {
                    int addr = table.resolve().getRelocAddr();
                    sb.append(Msg.toHexString((short)addr));
                    continue;
                }
                JCPackage p = table.getParentClass().getParentPackage();
                PackageIdentifier pid = table.getClassIdentifier().getPackageIdentifier();
                sb.append(Msg.toHexString((byte)(p.getPackageToken(pid) | 0x80)));
                sb.append(".");
                sb.append(Msg.toHexString((byte)table.getClassIdentifier().getClassToken()));
            }
            sb.append("field_descriptor_info:" + Msg.eol);
            e = this.fieldVector.elements();
            while (e.hasMoreElements()) {
                info = (FieldDescriptorInfo)e.nextElement();
                sb.append(info + Msg.eol);
            }
            sb.append("method_descriptor_info:" + Msg.eol);
            e = this.methodVector.elements();
            while (e.hasMoreElements()) {
                info = (MethodDescriptorInfo)e.nextElement();
                sb.append(info + Msg.eol);
            }
            return sb.toString();
        }
    }
}

