/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.jc_tck_internal;

import com.sun.javatest.TestDescription;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class DistrTestDescription
extends TestDescription {
    public static final String CLIENT_SOURCES = "client_source";
    public static final String KEYWORDS = "keywords";
    public static final String EXECUTE_ARGS = "executeArgs";
    public static final String SELECT_IF = "selectIf";
    public static final String INT_SUPPORT_ARG = " -s -PC-i";
    private String[] clientSources = new String[0];

    public DistrTestDescription(File root, File file, Map params) {
        super(root, file, DistrTestDescription.removeSpecific(params));
        String sources = (String)params.get(CLIENT_SOURCES);
        if (sources == null) {
            this.clientSources = new String[0];
        } else {
            StringTokenizer tokens = new StringTokenizer(sources, " ");
            this.clientSources = new String[tokens.countTokens()];
            for (int i = 0; i < this.clientSources.length; ++i) {
                this.clientSources[i] = tokens.nextToken();
            }
        }
    }

    public String[] getClientSources() {
        return (String[])this.clientSources.clone();
    }

    public File[] getClientSourcesFiles() {
        String dir = this.getFile().getParent();
        String[] srcs = this.getClientSources();
        File[] sourceFiles = new File[srcs.length];
        for (int i = 0; i < srcs.length; ++i) {
            sourceFiles[i] = new File(dir, srcs[i].replace('/', File.separatorChar));
        }
        return sourceFiles;
    }

    public static Map removeSpecific(Map source) {
        HashMap retVal = new HashMap();
        for (Object key : source.keySet()) {
            retVal.put(key, source.get(key));
        }
        String keys = (String)retVal.get(KEYWORDS);
        if (keys.indexOf("runtime") < 0 && keys.indexOf("execute") < 0) {
            retVal.put(KEYWORDS, retVal.get(KEYWORDS) + " runtime");
        }
        String selectIf = (String)retVal.get(SELECT_IF);
        if (DistrTestDescription.isRequireIntSupport((String)retVal.get(SELECT_IF))) {
            retVal.put(EXECUTE_ARGS, retVal.get(EXECUTE_ARGS) + INT_SUPPORT_ARG);
        }
        retVal.remove(CLIENT_SOURCES);
        return retVal;
    }

    public static boolean isRequireIntSupport(String selectIf) {
        return selectIf != null && selectIf.indexOf("int_support") >= 0;
    }
}

