/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tgxml.tools.filter.plugins;

import com.sun.tgxml.tjtf.api.attributes.Attributes;
import com.sun.tgxml.tjtf.api.attributes.TargetSpec;
import com.sun.tgxml.tjtf.api.tests.TestCase;
import com.sun.tgxml.tjtf.api.tests.TestGroup;
import com.sun.tgxml.tjtf.api.tests.TestItem;
import com.sun.tgxml.tjtf.tools.BuildProperties;
import com.sun.tgxml.tools.filter.processors.NodeTRUE;
import java.util.ArrayList;

class TargSpecJDK
extends NodeTRUE {
    TargSpecJDK() {
    }

    static ArrayList findSpec(ArrayList specs) {
        ArrayList<TargetSpec> toReturn = new ArrayList<TargetSpec>();
        for (int j = specs.size() - 1; j >= 0; --j) {
            TargetSpec s = (TargetSpec)specs.get(j);
            String id = s.getID();
            if (id == null || !"JDK".equals(id.toUpperCase())) continue;
            toReturn.add(s);
        }
        return toReturn;
    }

    static int compareVersion(TargetSpec ts1, TargetSpec ts2) {
        if (ts1.getMajor() < ts2.getMajor()) {
            return -1;
        }
        if (ts1.getMajor() > ts2.getMajor()) {
            return 1;
        }
        if (ts1.getMinor() < ts2.getMinor()) {
            return -1;
        }
        if (ts1.getMajor() > ts2.getMajor()) {
            return 1;
        }
        if (ts1.getMinor() < ts2.getMinor()) {
            return -1;
        }
        if (ts1.getMinor() > ts2.getMinor()) {
            return 1;
        }
        return 0;
    }

    static boolean acceptItem(TestItem ti) {
        TargetSpec spec;
        Attributes attrs = ti.getAttributes();
        if (attrs == null) {
            return true;
        }
        ArrayList s = TargSpecJDK.findSpec(attrs.getTargetSpecs());
        if (s.isEmpty()) {
            return true;
        }
        String currentVersion = BuildProperties.getString((String)"spec.jdk.version");
        if (currentVersion == null) {
            return true;
        }
        int point = currentVersion.indexOf(46);
        int currentMajor = 0;
        int currentMinor = 0;
        try {
            currentMajor = Integer.parseInt(currentVersion.substring(0, point));
            currentMinor = Integer.parseInt(currentVersion.substring(point + 1));
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace(System.err);
            throw new RuntimeException("Incorrect version number in the property file: " + currentVersion);
        }
        catch (IndexOutOfBoundsException ibe) {
            ibe.printStackTrace();
            throw new RuntimeException("Incorrect version number in the property file: " + currentVersion);
        }
        if (s.size() == 1) {
            return ((TargetSpec)s.get(0)).inSpec(currentMajor, currentMinor);
        }
        block3: for (int i = 0; i < s.size(); ++i) {
            TargetSpec spec2 = (TargetSpec)s.get(i);
            if (spec2.getMajor() == currentMajor && spec2.getMinor() == currentMinor) {
                return true;
            }
            if (!spec2.isUpperModifierSet() && !spec2.isLowerModifierSet()) {
                s.remove(i--);
                continue;
            }
            for (int j = 0; j < i; ++j) {
                TargetSpec ts = (TargetSpec)s.get(j);
                int compare = TargSpecJDK.compareVersion(ts, spec2);
                if (compare == -1) continue;
                if (compare == 1) {
                    s.remove(i);
                    s.add(j, spec2);
                    continue block3;
                }
                if (spec2.isUpperModifierSet() && ts.isUpperModifierSet() || spec2.isLowerModifierSet() && ts.isLowerModifierSet()) {
                    s.remove(i--);
                    continue block3;
                }
                s.remove(i--);
                s.remove(j);
                --i;
                if (!s.isEmpty()) continue block3;
                return false;
            }
        }
        if (s.isEmpty()) {
            return true;
        }
        int indexRight = 0;
        for (int i = 0; i < s.size() && (spec = (TargetSpec)s.get(i)).getMajor() <= currentMajor && (spec.getMajor() != currentMajor || spec.getMinor() <= currentMinor); ++i) {
            ++indexRight;
        }
        if (indexRight == 0) {
            return ((TargetSpec)s.get(indexRight)).inSpec(currentMajor, currentMinor);
        }
        if (indexRight == s.size()) {
            return ((TargetSpec)s.get(indexRight - 1)).inSpec(currentMajor, currentMinor);
        }
        TargetSpec leftsp = (TargetSpec)s.get(indexRight - 1);
        TargetSpec rightsp = (TargetSpec)s.get(indexRight);
        return !leftsp.isLowerModifierSet() || !rightsp.isUpperModifierSet();
    }

    public boolean accept(TestGroup tg) {
        return TargSpecJDK.acceptItem((TestItem)tg);
    }

    public boolean accept(TestCase tc, TestGroup tg) {
        return TargSpecJDK.acceptItem((TestItem)tc);
    }
}

