/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.me.utils;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.tck.me.utils.Converter;
import com.sun.tck.me.utils.SingleArgumentConverter;
import com.sun.tck.me.utils.Utils;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Converters {
    static Map<String, Converter> defaultConverters;
    public static final Converter TO_ARRAY;

    Converters() {
    }

    public static Object convert(Class to, String arg) throws Exception {
        Converter cv;
        if (defaultConverters == null) {
            defaultConverters = Converters.createConverters();
        }
        return (cv = defaultConverters.get(to.getName())) == null ? null : cv.convert(Collections.singletonList(arg));
    }

    static Map<String, Converter> createConverters() {
        HashMap<String, Converter> retVal = new HashMap<String, Converter>();
        retVal.put(Integer.TYPE.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return new Integer(value);
            }
        });
        retVal.put(Boolean.TYPE.getName(), new SingleArgumentConverter(){

            public Object convertElement(String ob) throws Exception {
                String value = ob.trim();
                return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
            }
        });
        retVal.put(Float.TYPE.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return new Float(value);
            }
        });
        retVal.put(File.class.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return new File(value);
            }
        });
        retVal.put(String.class.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return value;
            }
        });
        retVal.put(CommandAPDU.class.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return new CommandAPDU(Utils.parse(value));
            }
        });
        retVal.put(AppletID.class.getName(), new SingleArgumentConverter(){

            public Object convertElement(String value) throws Exception {
                return new AppletID(Utils.parse(value));
            }
        });
        retVal.put(String[].class.getName(), TO_ARRAY);
        return retVal;
    }

    static {
        TO_ARRAY = new Converter(){

            @Override
            public Object convert(List<String> value) throws Exception {
                if (value == null) {
                    return null;
                }
                return value.toArray(new String[value.size()]);
            }
        };
    }
}

