/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest;

import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.javacard.globalimpl.ServiceValidator;
import com.sun.javatest.DefaultTestRunner;
import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.tck.jc.javatest.RerunnableTestDescription;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueTestRunner
extends DefaultTestRunner {
    final TestsCompletionMonitor testCompletionMonitor = new TestsCompletionMonitor();
    private Queue<TestDescription> testQueue;
    private int startedCount = 0;
    private boolean started = false;
    private static QueueTestRunner currentTestRunner;
    private static I18NResourceBundle i18n;

    public static QueueTestRunner createTestRunner() {
        currentTestRunner = new QueueTestRunner();
        return currentTestRunner;
    }

    private QueueTestRunner() {
    }

    public static QueueTestRunner getTestRunner() {
        return currentTestRunner;
    }

    public synchronized boolean runTests(Iterator itrtr) throws InterruptedException {
        try {
            CardServicesPool.checkState();
        }
        catch (Exception ex) {
            this.setErrorStatus(itrtr, ex);
            return false;
        }
        ServiceValidator.setWorkingDir(this.getWorkDirectory().getPath());
        ServiceValidator.setTSRoot(this.getTestSuite().getRootDir().getPath());
        this.testQueue = this.putTestsToQueue(itrtr);
        return super.runTests((Iterator)new Iterator<TestDescription>(){

            @Override
            public TestDescription next() {
                return (TestDescription)QueueTestRunner.this.testQueue.poll();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                if (!QueueTestRunner.this.testQueue.isEmpty()) {
                    return true;
                }
                if (QueueTestRunner.this.testCompletionMonitor.canContinue()) {
                    return false;
                }
                TestsCompletionMonitor testsCompletionMonitor = QueueTestRunner.this.testCompletionMonitor;
                synchronized (testsCompletionMonitor) {
                    while (!QueueTestRunner.this.testCompletionMonitor.canContinue()) {
                        try {
                            QueueTestRunner.this.testCompletionMonitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    return !QueueTestRunner.this.testQueue.isEmpty();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        });
    }

    protected void setErrorStatus(Iterator itrtr, Throwable ex) {
        Status s = Status.error((String)ex.getLocalizedMessage());
        WorkDirectory workDir = this.getWorkDirectory();
        while (itrtr.hasNext()) {
            TestDescription td = (TestDescription)itrtr.next();
            TestResult tr = new TestResult(td);
            TestResult.Section trs = tr.createSection(i18n.getString("dtr.details"));
            PrintWriter pw = trs.createOutput(i18n.getString("dtr.stackTrace"));
            ex.printStackTrace(pw);
            pw.close();
            tr.setStatus(s);
            try {
                tr.writeResults(workDir, this.getBackupPolicy());
                this.notifyFinishedTest(tr);
            }
            catch (Exception e) {
                workDir.log(i18n, "dtr.unexpectedThrowable", new Object[]{td.getRootRelativeURL(), e});
            }
        }
    }

    public int getConcurrency() {
        return CardServicesPool.getCapacity();
    }

    protected Queue<TestDescription> putTestsToQueue(Iterator itrtr) {
        ConcurrentLinkedQueue<TestDescription> queue = new ConcurrentLinkedQueue<TestDescription>();
        while (itrtr.hasNext()) {
            TestDescription td = (TestDescription)itrtr.next();
            RerunnableTestDescription rtd = new RerunnableTestDescription(td);
            queue.add(rtd);
        }
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnToQueue(TestDescription td) {
        ((RerunnableTestDescription)td).setRerun();
        TestsCompletionMonitor testsCompletionMonitor = this.testCompletionMonitor;
        synchronized (testsCompletionMonitor) {
            this.testQueue.add(td);
            this.testCompletionMonitor.notify();
        }
    }

    public void testStarted() {
        this.started = true;
        ++this.startedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompleted() {
        --this.startedCount;
        TestsCompletionMonitor testsCompletionMonitor = this.testCompletionMonitor;
        synchronized (testsCompletionMonitor) {
            this.testCompletionMonitor.notify();
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(DefaultTestRunner.class);
    }

    class TestsCompletionMonitor {
        TestsCompletionMonitor() {
        }

        boolean canContinue() {
            return !QueueTestRunner.this.testQueue.isEmpty() || QueueTestRunner.this.started && QueueTestRunner.this.startedCount == 0;
        }
    }
}

