/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.javatest;

import com.sun.javatest.Harness;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestRunner;
import com.sun.javatest.TestSuite;
import com.sun.javatest.finder.BinaryTestFinder;
import com.sun.javatest.finder.HTMLTestFinder;
import com.sun.tck.bvtool.terminal.CardStore;
import com.sun.tck.jc.javatest.QueueTestRunner;
import java.io.File;
import java.util.Map;

public class JCTCKTestSuite
extends TestSuite {
    public JCTCKTestSuite(File root, Map tsInfo, ClassLoader cl) throws TestSuite.Fault {
        super(root, tsInfo, cl);
    }

    public void starting(Harness harness) throws TestSuite.Fault {
        CardStore store = CardStore.getDefaultStore();
        File tmpDir = harness.getResultTable().getWorkDirectory().getFile("tmp");
        File stateStore = new File(tmpDir, "card-state-storage");
        stateStore.mkdirs();
        store.setStorageDir(stateStore);
        TestEnvironment env = harness.getEnv();
        try {
            String[] list = env.lookup("CardStoreFile");
            StringBuilder val = new StringBuilder();
            String delim = "";
            for (String str : list) {
                val.append(delim).append(str);
                System.out.println("Starting:keyFile= '" + str + "'");
                delim = " ";
            }
            store.setKeyList(val.toString());
            store.init();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        super.starting(harness);
    }

    protected TestFinder createTestFinder() throws TestSuite.Fault {
        HTMLTestFinder find = null;
        try {
            File f;
            String jtdEntry = (String)this.getTestSuiteInfo().get("testsuite.jtd");
            File jtdFile = jtdEntry == null || jtdEntry.length() == 0 ? new File(new File(this.getRootDir(), "tests"), "testsuite.jtd") : ((f = new File(jtdEntry)).isAbsolute() ? f : new File(this.getRootDir(), f.getPath()));
            if (jtdFile.exists()) {
                BinaryTestFinder btf = new BinaryTestFinder();
                btf.init(new String[]{"-binary", jtdFile.getPath()}, this.getTestsDir(), null);
                find = btf;
            } else {
                HTMLTestFinder htmltf = new HTMLTestFinder();
                htmltf.init(new String[]{"-dirWalk"}, this.getTestsDir(), null);
                find = htmltf;
            }
        }
        catch (TestFinder.Fault f) {
            f.printStackTrace();
        }
        return find;
    }

    public TestRunner createTestRunner() {
        return QueueTestRunner.createTestRunner();
    }
}

