/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview.lib;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.javacard.cjck.I18n;
import com.sun.tck.jc.interview.lib.InterviewEntry;
import com.sun.tck.jc.interview.lib.InterviewPathResolver;
import com.sun.tck.jc.interview.lib.Validator;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CompositeInterview
extends Interview
implements InterviewPathResolver {
    private ArrayList list = new ArrayList();
    private HashMap questions = new HashMap();
    private final Question endQuestion = new FinalQuestion((Interview)this);
    protected HashMap values = new HashMap();

    public CompositeInterview(Interview parent, String tag) {
        super(parent, tag);
    }

    public CompositeInterview(String tag) {
        super(tag);
    }

    public void addQuestion(Question next) throws IllegalArgumentException {
        this.addQuestion(next, null, null, false);
    }

    public void addQuestion(Question next, String key) throws IllegalArgumentException {
        this.addQuestion(next, key, null, false);
    }

    public void addQuestion(Question next, String key, String defaultValue) throws IllegalArgumentException {
        this.addQuestion(next, key, defaultValue, defaultValue != null);
    }

    private void addQuestion(Question next, String key, String value, boolean hasDefault) throws IllegalArgumentException {
        if (next == null || !(next instanceof InterviewEntry)) {
            throw new IllegalArgumentException(I18n.getString("question.nonnull"));
        }
        ((InterviewEntry)next).setKey(key);
        if (hasDefault) {
            this.putValue(next.getTag(), value);
            ((InterviewEntry)next).setDefaultValue(value);
            next.clear();
        }
        this.questions.put(next.getTag(), new Integer(this.list.size()));
        this.list.add(next);
        ((InterviewEntry)next).setResolver(this);
        if (this.list.size() == 1) {
            this.setFirstQuestion(next);
        }
    }

    public Question getQuestion(String tag) {
        Integer pos = (Integer)this.questions.get(tag);
        if (pos == null && (pos = (Integer)this.questions.get(this.createTag(tag))) == null) {
            throw new InterviewPathResolver.NoEntry("No " + tag);
        }
        return (Question)this.list.get(pos);
    }

    public Question getNext(String tag) {
        Integer pos = (Integer)this.questions.get(tag);
        if (pos == null) {
            throw new InterviewPathResolver.NoEntry("No " + tag);
        }
        for (int i = pos + 1; i < this.list.size(); ++i) {
            Question current = (Question)this.list.get(i);
            if (!this.isApplicable(current)) continue;
            return current;
        }
        return this.endQuestion;
    }

    public void update(String tag) throws Interview.Fault {
        Integer pos = (Integer)this.questions.get(this.createTag(tag));
        if (pos != null) {
            this.update(pos);
        }
    }

    public void updateFrom(String tag) throws Interview.Fault {
        Integer pos = (Integer)this.questions.get(this.createTag(tag));
        Interview.Fault ex = null;
        if (pos != null) {
            for (int i = pos + 1; i < this.list.size(); ++i) {
                try {
                    this.update(i);
                    continue;
                }
                catch (Interview.Fault e) {
                    ex = e;
                }
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public String getValue(String name) {
        Object retVal = this.values.get(name);
        if (retVal == null) {
            retVal = this.values.get(this.createTag(name));
            if (retVal == null) {
                return null;
            }
            if (retVal instanceof File) {
                return ((File)retVal).getPath();
            }
            return retVal.toString();
        }
        return null;
    }

    public void putValue(String name, String value) {
        this.values.put(this.createTag(name), value);
    }

    public String createTag(String shortName) {
        return this.getTag() + "." + shortName;
    }

    public boolean isApplicable(Question question) {
        return true;
    }

    private void update(int pos) throws Interview.Fault {
        Question current = (Question)this.list.get(pos);
        Object val = this.values.get(current.getTag());
        if (val != null && val instanceof String) {
            current.setValue((String)val);
        } else {
            current.clear();
        }
    }

    public static Validator or(final Validator first, final Validator second) {
        return new Validator(){

            public String toString() {
                return "or(" + first + ", " + second + ")";
            }

            public boolean accept(String tag, Object o, Map map) {
                return first.accept(tag, o, map) || second.accept(tag, o, map);
            }

            public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
                return first.getErrorQuestion(tag, o, map) == null ? null : second.getErrorQuestion(tag, o, map);
            }
        };
    }

    public static Validator and(final Validator first, final Validator second) {
        return new Validator(){

            public String toString() {
                return "and(" + first + ", " + second + ")";
            }

            public boolean accept(String tag, Object o, Map map) {
                return first.accept(tag, o, map) && second.accept(tag, o, map);
            }

            public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
                return first.getErrorQuestion(tag, o, map) != null ? first.getErrorQuestion(tag, o, map) : second.getErrorQuestion(tag, o, map);
            }
        };
    }

    public static Validator not(final Validator first) {
        return new Validator(){

            public String toString() {
                return "not(" + first + ")";
            }

            public boolean accept(String tag, Object o, Map map) {
                return !first.accept(tag, o, map);
            }

            public ErrorQuestion getErrorQuestion(String tag, Object o, Map map) {
                return null;
            }
        };
    }
}

