/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.tck.jc.interview.lib.CompositeInterview;
import com.sun.tck.jc.interview.lib.FileQuestion;
import com.sun.tck.jc.interview.lib.StringQuestion;
import com.sun.tck.jc.interview.lib.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class BVTEnvInterview
extends CompositeInterview {
    public static final String CONFIG_FILE_PROPERTY_NAME = "com.oracle.bvt.config";
    public static final String PRODUCT = "product";
    public static final String CONFIG_NAME = "configName";
    public static final String DESCRIPTION = "description";
    public static final String BUNDLE_SIZE = "bundle_size";
    public static final String INT_SUPPORT = "int_support";
    public static final String JAVACARDX_CRYPTO_SUPPORT = "javacardx_crypto_support";
    public static final String CARD_SERVICE_CLASS = "CardServiceClass";
    public static final String CARD_PROXY_OPTIONS = "CardProxyOptions";
    public static final String SERVICE_PATH = "ServicePath";
    public static final String CLA_BYTE = "CLA_BYTE";
    public static final String DELETE_PACKAGE_AND_INSTANCES_SUPPORT = "deletePackageAndInstancesSupport";
    public static final String CARD_STORE_FILE = "CardStoreFile";
    public static final String Install = "install";
    private StringQuestion configNameQuestion;
    private ResourceBundle i18nBundle = this.getResourceBundle();

    public BVTEnvInterview(Interview parent, String tag) {
        super(parent, tag);
        this.configNameQuestion = new StringQuestion(this, CONFIG_NAME, Validator.ConfigName, this.values, new String[]{this.i18n("product.JC_TCK"), this.i18n("product.JavaCard_TCK")});
        this.addQuestion((Question)this.configNameQuestion, CONFIG_NAME);
        this.addQuestion((Question)new StringQuestion(this, DESCRIPTION, Validator.NotEmpty, this.values, new String[]{this.i18n("description.complete_tck"), this.i18n("description.api")}), DESCRIPTION);
        this.addQuestion((Question)new FileQuestion(this, CARD_STORE_FILE, Validator.NotEmpty, this.values), CARD_STORE_FILE);
    }

    public boolean isApplicable(Question current) {
        return true;
    }

    public String getName() {
        return this.configNameQuestion.getStringValue();
    }

    public void setName(String name) {
        this.configNameQuestion.setValue(name);
    }

    public String getProduct() {
        return Install;
    }

    public void setRoot(String root) {
        String name = System.getProperty(CONFIG_FILE_PROPERTY_NAME);
        if (name == null) {
            name = root + File.separator + "lib" + File.separator + "config.properties";
        }
        this.loadProperties(name);
    }

    private void loadProperties(String fileName) {
        this.loadDefaults();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                return;
            }
            Properties tmp = new Properties();
            tmp.load(new FileInputStream(fileName));
            for (Object key : tmp.keySet()) {
                this.values.put((String)key, tmp.getProperty((String)key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String yesToTrue(String value) {
        return "Yes".equals(value) ? "true" : "false";
    }

    public static String addCoverArg(String value, String arg) {
        if (value == null) {
            return "";
        }
        StringBuilder retVal = new StringBuilder();
        StringTokenizer e = new StringTokenizer(value, " \n\t");
        while (e.hasMoreTokens()) {
            retVal.append(arg);
            String current = e.nextToken();
            if (current.startsWith("\"")) {
                retVal.append(current);
                continue;
            }
            retVal.append(" \"");
            retVal.append(current);
            retVal.append("\" ");
        }
        return retVal.toString();
    }

    public void export(Map map) {
        map.putAll(this.values);
        map.put("JCTCK_HOME", "$testSuiteRootDir");
        map.put("JcTckClasses", "$JCTCK_HOME$/classes");
        map.put("libdir", "$JCTCK_HOME$/src$/share$/libs");
        map.put(CARD_PROXY_OPTIONS, BVTEnvInterview.addCoverArg(this.getValue(CARD_PROXY_OPTIONS), "-s"));
        map.put("ScriptArgs", "-install");
        map.put("command.install", "com.sun.javacard.cjck.invoke.CardTest $CardProxyOptions -C $CardServiceClass -mode install -Test \"$test\" -o \"$testWorkDir\" -classdir \"$JcTckClasses\" -exportdir \"$ExportPath$:$JCTCK_HOME$/export_files\" -bundle_size $bundle_size -capfiledir \"$test\" -libdir $libdir -get_response_cla_byte $CLA_BYTE -executeClass $testExecuteClass $testExecuteArgs");
        super.export(map);
    }

    private String i18n(String key) {
        if (this.i18nBundle != null) {
            try {
                return this.i18nBundle.getString(key);
            }
            catch (MissingResourceException e) {
                return key;
            }
        }
        return key;
    }

    private void loadDefaults() {
        this.values.put(CARD_SERVICE_CLASS, "com.sun.tck.bvtool.etsi.gp.GPOverETSICardService");
        this.values.put(SERVICE_PATH, "$JCTCK_HOME$/lib$/jctck-referenceimpl.jar$:l$JCTCK_HOME$/lib$/jctck-utils.jar");
        this.values.put(BUNDLE_SIZE, "0");
        this.values.put(CONFIG_NAME, "JC_TCK");
        this.values.put(DELETE_PACKAGE_AND_INSTANCES_SUPPORT, "true");
        this.values.put(DESCRIPTION, "Complete JC TCK Test Suite");
        this.values.put(INT_SUPPORT, "true");
        this.values.put(JAVACARDX_CRYPTO_SUPPORT, "true");
        this.values.put(PRODUCT, Install);
        this.values.put(CLA_BYTE, "0");
    }
}

