/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.jc.internal;

import com.sun.tck.jc.internal.BandI;
import com.sun.tgxml.tjtf.api.attributes.TestGroupAttributes;
import com.sun.tgxml.tjtf.api.code.CodeSet;
import com.sun.tgxml.tjtf.api.exceptions.TestFileException;
import com.sun.tgxml.tools.testgen.api.TestDescriptionIR;
import java.util.ArrayList;

public class CustomTestDescription
extends TestDescriptionIR {
    public static final String RESOURCE = "resources";

    public CustomTestDescription(String id, String title, TestGroupAttributes tgAttr, CodeSet codeSet, String resources) throws TestFileException {
        this(id, title, tgAttr, BandI.getExternalSourcesNameList(codeSet, null));
        if (resources != null) {
            this.add(RESOURCE, resources);
        }
    }

    public CustomTestDescription(String id, String title, TestGroupAttributes tgAttr, ArrayList sources) throws TestFileException {
        String id_name = CustomTestDescription.getCanonical(id);
        String title_name = CustomTestDescription.getCanonical(title);
        this.add("title", id_name + " - " + title_name);
        this.add("name", id_name);
        this.add("executeClass", CustomTestDescription.getCanonical(tgAttr.getExecuteClass()));
        this.add("keywords", tgAttr.getKeywords());
        this.add("context", CustomTestDescription.getCanonical(tgAttr.getContext()));
        this.add("executeArgs", CustomTestDescription.getCanonical(tgAttr.getExecuteArgs()));
        this.add("executeNative", CustomTestDescription.getCanonical(tgAttr.getExecuteNative()));
        this.add("remote", tgAttr.getRemotes());
        this.add("rmicClasses", CustomTestDescription.getCanonical(tgAttr.getRMICClasses()));
        this.add("selectIf", tgAttr.getSelectIfs());
        this.add("timeout", CustomTestDescription.getCanonical(tgAttr.getTimeout()));
        if (sources != null) {
            this.add("source", sources);
        }
    }

    public static String getCanonical(String data) {
        int start;
        if (data == null || data.equals("")) {
            return data;
        }
        int end = data.length();
        for (start = 0; start < end && !CustomTestDescription.isNotIgnored(data.charAt(start)); ++start) {
        }
        if (start >= data.length()) {
            return "";
        }
        for (end = data.length() - 1; end > 0 && !CustomTestDescription.isNotIgnored(data.charAt(end)); --end) {
        }
        return data.substring(start, end + 1);
    }

    public static boolean isNotIgnored(char c) {
        return c != ' ' && c != '\n' && c != '\r' && c != '\t';
    }
}

