/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardPresenceNotifier;
import com.sun.tck.bvtool.terminal.CardStore;
import java.util.Observer;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;

public class StatefulCardTerminal
extends CardTerminal {
    private State state = State.CREATED;
    private CardTerminal terminal;
    private String label;
    private CardStore cards;
    private Card card;
    private CardPresenceNotifier cardPresenceNotifier;

    public StatefulCardTerminal(CardTerminal terminal) throws CardException {
        this(CardStore.getDefaultStore(), terminal);
    }

    public StatefulCardTerminal(CardStore cards, CardTerminal terminal) throws CardException {
        this.terminal = terminal;
        this.cards = cards;
        this.cardPresenceNotifier = new CardPresenceNotifier(this);
        new Thread(this.cardPresenceNotifier).start();
    }

    public boolean checkConnection() {
        try {
            this.terminal.connect("T=0");
            return true;
        }
        catch (CardException ex) {
            return false;
        }
    }

    public void addCardPresenceObserver(Observer observer) {
        this.cardPresenceNotifier.addObserver(observer);
    }

    public void removeCardPresenceObserver(Observer observer) {
        this.cardPresenceNotifier.deleteObserver(observer);
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setInsertedCardID(String cardID) throws FatalException {
        System.out.println("!! setInsertedCardID(" + cardID + ")");
        this.card = this.cards.findCard(cardID);
    }

    public Card getInsertedCard() {
        return this.card;
    }

    public State getState() {
        return this.state;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        return I18n.getString("stateful.terminal.name", this.terminal.toString(), this.label, (Object)this.state);
    }

    public javax.smartcardio.Card connect(String protocol) throws CardException {
        return this.terminal.connect(protocol);
    }

    public String getName() {
        return this.terminal.getName();
    }

    public boolean isCardPresent() throws CardException {
        return this.terminal.isCardPresent();
    }

    public boolean checkCardPresent() {
        try {
            return this.terminal.isCardPresent();
        }
        catch (CardException ex) {
            return false;
        }
    }

    public boolean waitForCardAbsent(long timeout) throws CardException {
        return this.terminal.waitForCardAbsent(timeout);
    }

    public boolean waitForCardPresent(long timeout) throws CardException {
        return this.terminal.waitForCardPresent(timeout);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        CREATED,
        INVALID,
        VERIFIED,
        RECOVERED,
        REPLACEMENT_REQUIRED;

    }
}

