/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.bvtool.terminal.CardState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardStore {
    public static final int ICCID_OFFSET = 1;
    public static final int DEFAULT_GSM_KEYS_OFFSET = 14;
    private static CardStore instance;
    private File stateStorage;
    private LinkedHashMap<String, Card> cards = new LinkedHashMap();
    private File keyList;

    public static synchronized CardStore getDefaultStore() {
        if (instance == null) {
            instance = new CardStore();
        }
        return instance;
    }

    public void setKeyList(String name) throws Exception {
        this.keyList = new File(name);
    }

    public void init() throws Exception {
        File defList = new File("keys.txt");
        if (this.keyList == null && defList.exists()) {
            this.keyList = defList;
        }
        this.setKeyList(new FileInputStream(this.keyList));
    }

    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyList(InputStream strm) throws Exception {
        BufferedReader in = new BufferedReader(new InputStreamReader(strm));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] key = line.split("[\n\t ]+");
                key[1] = CardStore.removeLastDigit(key[1]).toLowerCase();
                Card card = new Card(CardState.restore(this.stateStorage, key[1]), key[1], key);
                this.cards.put(key[1], card);
            }
        }
        finally {
            in.close();
        }
    }

    private static String removeLastDigit(String st) {
        return st.substring(0, st.length() - 1);
    }

    public Card findCard(String id) throws FatalException {
        Card retVal = null;
        id = id.toLowerCase();
        for (String iccid : this.cards.keySet()) {
            if (!iccid.endsWith(id)) continue;
            if (retVal != null) {
                throw new FatalException(FatalException.Scope.Card, "CONFLICT: " + retVal.state.iccid + " and " + iccid);
            }
            retVal = this.cards.get(iccid);
        }
        if (retVal == null) {
            throw new FatalException(FatalException.Scope.Card, "can not find key for " + id);
        }
        return retVal;
    }

    public Set<String> getCardIDs() {
        return this.cards.keySet();
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("(CardStore");
        for (String iccid : this.cards.keySet()) {
            retVal.append("\n    ").append(iccid).append("=").append(this.cards.get(iccid));
        }
        retVal.append(")");
        return retVal.toString();
    }

    public void setStorageDir(File stateStorage) {
        this.stateStorage = stateStorage;
    }
}

