/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.tck.bvtool.terminal.Card;
import com.sun.tck.me.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class CardState
implements Serializable {
    private static final long serialVersionUID = 2038300570653747929L;
    private transient File storageDir;
    String iccid;
    int keyVersion;
    Card.Pair[] keys = new Card.Pair[16];
    int currentSecurityLevel;
    byte[] phone = Utils.parse("4455667788");
    LinkedHashMap<String, ArrayList<String>> installedCapFiles = new LinkedHashMap();

    public CardState() {
    }

    public CardState(File storageDir) {
        this.storageDir = storageDir;
    }

    void reset() {
        this.keyVersion = 1;
        this.currentSecurityLevel = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() {
        if (this.storageDir == null) {
            return;
        }
        CardState cardState = this;
        synchronized (cardState) {
            String name = this.storageDir + File.separator + this.iccid + ".data";
            File file = new File(name);
            File copy = null;
            if (file.exists()) {
                copy = new File(name + ".back");
                file.renameTo(copy);
            }
            try {
                ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(name));
                out.writeObject(this);
                out.close();
                if (copy != null) {
                    copy.delete();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static CardState create(File dir, String iccid) {
        CardState retVal = new CardState(dir);
        retVal.iccid = iccid;
        return retVal;
    }

    public static CardState restore(File dir, String iccid) {
        if (dir == null || iccid == null) {
            return CardState.create(dir, iccid);
        }
        String name = dir + File.separator + iccid + ".data";
        File file = new File(name);
        File copy = new File(name + ".back");
        file = copy.exists() ? copy : file;
        try {
            if (file.exists()) {
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(file));
                CardState restored = (CardState)in.readObject();
                restored.storageDir = dir;
                in.close();
                return restored;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CardState.create(dir, iccid);
    }

    public String toString() {
        return "(CardState iccid=" + this.iccid + "\n    keyVersion=" + this.keyVersion + "\n    keys=" + CardState.arrayToString(this.keys) + "\n    currentSecurityLevel=" + this.currentSecurityLevel + "\n    phone=" + Utils.canonize(this.phone) + "\n    installedCapFiles=" + this.installedCapFiles + ')';
    }

    private static String arrayToString(Object[] list) {
        StringBuilder retVal = new StringBuilder("{");
        for (Object object : list) {
            retVal.append(" ").append(object);
        }
        retVal.append(" }");
        return retVal.toString();
    }

    public static void main(String[] args) {
        File root = null;
        ArrayList<String> iccids = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-storageDir")) {
                root = new File(args[++i]);
                continue;
            }
            iccids.add(args[i]);
        }
        for (String id : iccids) {
            System.out.println(id + " := " + CardState.restore(root, id));
        }
    }
}

