/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.terminal;

import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import java.util.Observable;
import javax.smartcardio.CardException;

public class CardPresenceNotifier
extends Observable
implements Runnable {
    private StatefulCardTerminal terminal;
    private boolean wasCardPresent;

    public CardPresenceNotifier(StatefulCardTerminal terminal) throws CardException {
        this.terminal = terminal;
        this.wasCardPresent = terminal.isCardPresent();
    }

    public StatefulCardTerminal getTerminal() {
        return this.terminal;
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    boolean isCardPresent;
                    if ((isCardPresent = this.terminal.isCardPresent()) != this.wasCardPresent) {
                        this.setChanged();
                        if (isCardPresent) {
                            this.notifyObservers((Object)CardEvent.CARD_INSERTED);
                        } else {
                            this.notifyObservers((Object)CardEvent.CARD_REMOVED);
                        }
                        this.wasCardPresent = isCardPresent;
                    }
                    Thread.yield();
                }
            }
            catch (CardException ex) {
                this.terminal.setState(StatefulCardTerminal.State.INVALID);
                this.setChanged();
                this.notifyObservers((Object)CardEvent.INVALID_STATE);
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CardEvent {
        CARD_INSERTED,
        CARD_REMOVED,
        INVALID_STATE;

    }
}

