/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.tlv;

import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.me.utils.Utils;
import java.util.ArrayList;

public class TLVEncoder {
    private TLVBuffer out;
    private ArrayList<StackEntry> stack = new ArrayList();

    public TLVEncoder(int length) {
        this.out = new TLVBuffer(new byte[length]);
    }

    public void startLV(String name) throws EncodingException {
        this.stack.add(new StackEntry(name, this.out.createChild(1)));
    }

    public void startTag(int tag) throws EncodingException {
        this.startTag(tag, null);
    }

    public void startTag(int tag, String name) throws EncodingException {
        this.out.write(tag);
        this.startLV(name);
    }

    public void end() throws EncodingException {
        this.end(null);
    }

    public void end(String name) throws EncodingException {
        if (this.stack.isEmpty()) {
            throw new EncodingException("Stack is empty.");
        }
        StackEntry entry = this.stack.get(this.stack.size() - 1);
        if (name != null && !name.equals(entry.name)) {
            throw new EncodingException("Tag mismatch: Expected " + name + " Found " + entry.name);
        }
        this.stack.remove(this.stack.size() - 1);
        TLVUtils.writeLength(entry.length, this.out.getPos() - entry.length.end());
    }

    public TLVBuffer out() {
        return this.out;
    }

    public void close() throws EncodingException {
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            this.end(null);
        }
    }

    public byte[] toByteArray() throws EncodingException {
        this.close();
        byte[] retVal = new byte[this.out.getPos()];
        System.arraycopy(this.out.getBuffer(), 0, retVal, 0, retVal.length);
        return retVal;
    }

    public String toString() {
        return "(TLVEncoder isFinalized=" + this.stack.isEmpty() + " data=" + Utils.canonize(this.out.getBuffer(), 0, this.out.getPos()) + ')';
    }

    public static void main(String[] args) throws Exception {
        TLVEncoder out = new TLVEncoder(8);
        out.startTag(241);
        out.startTag(242);
        out.out().write(16909060L, 4);
        out.startTag(226);
        out.out().write(16909060L, 4);
        out.out().write(5);
        out.end();
        out.end();
        out.startLV(null);
        out.out().write(73317684245L, 5);
        out.end();
        out.startTag(243);
        out.out().write(new byte[]{33, 34, 35, 36});
        out.end();
        out.end();
        System.out.println(Utils.canonize(out.toByteArray()));
    }

    private static class StackEntry {
        TLVBuffer length;
        String name;

        StackEntry(String name, TLVBuffer length) {
            this.name = name;
            this.length = length;
        }
    }
}

