/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.security;

import com.sun.tck.bvtool.etsi.security.Checksum;
import com.sun.tck.bvtool.etsi.security.KeyDescr;
import java.security.GeneralSecurityException;

public class CryptographicChecksum
extends Checksum {
    byte[] buff = new byte[8];
    byte[] checksum = new byte[8];
    int pos;
    KeyDescr key;

    public CryptographicChecksum(KeyDescr key) {
        this.key = key;
    }

    public int getLength() {
        return 8;
    }

    public byte getCode() {
        return 2;
    }

    public void update(byte[] data, int offset, int length) throws GeneralSecurityException {
        int processed = 0;
        int blockSize = this.getLength();
        while (processed < length) {
            if (this.pos == blockSize) {
                this.checksum = this.key.cipher.update(this.buff);
                this.pos = 0;
            }
            int toDo = Math.min(blockSize - this.pos, length - processed);
            System.arraycopy(data, offset + processed, this.buff, this.pos, toDo);
            processed += toDo;
            this.pos += toDo;
        }
    }

    public byte[] calculateCheckSum() throws GeneralSecurityException {
        while (this.pos < this.buff.length) {
            this.buff[this.pos++] = 0;
        }
        this.checksum = this.key.cipher.doFinal(this.buff);
        this.pos = 0;
        return this.checksum;
    }

    public String toString() {
        return "CryptographicChecksum{key=" + this.key + '}';
    }
}

