/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.gsm;

import com.sun.tck.bvtool.etsi.data.sms.SMSParser;
import com.sun.tck.bvtool.etsi.tlv.ConstantBundle;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVPrototypeFactory;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;

public class ProactiveCommandTLV
extends ConstructedTLV {
    private ConstantBundle details = this.createDetailsBundle();
    private int itemCount = 0;

    public ProactiveCommandTLV() {
        this.constants.setAddRequired(true);
        this.setTagInternal((byte)-48, null);
    }

    private ConstantBundle createDetailsBundle() {
        ConstantBundle retVal = new ConstantBundle(false, null);
        retVal.register(1, "REFRESH");
        retVal.register(2, "MORE TIME");
        retVal.register(3, "POLL INTERVAL");
        retVal.register(4, "POLLING OFF");
        retVal.register(5, "SET UP EVENT LIST");
        retVal.register(16, "SET UP CALL");
        retVal.register(17, "Reserved for GSM/3G (SEND SS)");
        retVal.register(18, "Reserved for GSM/3G (SEND USSD)");
        retVal.register(19, "SEND SHORT MESSAGE");
        retVal.register(20, "SEND DTMF");
        retVal.register(21, "LAUNCH BROWSER");
        retVal.register(32, "PLAY TONE");
        retVal.register(33, "DISPLAY TEXT");
        retVal.register(34, "GET INKEY");
        retVal.register(35, "GET INPUT");
        retVal.register(36, "SELECT ITEM");
        retVal.register(37, "SET UP MENU");
        retVal.register(38, "PROVIDE LOCAL INFORMATION");
        retVal.register(39, "TIMER MANAGEMENT");
        retVal.register(40, "SET UP IDLE MODE TEXT");
        retVal.register(48, "PERFORM CARD APDU");
        retVal.register(49, "POWER ON CARD");
        retVal.register(50, "POWER OFF CARD");
        retVal.register(51, "GET READER STATUS");
        retVal.register(52, "RUN AT COMMAND");
        retVal.register(53, "LANGUAGE NOTIFICATION");
        retVal.register(64, "OPEN CHANNEL");
        retVal.register(65, "CLOSE CHANNEL");
        retVal.register(66, "RECEIVE DATA");
        retVal.register(67, "SEND DATA");
        retVal.register(68, "GET CHANNEL STATUS");
        retVal.register(69, "SERVICE SEARCH");
        retVal.register(70, "GET SERVICE INFORMATION");
        retVal.register(71, "DECLARE SERVICE");
        retVal.register(129, "End of the proactive session not applicable");
        return retVal;
    }

    public void createChild(long tag, TLVPrototypeFactory processor, TLVBuffer in) throws Exception {
        TLVUtils.readTag(in);
        int length = TLVUtils.readLength(in);
        byte[] data = in.readArray(length);
        String name = null;
        RawTLV retVal = new RawTLV((byte)tag, data);
        retVal.setFactory(processor);
        retVal.setTag((byte)tag, null);
        byte canonical = (byte)(0x7FL & tag);
        switch (canonical) {
            case 1: {
                retVal.add("command-number", new TreeNode.Data("command-number", data[0]));
                retVal.add("type-of-command", new TreeNode.Value("type-of-command", this.details.find(data[1])));
                retVal.add("command-qualifier", new TreeNode.Value("command-qualifier", ProactiveCommandTLV.getCommandQualifier(data[2])));
                name = "command-details";
                break;
            }
            case 2: {
                retVal.add("source", new TreeNode.Value("source", ProactiveCommandTLV.getDeviceIdentity(data[0])));
                retVal.add("destination", new TreeNode.Value("destination", ProactiveCommandTLV.getDeviceIdentity(data[1])));
                name = "device-identity";
                break;
            }
            case 5: {
                retVal.add("identifier", new TreeNode.Data("identifier=", data));
                name = "alpha-identifier";
                break;
            }
            case 15: {
                retVal = new RawTLV((byte)tag, data);
                name = "item-" + this.itemCount++;
                break;
            }
            case 11: {
                SMSParser.initSMS(retVal, data);
                name = "SMS-TPDU";
                break;
            }
            default: {
                name = null;
            }
        }
        this.add(name, retVal);
    }

    public static String getCommandQualifier(int val) {
        switch (val & 0xFF) {
            case 0: {
                return "NAA Initialization and Full File Change Notification";
            }
            case 1: {
                return "File Change Notification";
            }
            case 2: {
                return "NAA Initialization and File Change Notification";
            }
            case 3: {
                return "NAA Initialization";
            }
            case 4: {
                return "UICC Reset";
            }
            case 5: {
                return "NAA Application Reset, only applicable for a 3G platform";
            }
            case 6: {
                return "NAA Session Reset, only applicable for a 3G platform";
            }
            case 7: {
                return "reserver (07)";
            }
            case 255: {
                return "reserved (FF)";
            }
        }
        return "Unknown:" + Integer.toHexString(val & 0xFF);
    }

    public static String getDeviceIdentity(int val) {
        switch (val & 0xFF) {
            case 1: {
                return "Keypad";
            }
            case 2: {
                return "Display";
            }
            case 3: {
                return "Earpiece";
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return "Additional Card Reader #" + (val & 0xF);
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                return "Channel #" + (val & 0xF);
            }
            case 129: {
                return "UICC";
            }
            case 130: {
                return "terminal";
            }
            case 131: {
                return "network";
            }
        }
        return "Reserver: 0x" + Integer.toHexString(val & 0xFF);
    }
}

