/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data.sms;

import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.tck.bvtool.etsi.data.CompactApduPacket;
import com.sun.tck.bvtool.etsi.tlv.ConstructedTLV;
import com.sun.tck.bvtool.etsi.tlv.Encodable;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.RawTLV;
import com.sun.tck.bvtool.etsi.tlv.TLV;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TreeNode;
import com.sun.tck.bvtool.terminal.Card;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMS_PP_TLV
extends ConstructedTLV {
    private byte[] phone = new byte[]{18, 52, 86, 120};
    private Encodable packet;
    private Date date;
    private boolean isConcatinated = false;
    private byte refNumber;
    private byte sequenceNumber;
    private byte numberOfMessages;
    StringBuffer tpduString = new StringBuffer("    TPDU={\n");
    private static int refCount = 0;

    public TLV createDeviceIdentities() {
        return new RawTLV(-126, new byte[]{-125, -127});
    }

    public TLV createTPDU() throws EncodingException {
        TLVBuffer out = new TLVBuffer(256);
        out.write(64);
        this.tpduString.append("        header=0x40\n");
        this.encodeTP_OA(out);
        this.encodeTP_PID(out);
        this.encodeTP_DCS(out);
        this.encodeTP_SCTS(out);
        this.encodeTP_UD_as_LV(out);
        byte[] data = new byte[out.getPos()];
        System.arraycopy(out.getBuffer(), 0, data, 0, data.length);
        return new RawTLV(-117, data);
    }

    private void encodeTP_OA(TLVBuffer out) {
        out.write(9346406901127L, 6);
    }

    private void encodeTP_PID(TLVBuffer out) {
        this.tpduString.append("        TP_PID=0x7F\n");
        out.write(127);
    }

    private void encodeTP_DCS(TLVBuffer out) {
        this.tpduString.append("        TP_DCS=0xF6\n");
        out.write(246);
    }

    private void encodeTP_SCTS(TLVBuffer out) {
        for (int i = 0; i < 7; ++i) {
            out.write(0);
        }
    }

    private void encodeUDHL(TLVBuffer out) {
        if (this.isConcatinated) {
            out.write(this.sequenceNumber == 1 ? 7 : 5);
            out.write(0);
            out.write(3);
            out.write(this.refNumber);
            out.write(this.numberOfMessages);
            out.write(this.sequenceNumber);
            if (this.sequenceNumber == 1) {
                out.write(112);
                out.write(0);
            }
        } else {
            out.write(2);
            out.write(112);
            out.write(0);
        }
    }

    private void encodeTP_UD_as_LV(TLVBuffer out) throws EncodingException {
        TLVBuffer TP_UDL = out.createChild(1);
        this.encodeUDHL(out);
        this.packet.encode(out);
        TP_UDL.write(out.getPos() - TP_UDL.end());
    }

    public void init() throws EncodingException {
        this.addIfNonNull("device-identities", this.createDeviceIdentities());
        this.addIfNonNull("address", this.createAddress());
        this.addIfNonNull("tpdu", this.createTPDU());
    }

    public TLV createAddress() {
        return new RawTLV(-122, "80 89674523");
    }

    public void addIfNonNull(String name, TLV tlv) {
        if (tlv != null) {
            this.add(name, tlv);
        }
    }

    private void writeDigitForGSM11_11S(TLVBuffer out, int value, int rem) {
        int val;
        String hex;
        this.tpduString.append((hex = Integer.toHexString((val = (value %= rem * rem) % rem << 4 + value / rem) & 0xFF)).length() == 1 ? "0" : "").append(hex);
        out.write(val);
    }

    public SMS_PP_TLV() throws Exception {
        this.setTag((byte)-47, null);
    }

    public SMS_PP_TLV(Encodable packet, boolean doInit) throws EncodingException {
        this.setTag((byte)-47, null);
        this.packet = packet;
        if (doInit) {
            this.init();
        }
    }

    private static synchronized byte createReferenceNumber() {
        return (byte)(++refCount);
    }

    public static List<SMS_PP_TLV> create(Card card, int length, CommandAPDU ... apdus) throws EncodingException, FatalException {
        CompactApduPacket packet = new CompactApduPacket(apdus);
        packet.init(card);
        packet.setCompactMode(true);
        byte[] data = packet.toByteArray();
        if (data.length <= length) {
            SMS_PP_TLV sms = new SMS_PP_TLV(new TreeNode.Data("compact-apdu", data), false);
            sms.phone = card.getPhone();
            sms.init();
            return Collections.singletonList(sms);
        }
        ArrayList<SMS_PP_TLV> retVal = new ArrayList<SMS_PP_TLV>();
        int count = data.length / length;
        count += data.length % length > 0 ? 1 : 0;
        byte refNumber = SMS_PP_TLV.createReferenceNumber();
        for (int i = 0; i < count; ++i) {
            int offset = i * length;
            int toDo = Math.min(data.length - offset, length);
            TreeNode.Data part = new TreeNode.Data("data-" + i, data, offset, toDo);
            SMS_PP_TLV sms = new SMS_PP_TLV(part, false);
            sms.isConcatinated = true;
            sms.refNumber = refNumber;
            sms.numberOfMessages = (byte)count;
            sms.sequenceNumber = (byte)(i + 1);
            sms.phone = card.getPhone();
            sms.init();
            retVal.add(sms);
        }
        return retVal;
    }

    public String getShortDescription() {
        return this.isConcatinated ? "(concatenated-short-message referenceNumber=" + this.refNumber + " sequenceNumber=" + this.sequenceNumber + " numberOfMessages=" + this.numberOfMessages + ")" : "(command-packet)";
    }
}

