/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tck.bvtool.etsi.data;

import com.sun.tck.bvtool.etsi.data.HeaderTLV;
import com.sun.tck.bvtool.etsi.security.KeyDescr;
import com.sun.tck.bvtool.etsi.tlv.EncodingException;
import com.sun.tck.bvtool.etsi.tlv.TLVBuffer;
import com.sun.tck.bvtool.etsi.tlv.TLVUtils;
import com.sun.tck.me.utils.Utils;
import java.security.GeneralSecurityException;

public class CommandHeader
extends HeaderTLV {
    private short SPI;
    private byte KIc;
    private TLVBuffer securedDataBuff;
    public TLVBuffer encrypted;

    protected void initData() {
        this.SPI = this.card.encodeSPI();
        this.KIc = (byte)this.encode(this.card.getKIC());
        this.KID = (byte)this.encode(this.card.getKID());
    }

    private int encode(KeyDescr key) {
        return key == null ? 0 : key.encodeKey();
    }

    public void writeHeaderData(TLVBuffer out) {
        out.write(this.SPI, 2);
        out.write(this.KIc);
        out.write(this.KID);
        out.write(this.getTAR(), 3);
        this.startEncryptedData = out.createPosition();
        out.write(this.counter, 5);
        out.write(this.PCNTR);
    }

    public void decrypt(TLVBuffer padded) throws GeneralSecurityException, EncodingException {
        this.encrypted.setPosTo(this.encrypted.start());
        this.counter = this.encrypted.read(5);
        this.PCNTR = (byte)this.encrypted.read();
        if (this.checkSumSection != null) {
            this.checkSumSection.setPosTo(this.checkSumSection.start());
            this.checkSum = this.checkSumSection.readArray(this.checkSumSection.available());
        }
    }

    public String toString() {
        this.init();
        return this.getClass().getSimpleName() + "{\n" + "    SPI=" + TLVUtils.toBinaryString(this.SPI, 2, " ") + "\n" + "    KIc=" + TLVUtils.toBinaryString(this.KIc, 1, "") + "\n" + "    KID=" + TLVUtils.toBinaryString(this.KID, 1, "") + "\n" + "    TAR=0x" + Integer.toHexString(this.getTAR() & 0xFFFFFF) + "\n" + "    CNTR=0x" + Long.toHexString(this.counter) + "\n" + "    PCNTR=0x" + Integer.toHexString(this.PCNTR & 0xFF) + "\n" + "    RC/CC/DS=0x" + Utils.canonize(this.checkSum) + "}";
    }

    public void parseHeader() throws EncodingException {
        this.headerlength = this.buffer.read();
        this.SPI = (short)this.buffer.read(2);
        this.KIc = (byte)this.buffer.read();
        this.KID = (byte)this.buffer.read();
        this.setTAR((int)this.buffer.read(3));
        this.startEncryptedData = this.buffer.createPosition();
    }

    public void parseDecryptedHeader() throws EncodingException {
        this.counter = this.buffer.read(5);
        this.PCNTR = (byte)this.buffer.read();
        int sigLength = this.headerlength - this.buffer.getPos() + this.startValue.pos + 1;
        this.checkSum = this.buffer.readArray(sigLength);
        this.securedDataBuff = this.buffer.createChild(this.buffer.available() - this.PCNTR);
    }

    public TLVBuffer getSecuredData() {
        return this.securedDataBuff;
    }
}

