/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jck.lib;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.jck.lib.Expr;

public class JCKTestFilter
extends TestFilter {
    private TestEnvironment env;
    private int product;
    private int mode;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(JCKTestFilter.class);

    public JCKTestFilter(TestEnvironment env, int product, int mode) {
        this.env = env;
        this.product = product;
        this.mode = mode;
    }

    public String getName() {
        return i18n.getString("jckFilter.name");
    }

    public String getDescription() {
        return i18n.getString("jckFilter.description");
    }

    public String getReason() {
        return i18n.getString("jckFilter.reason");
    }

    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        String reqdKeyword;
        String keywords = td.getParameter("keywords");
        String string = reqdKeyword = this.product == 2 ? "runtime" : "compiler";
        if (!this.containsKeyword(keywords, reqdKeyword)) {
            return false;
        }
        switch (this.mode) {
            case 2: {
                return true;
            }
            case 1: 
            case 3: {
                try {
                    String s = td.getParameter("selectIf");
                    if (!(s != null && s.length() != 0 || (s = td.getParameter("executeIf")) != null && s.length() != 0)) {
                        return true;
                    }
                    Expr e = Expr.parse(s);
                    return e.evalBoolean(this.env);
                }
                catch (Expr.Fault e) {
                    throw new TestFilter.Fault(i18n, "jckFilter.error", new Object[]{td.getRootRelativeURL(), e.getMessage()});
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JCKTestFilter)) {
            return false;
        }
        JCKTestFilter other = (JCKTestFilter)((Object)o);
        return this.env == this.env && this.product == other.product && this.mode == other.mode;
    }

    private boolean containsKeyword(String all, String reqd) {
        int reqdLen = reqd.length();
        int allLen = all == null ? 0 : all.length();
        for (int i = 0; i <= allLen - reqdLen; ++i) {
            if (!all.regionMatches(true, i, reqd, 0, reqdLen) || i != 0 && !JCKTestFilter.isBoundaryCh(all.charAt(i - 1)) || i + reqdLen != all.length() && !JCKTestFilter.isBoundaryCh(all.charAt(i + reqdLen))) continue;
            return true;
        }
        return false;
    }

    private static boolean isBoundaryCh(char c) {
        return !Character.isUnicodeIdentifierStart(c) && !Character.isUnicodeIdentifierPart(c);
    }
}

