/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.referenceimpl.CJCRECardService;
import java.io.File;
import java.io.IOException;
import java.util.Vector;

public class PrecompileCardService
extends CJCRECardService {
    private Vector packages = new Vector();
    private String export_destination;

    public PrecompileCardService() {
    }

    public PrecompileCardService(int port) throws IOException {
        super(port);
    }

    public void startTest(String workingDir, int numberOfExecutions) throws FrameworkException {
        this.packages.clear();
        super.startTest(workingDir, numberOfExecutions);
    }

    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputDir, AppletProperties[] apa) throws FrameworkException {
        this.packages.addElement(new String[]{outputDir, packageName});
        return super.convertPackage(packageName, packageAid, majorVersion, minorVersion, classRootDir, exportRootDir, isExportMap, outputDir, apa);
    }

    public void stopTest() throws FrameworkException {
        super.stopTest();
        if (this.packages.size() <= 1) {
            return;
        }
        String export_destination = (String)this.serviceProperties.get("export_destination");
        for (int i = 0; i < this.packages.size(); ++i) {
            String[] data = (String[])this.packages.elementAt(i);
            this.log.log(I18n.getString("procompile.copy.export.file", data[1], data[0], export_destination), 2);
            String suffix = PrecompileCardService.getExportFileLocation(data[1]);
            File dir = new File(PrecompileCardService.getExportDir(export_destination, data[1]));
            File old = new File(data[0] + File.separator + suffix);
            File file = new File(export_destination + File.separator + suffix);
            if (file.isFile()) {
                return;
            }
            if (!dir.mkdirs()) {
                throw new FrameworkException(I18n.getString("can.not.create.dir.for.package", data[1], dir));
            }
            if (old.renameTo(file)) continue;
            throw new FrameworkException(I18n.getString("can.not.move.export.file.for.package", data[1], old, this.getExportDestination(export_destination, suffix)));
        }
    }

    public String getExportDestination(String export, String suffix) {
        return export + File.separator + suffix;
    }

    public static String getExportFileLocation(String name) {
        int pos = name.lastIndexOf(".");
        String last_entry = name.substring(pos + 1);
        String start_entry = pos < 0 ? "" : name.substring(0, pos);
        return name.replace('.', File.separatorChar) + File.separator + "javacard" + File.separator + last_entry + ".exp";
    }

    public static String getExportDir(String prefix, String name) {
        int pos = name.lastIndexOf(".");
        String start_entry = pos < 0 ? "" : name.substring(0, pos);
        return prefix + File.separator + name.replace('.', File.separatorChar) + File.separator + "javacard";
    }
}

