/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.referenceimpl.CJCRECardService;
import com.sun.tck.bvtool.etsi.gp.GPCapFileInfo;
import com.sun.tck.me.utils.Utils;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public class DebugCJCRECardService
extends CJCRECardService {
    private LinkedHashSet<String> packages = new LinkedHashSet();
    private PrintWriter out;

    public boolean deletePackage(AppletID packageID, String packageName) throws DeploymentException {
        boolean retVal = super.deletePackage(packageID, packageName);
        if (retVal) {
            this.packages.remove(DebugCJCRECardService.canonize(packageID.getBytes()));
        }
        return retVal;
    }

    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws DeploymentException {
        boolean retVal = super.deletePackageAndInstances(packageID, packageName);
        if (retVal) {
            this.packages.remove(DebugCJCRECardService.canonize(packageID.getBytes()));
        }
        return retVal;
    }

    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws DeploymentException {
        boolean retVal = super.installCAPFile(appletPropertiesArray, aCAPFileName, outputDir);
        try {
            if (retVal) {
                GPCapFileInfo info = GPCapFileInfo.createData(this.out, aCAPFileName);
                this.packages.add(DebugCJCRECardService.canonize(info.packageAID.getBytes()));
            }
        }
        catch (Exception e) {
            this.out.println("DEBUG-ERROR:" + e);
            e.printStackTrace(this.out);
        }
        return retVal;
    }

    public static String canonize(byte[] path) {
        if (path == null) {
            return null;
        }
        return DebugCJCRECardService.canonize(path, 0, path.length);
    }

    public static String canonize(byte[] path, int offset, int length) {
        if (path == null) {
            return null;
        }
        StringBuffer retVal = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            String e = Integer.toHexString(path[i + offset] & 0xFF);
            if (e.length() == 1) {
                retVal.append('0');
            }
            retVal.append(e);
        }
        return retVal.toString();
    }

    public void stopTest() throws FrameworkException {
        ArrayList<String> aids = new ArrayList<String>();
        aids.addAll(this.packages);
        this.powerUp();
        for (int i = aids.size() - 1; i >= 0; --i) {
            String aid = (String)aids.get(i);
            this.out.println("DEBUG-LOG: deleting " + aid);
            try {
                AppletID id = new AppletID(Utils.parse(aid));
                boolean retVal = this.deletePackageAndInstances(id, "unknown");
                if (retVal) {
                    this.out.println("DEBUG-LOG:OK " + aid);
                    continue;
                }
                this.out.println("DEBUG-ERROR:FAILS " + aid);
                continue;
            }
            catch (Exception e) {
                this.out.println("DEBUG-ERROR:" + e);
                e.printStackTrace(this.out);
            }
        }
        this.powerDown();
        super.stopTest();
    }

    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        super.init(args, out, ref);
        this.out = out;
    }

    public void startTest(String workingDir, int numberOfExecutions) throws FrameworkException {
        super.startTest(workingDir, numberOfExecutions);
    }
}

