/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.referenceimpl;

import com.sun.javacard.apduio.TLP224Exception;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javacard.referenceimpl.CJCRECardService;
import com.sun.javacard.referenceimpl.PrefixLogger;
import com.sun.javacard.referenceimpl.ProcessManager;
import java.io.IOException;
import java.io.PrintWriter;

public class ContactlessService
extends CJCRECardService {
    protected CJCRECardService contactedService;

    void setContactedService(CJCRECardService service) {
        this.contactedService = service;
    }

    public boolean isCrefRunning() {
        if (this.contactedService != null) {
            return this.contactedService.isCrefRunning();
        }
        return super.isCrefRunning();
    }

    int getPort() {
        return this.contactedService.getPort() + 1;
    }

    public void startCref() throws FrameworkException {
        super.startCref();
        if (this.contactedService != null) {
            this.contactedService.crefRunning = true;
        }
    }

    public void powerDownCad() throws TLP224Exception, IOException {
        this.log.log("powerDownCad()", 0);
        this.cad.powerDown();
    }

    public void stopCref() {
    }

    public ProcessManager.Descriptor getCurrentProcDescriptor() {
        if (this.currentProcDescriptor == null && this.contactedService != null) {
            this.currentProcDescriptor = this.contactedService.getCurrentProcDescriptor();
        }
        return this.currentProcDescriptor;
    }

    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        super.init(args, out, ref);
        this.log = new PrefixLogger("CONTACTLESS: ", 0, out, ref);
    }

    public void powerUp() throws FrameworkException {
        this.log.log("powerUp()", 0);
        if (this.isMainCommunicationService) {
            this.log.log("Call contacted service powerUp from contactless service", 0);
            this.contactedService.powerUp();
        }
        this.initiateContacted();
        super.powerUp();
    }

    public void powerDown() throws FrameworkException {
        super.powerDown();
        if (this.isMainCommunicationService) {
            this.contactedService.powerDown();
        }
    }

    protected void initiateContacted() throws FrameworkException {
        CommandAPDU openChCmd = new CommandAPDU(0, 112, 0, 1, new byte[0], 0);
        CommandAPDU closeChCmd = new CommandAPDU(0, 112, -128, 1, new byte[0], 0);
        this.contactedService.sendAPDU(openChCmd);
        this.contactedService.sendAPDU(closeChCmd);
    }
}

