/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.scripts.rmi;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.scripts.RMIScript;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.scripts.rmi.ResponseException;
import com.sun.javacard.cjck.userinterface.CardProxyException;

public class Parameter {
    protected byte[] bytes;
    protected String name;

    protected Parameter() {
    }

    public static int makeInt(byte b1, byte b2, byte b3, byte b4) {
        return b1 << 24 & 0xFF000000 | b2 << 16 & 0xFF0000 | b3 << 8 & 0xFF00 | b4 & 0xFF;
    }

    public static Parameter parseReturnData(byte[] data, int expected_type) throws ResponseException, CardProxyException {
        Parameter retVal = null;
        if (expected_type == 1) {
            RMIScript.check(data == null || data.length == 0, I18n.getString("void.should.return.zero"));
            return new Void();
        }
        if ((expected_type & 0xF0) == 16) {
            if (data.length == 1 && data[0] == -1) {
                throw new ScriptFailException(I18n.getString("correct.remote.null.ref.should.be.used"));
            }
            if (data.length == 2 && data[0] == -1 && data[1] == -1) {
                return new Null();
            }
        }
        switch (expected_type) {
            case 2: {
                retVal = new Boolean(false);
                break;
            }
            case 3: {
                retVal = new Byte(0);
                break;
            }
            case 4: {
                retVal = new Short(0);
                break;
            }
            case 5: {
                retVal = new Int(0);
                break;
            }
            case 18: {
                retVal = new BooleanArray(null);
                break;
            }
            case 19: {
                retVal = new ByteArray(null);
                break;
            }
            case 20: {
                retVal = new ShortArray(null);
                break;
            }
            case 21: {
                retVal = new IntArray(null);
            }
        }
        retVal.bytes = data;
        return retVal;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getType() {
        return this.name;
    }

    public boolean isNull() {
        return false;
    }

    public static void checkLength(byte[] data, int TYPE_SIZE) throws ScriptFailException {
        if (data == null || data.length == 0) {
            throw new ScriptFailException(I18n.getString("array.is.null.or.has.zero.length"));
        }
        int expected_length = (data[0] & 0xFF) * TYPE_SIZE + 1;
        if (expected_length != data.length) {
            throw new ScriptFailException(I18n.getString("array.has.incorrect.length", Integer.toHexString(expected_length), Integer.toHexString(data.length)));
        }
    }

    public static class IntArray
    extends Null {
        public IntArray(int[] value) {
            if (value == null) {
                this.name = I18n.getString("null.int.array.parameter");
                this.bytes = new byte[]{-1};
            } else {
                this.name = I18n.getString("int.array.parameter");
                this.bytes = new byte[value.length * 4 + 1];
                this.bytes[0] = (byte)value.length;
                for (int i = 0; i < value.length; ++i) {
                    this.bytes[1 + i * 4] = (byte)(value[i] >> 24);
                    this.bytes[1 + i * 4 + 1] = (byte)(value[i] >> 16);
                    this.bytes[1 + i * 4 + 2] = (byte)(value[i] >> 8);
                    this.bytes[1 + i * 4 + 3] = (byte)value[i];
                }
            }
        }

        public int[] getValue() {
            IntArray.checkLength(this.bytes, 4);
            int[] retVal = new int[this.bytes[0]];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = Parameter.makeInt(this.bytes[i * 4 + 1], this.bytes[i * 4 + 2], this.bytes[i * 4 + 3], this.bytes[i * 4 + 4]);
            }
            return retVal;
        }
    }

    public static class ShortArray
    extends Null {
        public ShortArray(short[] value) {
            if (value == null) {
                this.name = I18n.getString("null.short.array.parameter");
                this.bytes = new byte[]{-1};
            } else {
                this.name = I18n.getString("short.array.parameter");
                this.bytes = new byte[value.length * 2 + 1];
                this.bytes[0] = (byte)value.length;
                for (int i = 0; i < value.length; ++i) {
                    this.bytes[1 + i * 2] = (byte)(value[i] >> 8);
                    this.bytes[1 + i * 2 + 1] = (byte)value[i];
                }
            }
        }

        public short[] getValue() {
            ShortArray.checkLength(this.bytes, 2);
            short[] retVal = new short[this.bytes[0]];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = (short)Parameter.makeInt((byte)0, (byte)0, this.bytes[i * 2 + 1], this.bytes[i * 2 + 2]);
            }
            return retVal;
        }
    }

    public static class ByteArray
    extends Null {
        public ByteArray(byte[] value) {
            if (value == null) {
                this.name = I18n.getString("null.byte.array.parameter");
                this.bytes = new byte[]{-1};
            } else {
                this.name = I18n.getString("byte.array.parameter");
                this.bytes = new byte[value.length + 1];
                this.bytes[0] = (byte)value.length;
                System.arraycopy(value, 0, this.bytes, 1, value.length);
            }
        }

        public byte[] getValue() {
            ByteArray.checkLength(this.bytes, 1);
            byte[] retVal = new byte[this.bytes[0]];
            System.arraycopy(this.bytes, 1, retVal, 0, retVal.length);
            return retVal;
        }
    }

    public static class BooleanArray
    extends Null {
        public BooleanArray(boolean[] value) {
            this.name = I18n.getString("boolean.array.parameter");
            if (value == null) {
                this.name = I18n.getString("null.boolean.array.parameter");
                this.bytes = new byte[]{-1};
            } else {
                this.name = I18n.getString("boolean.array.parameter");
                this.bytes = new byte[value.length + 1];
                this.bytes[0] = (byte)value.length;
                for (int i = 0; i < value.length; ++i) {
                    this.bytes[1 + i] = (byte)(value[i] ? 1 : 0);
                }
            }
        }

        public boolean[] getValue() {
            BooleanArray.checkLength(this.bytes, 1);
            boolean[] retVal = new boolean[this.bytes[0]];
            for (int i = 0; i < retVal.length; ++i) {
                retVal[i] = this.bytes[i + 1] != 0;
            }
            return retVal;
        }
    }

    public static class Null
    extends Parameter {
        public Null() {
            this.name = I18n.getString("null.array.parameter");
            this.bytes = new byte[]{-1};
        }

        public boolean isNull() {
            return this.bytes == null || this.bytes.length == 1 && this.bytes[0] == -1;
        }
    }

    public static class Int
    extends Parameter {
        public Int(int value) {
            this.name = I18n.getString("integer.parameter");
            this.bytes = new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
        }

        public int getValue() {
            return Parameter.makeInt(this.bytes[0], this.bytes[1], this.bytes[2], this.bytes[3]);
        }
    }

    public static class Short
    extends Parameter {
        public Short(short value) {
            this.name = I18n.getString("short.parameter");
            this.bytes = new byte[]{(byte)(value >> 8), (byte)value};
        }

        public short getValue() {
            return (short)Parameter.makeInt((byte)0, (byte)0, this.bytes[0], this.bytes[1]);
        }
    }

    public static class Byte
    extends Parameter {
        public Byte(byte value) {
            this.name = I18n.getString("byte.parameter");
            this.bytes = new byte[]{value};
        }

        public byte getValue() {
            return this.bytes[0];
        }
    }

    public static class Boolean
    extends Parameter {
        public Boolean(boolean value) {
            this((byte)(value ? 1 : 0));
        }

        public Boolean(byte value) {
            this.name = I18n.getString("boolean.parameter");
            this.bytes = new byte[]{value};
        }

        public boolean getValue() {
            return this.bytes[0] != 0;
        }
    }

    public static class Raw
    extends Parameter {
        public Raw(byte[] data) {
            this.name = I18n.getString("raw.parameter");
            this.bytes = data;
        }
    }

    public static class Void
    extends Parameter {
        public Void() {
            this.name = I18n.getString("void.parameter");
            this.bytes = new byte[0];
        }
    }
}

