/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.userinterface.AppletID;
import com.sun.javacard.cjck.userinterface.AppletProperties;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CardService;
import com.sun.javacard.cjck.userinterface.CommandAPDU;
import com.sun.javacard.cjck.userinterface.CommunicationService;
import com.sun.javacard.cjck.userinterface.ResponseAPDU;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Map;

public class WrapperCardService
implements CJCKCardService {
    private CardService cardService;
    private CommunicationService comService;
    private CommunicationService contactedDualService;
    private Map services;
    private boolean isContactedAffected = false;

    public WrapperCardService(CardService cardService, int iface) throws CardProxyException {
        this.cardService = cardService;
        this.services = new Hashtable();
        this.comService = cardService.getCommunicationService(iface);
        this.addService(iface, this.comService);
    }

    public WrapperCardService(CardService cardService, int iface, boolean isDualIOSupported) throws CardProxyException {
        if (isDualIOSupported && iface == 2) {
            this.isContactedAffected = true;
            this.contactedDualService = cardService.getCommunicationService(1);
        }
        this.cardService = cardService;
        this.services = new Hashtable();
        this.comService = cardService.getCommunicationService(iface);
        this.addService(iface, this.comService);
    }

    public void startTest(String workingDir, int numberOfExecutions) throws CardProxyException {
        this.cardService.startTest(workingDir, numberOfExecutions);
    }

    public void stopTest() throws CardProxyException {
        this.cardService.stopTest();
    }

    public String convertPackage(String packageName, AppletID packageAid, int majorVersion, int minorVersion, String classRootDir, String exportRootDir, boolean isExportMap, String outputRootDir, AppletProperties[] apa) throws CardProxyException {
        return this.cardService.convertPackage(packageName, packageAid, majorVersion, minorVersion, classRootDir, exportRootDir, isExportMap, outputRootDir, apa);
    }

    public boolean loadClassFileApplets(String[] packageNames, AppletProperties[] appletProperties, String classRootDir, String outputRootDir) throws CardProxyException {
        return this.cardService.loadClassFileApplets(packageNames, appletProperties, classRootDir, outputRootDir);
    }

    public boolean loadCapFileApplets(String[] capfiles, AppletProperties[] appletProperties, String outputRootDir) throws CardProxyException {
        return this.cardService.loadCapFileApplets(capfiles, appletProperties, outputRootDir);
    }

    public void init(String[] args, PrintWriter out, PrintWriter ref) {
        this.cardService.init(args, out, ref);
    }

    public Hashtable getProperties() {
        return this.cardService.getProperties();
    }

    public CommunicationService getCommunicationService(int iface) throws CardProxyException {
        return this.getService(iface);
    }

    public void powerUp() throws CardProxyException {
        if (this.isContactedAffected) {
            this.contactedDualService.powerUp();
        }
        this.comService.powerUp();
    }

    public void powerDown() throws CardProxyException {
        this.comService.powerDown();
        if (this.isContactedAffected) {
            this.contactedDualService.powerDown();
        }
    }

    public void reset() throws CardProxyException {
        this.comService.powerDown();
        if (this.isContactedAffected) {
            this.contactedDualService.reset();
        }
        this.comService.powerUp();
    }

    public boolean installCAPFile(AppletProperties[] appletPropertiesArray, String aCAPFileName, String outputDir) throws CardProxyException {
        return this.cardService.installCAPFile(appletPropertiesArray, aCAPFileName, outputDir);
    }

    public ResponseAPDU sendAPDU(CommandAPDU capdu) throws CardProxyException {
        return this.comService.sendAPDU(capdu);
    }

    public boolean deleteAppletInstances(AppletProperties[] applets) throws CardProxyException {
        return this.cardService.deleteAppletInstances(applets);
    }

    public boolean deletePackage(AppletID packageID, String packageName) throws CardProxyException {
        return this.cardService.deletePackage(packageID, packageName);
    }

    public boolean deletePackageAndInstances(AppletID packageID, String packageName) throws CardProxyException {
        return this.cardService.deletePackageAndInstances(packageID, packageName);
    }

    private void addService(int iface, CommunicationService comService) {
        Integer key = new Integer(iface);
        if (!this.services.containsKey(key)) {
            this.services.put(key, comService);
        }
    }

    private CommunicationService getService(int iface) throws CardProxyException {
        Integer key = new Integer(iface);
        CommunicationService comService = (CommunicationService)this.services.get(key);
        if (comService == null) {
            comService = this.cardService.getCommunicationService(iface);
            this.addService(iface, comService);
        }
        return comService;
    }

    public void setCardTerminal(StatefulCardTerminal terminal) {
        this.cardService.setCardTerminal(terminal);
    }
}

