/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.ConfiguredScript;
import com.sun.javacard.cjck.invoke.CustomizableScript;
import com.sun.javacard.cjck.invoke.JavaCardScript;
import com.sun.javacard.cjck.invoke.MultiTestScript;
import com.sun.javacard.cjck.invoke.RunMode;
import com.sun.javacard.cjck.invoke.ScriptDefinition;
import com.sun.javacard.cjck.invoke.Utils;
import com.sun.javacard.cjck.scripts.ScriptFailException;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javatest.Status;
import com.sun.javatest.lib.MultiStatus;
import java.util.Enumeration;

public abstract class ExecuteMode
extends RunMode {
    protected CardProxyArguments args;
    protected ConfigFileReader configFile;

    public Status run(CardProxyArguments args, ConfigFileReader configFile) throws CardProxyException {
        this.args = args;
        this.configFile = configFile;
        Status retVal = this.load();
        return retVal.isPassed() || args.isLoadStatusIgnored() ? this.executeTestScripts() : retVal;
    }

    protected abstract Status load() throws CardProxyException;

    protected Status executeTestScripts() throws CardProxyException {
        Enumeration e = this.args.getScriptFiles();
        String[] excluded = this.args.getExcludedTestCases();
        while (e.hasMoreElements()) {
            JavaCardScript script = ((ScriptDefinition)e.nextElement()).loadScript();
            this.log(I18n.getString("process.script", this.getName(), script.getName()));
            script.setExcludeEntries(excluded);
            if (script instanceof ConfiguredScript) {
                this.log(I18n.getString("set.configfilereader.for", this.getName(), script.getName()));
                ((ConfiguredScript)script).setConfigFileReader(this.configFile);
            }
            if (script instanceof CustomizableScript) {
                this.log(I18n.getString("set.cardproxyarg.for", this.getName(), script.getName()));
                ((CustomizableScript)script).setCardProxyArguments(this.args);
            }
            Status status = script instanceof MultiTestScript ? this.runMultiTestScript((MultiTestScript)script) : script.run(this.cardService, this.logWriter, this.refWriter);
            this.log(I18n.getString("script.status", this.getName(), status));
            this.ref(I18n.getString("script.status", this.getName(), status));
            if (status.isPassed()) continue;
            return status;
        }
        return Status.passed((String)"");
    }

    private Status runMultiTestScript(MultiTestScript script) throws CardProxyException {
        MultiStatus retVal = new MultiStatus();
        int count = script.getTestCaseCount();
        int bundle_size = this.args.getBundleSize();
        StringBuffer footer = new StringBuffer();
        for (int i = 1; i <= count; ++i) {
            if (bundle_size != 0 && i != 1 && i % bundle_size == 0) {
                this.reinstallCode(this.args, this.configFile);
            }
            String id = I18n.getString("testcase.id.1", new Integer(i));
            try {
                Status current = script.runTestCase(i, this.cardService, this.logWriter, this.refWriter);
                this.ref(I18n.getString("multitest.testcase.status", new Integer(i), current));
                retVal.add(id, current);
                continue;
            }
            catch (ScriptFailException e) {
                this.ref(I18n.getString("multitest.testcase.status", new Integer(i), e.getStatus()));
                retVal.add(id, e.getStatus());
            }
        }
        return retVal.getStatus();
    }

    protected Status reinstallCode(CardProxyArguments args, ConfigFileReader configFile) throws CardProxyException {
        this.log(I18n.getString("reinstall.code", this.getName()));
        this.cardService.powerDown();
        this.cardService.stopTest();
        this.cardService.startTest(args.getOutputDir(), args.getNuberOfReset());
        return this.load();
    }

    protected String getFullCapFileName(String capname) throws CardProxyException {
        String[] dirs = new String[]{this.args.getCapFileDir(), this.args.getLibraryRoot(), this.args.getRefCapFileDir()};
        for (int i = 0; i < dirs.length; ++i) {
            String name = Utils.getCanonicalName(dirs[i], capname);
            String info = Utils.fileInfo(name);
            if (dirs[i] == null) {
                throw new CardProxyException(I18n.getString("can.not.find.capfile", name, info));
            }
            if (info == null) continue;
            return name;
        }
        throw new CardProxyException(I18n.getString("can.not.find.capfile", capname, null));
    }
}

