/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.JCScript;
import com.sun.javacard.cjck.invoke.CardProxyArguments;
import com.sun.javacard.cjck.invoke.CardServicesPool;
import com.sun.javacard.cjck.invoke.ConfigFileReader;
import com.sun.javacard.cjck.invoke.DelayedPrintWriter;
import com.sun.javacard.cjck.invoke.InstallMode;
import com.sun.javacard.cjck.invoke.RunMode;
import com.sun.javacard.cjck.invoke.WrapperCardService;
import com.sun.javacard.cjck.userinterface.BinaryToolService;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardProxyException;
import com.sun.javacard.cjck.userinterface.CardService;
import com.sun.javacard.cjck.userinterface.CardServiceFactory;
import com.sun.javacard.cjck.userinterface.CardSystemException;
import com.sun.javacard.cjck.userinterface.DeploymentException;
import com.sun.javacard.cjck.userinterface.FrameworkException;
import com.sun.javatest.Status;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class CardTest {
    public static final int CARD_REPLACEMENT_ATTEMPTS = 3;
    protected DelayedPrintWriter logWriter;
    protected DelayedPrintWriter refWriter;
    private String log_id;
    private ConfigFileReader configFile;
    private CJCKCardService cardService;
    private BinaryToolService baseService;
    private State state;
    private JCScript script;
    private static final String VERSION = "2.2.1 Binary Verification Tool";
    private static final String BUILD_DATE = "%E%";
    private static int instance;
    private CardProxyArguments args;

    public CardTest() {
        this.state = State.NOT_STARTED;
    }

    public CardTest(boolean rerun, JCScript script) {
        this.state = rerun ? State.WAITING_FOR_RERUN : State.NOT_STARTED;
        this.script = script;
    }

    public void setState(State state) {
        this.state = state;
        System.out.println("Test state set to " + (Object)((Object)state));
    }

    public State getState() {
        return this.state;
    }

    public static void main(String[] args) {
        PrintWriter log = new PrintWriter(System.out, true);
        DelayedPrintWriter logWriter = new DelayedPrintWriter(log);
        DelayedPrintWriter refWriter = new DelayedPrintWriter(new PrintWriter(System.err));
        logWriter.println(I18n.getString("cardproxy.version.build", VERSION, BUILD_DATE));
        CardTest test = new CardTest();
        Status status = test.run(args, logWriter, refWriter);
        if (status.isPassed()) {
            logWriter.resetData();
            refWriter.resetData();
        } else {
            logWriter.flushData();
            refWriter.flushData();
        }
        log.println(I18n.getString("cardproxy.run.status", status));
        status.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status run(String[] arguments, PrintWriter log, PrintWriter ref) {
        this.logWriter = new DelayedPrintWriter(log);
        this.refWriter = new DelayedPrintWriter(ref);
        this.log_id = I18n.getString("cardproxy.log.id", new Integer(instance));
        this.log(I18n.getString("run.starting.msg", this.log_id, VERSION, BUILD_DATE));
        Status status = this.instantiateResources(arguments);
        if (!status.isPassed()) {
            return status;
        }
        this.log(I18n.getString("java.classpath", System.getProperty("java.class.path")));
        try {
            InstallMode mode = new InstallMode();
            this.ref(I18n.getString("contacted.test.started"));
            mode.init(this.logWriter, this.refWriter, this.cardService);
            if (this.state == State.NOT_STARTED) {
                this.setState(State.EXECUTING);
            } else if (this.state == State.WAITING_FOR_RERUN) {
                this.setState(State.RERUNNING);
            }
            try {
                System.out.println("Before run: CardService state: " + (Object)((Object)this.baseService.getState()) + ", Test state: " + (Object)((Object)this.state));
                status = ((RunMode)mode).run(this.args, this.configFile);
            }
            catch (FrameworkException ex) {
                this.signalRerunnableFailure(ex);
            }
            catch (DeploymentException ex) {
                this.signalRerunnableFailure(ex);
            }
            catch (OutOfMemoryError ex) {
                this.signalRerunnableFailure(ex);
            }
            this.ref(I18n.getString("contacted.test.status", status));
            this.ref(I18n.getString("contacted.test.finished"));
        }
        catch (CardProxyException e) {
            status = Status.failed((String)I18n.getString("cardservice.exception", e));
        }
        catch (Throwable t) {
            t.printStackTrace(this.logWriter);
            this.logWriter.flushData();
            this.refWriter.flushData();
            Status status2 = Status.error((String)I18n.getString("unexpected.exception", t));
            return status2;
        }
        finally {
            this.finalizeTest();
        }
        this.logWriter.flushData();
        this.refWriter.flushData();
        if (this.state != State.WAITING_FOR_RERUN) {
            this.setState(State.COMPLETED);
        }
        System.out.println("After run: CardService state: " + (Object)((Object)this.baseService.getState()) + ", Test result: " + status + ", Test state: " + (Object)((Object)this.state));
        this.baseService.releaseTerminal();
        return status;
    }

    private void signalRerunnableFailure(Throwable ex) throws Throwable {
        if (!this.baseService.validateCardService()) {
            this.baseService.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
        } else if (this.state == State.EXECUTING) {
            this.setState(State.WAITING_FOR_RERUN);
            this.baseService.setState(StatefulCardTerminal.State.RECOVERED);
        } else if (this.state == State.RERUNNING) {
            this.baseService.setState(StatefulCardTerminal.State.VERIFIED);
        }
        throw ex;
    }

    protected Status instantiateResources(String[] args) {
        try {
            this.args = new CardProxyArguments(args);
            this.configFile = new ConfigFileReader(this.logWriter, this.refWriter);
            Enumeration e = this.args.getLibConfigFiles();
            while (e.hasMoreElements()) {
                this.configFile.read((String)e.nextElement());
            }
            this.configFile.read(this.args.getConfigFile());
            this.instantiateCardServices();
            return Status.passed((String)"");
        }
        catch (CardSystemException e) {
            return Status.error((String)I18n.getString("cardservice.init.exception", e));
        }
        catch (IllegalArgumentException ex) {
            return Status.failed((String)I18n.getString("can.not.parse.arg", ex));
        }
        catch (IOException io) {
            return Status.error((String)I18n.getString("can.not.read.config", io));
        }
    }

    protected void instantiateCardServices() throws CardSystemException {
        this.log(I18n.getString("contacted.init"));
        this.cardService = new WrapperCardService(this.getBaseCardService(), 1);
    }

    protected CardService getBaseCardService() throws CardSystemException {
        String name = this.args.getCardServiceClass();
        String path = this.args.getClassPath();
        this.log(I18n.getString("instantiate.cjckcardservice", this.log_id, name, path));
        CardService realService = CardServiceFactory.getCardService(name);
        this.baseService = CardServicesPool.getCardService(realService, this.args.getCardServiceArgs(), this.logWriter, this.refWriter);
        if (this.state == State.WAITING_FOR_RERUN && this.baseService.getState() == StatefulCardTerminal.State.RECOVERED) {
            this.baseService.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
        }
        if (this.baseService.getState() == StatefulCardTerminal.State.REPLACEMENT_REQUIRED) {
            for (int i = 0; i < 3; ++i) {
                if (this.baseService.getState() == StatefulCardTerminal.State.VERIFIED) continue;
                this.script.cancelTimeout();
                CardServicesPool.requireReplacement(this.baseService);
            }
        }
        if (this.baseService.getState() != StatefulCardTerminal.State.VERIFIED && this.baseService.getState() != StatefulCardTerminal.State.RECOVERED) {
            throw new CardProxyException(I18n.getString("card.verification.failed", 3));
        }
        this.script.resetTimeout();
        this.log(I18n.getString("init.cjckcardservice", this.log_id, name));
        this.baseService.startTest(this.args.getOutputDir(), this.args.getNuberOfReset());
        this.log(I18n.getString("cardservice.workdir.scriptcount", this.log_id, this.args.getOutputDir(), new Integer(this.args.getScriptFileCount())));
        return this.baseService;
    }

    Status finalizeTest() {
        try {
            this.baseService.deleteInstalledPackages();
            this.log(I18n.getString("call.powerdown", this.log_id));
            if (this.cardService != null) {
                this.cardService.powerDown();
                this.cardService.stopTest();
            }
            this.baseService.stopTest();
            return Status.passed((String)"");
        }
        catch (CardProxyException e) {
            return Status.failed((String)I18n.getString("powerdown.got.exception", e));
        }
    }

    void log(String msg) {
        this.logWriter.println(msg);
    }

    void ref(String msg) {
        this.log(msg);
        this.refWriter.println(msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NOT_STARTED,
        EXECUTING,
        WAITING_FOR_RERUN,
        RERUNNING,
        COMPLETED;

    }
}

