/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.cjck.invoke;

import com.sun.javacard.cjck.I18n;
import com.sun.javacard.cjck.userinterface.BinaryToolService;
import com.sun.javacard.cjck.userinterface.CJCKCardService;
import com.sun.javacard.cjck.userinterface.CardService;
import com.sun.javacard.cjck.userinterface.CardSystemException;
import com.sun.javacard.cjck.userinterface.FatalException;
import com.sun.javacard.globalimpl.GPCardService;
import com.sun.tck.bvtool.terminal.StatefulCardTerminal;
import com.sun.tck.jc.javatest.gui.GuiUserInteraction;
import com.sun.tck.jc.javatest.ui.UserInteraction;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CardServicesPool {
    public static final int TIMEOUT = 300;
    public static final int MAX_CONNECTION_ATTEMPTS = 3;
    private static int capacity = 0;
    private static State state = State.NON_INITIALIZED;
    private static String reason = null;
    private static final LinkedBlockingQueue<StatefulCardTerminal> terminalsQueue = new LinkedBlockingQueue();
    private static Vector<String> terminalLabels = new Vector();
    private static List<StatefulCardTerminal> availableTerminals = new ArrayList<StatefulCardTerminal>();
    private static UserInteraction ui = GuiUserInteraction.getUserInteraction();

    private static boolean initTerminals() {
        try {
            System.out.println("Initializing terminals:");
            TerminalFactory factory = TerminalFactory.getDefault();
            List<CardTerminal> terminalsList = factory.terminals().list();
            if (terminalsList == null || terminalsList.isEmpty()) {
                state = State.NO_TERMINALS;
            } else {
                capacity = terminalsList.size();
                int i = 1;
                for (CardTerminal cad : terminalsList) {
                    terminalLabels.add(String.valueOf(i++));
                    availableTerminals.add(new StatefulCardTerminal(cad));
                }
                state = State.INITIALIZED;
            }
        }
        catch (CardException ex) {
            state = State.INITIALIZE_ERROR;
            reason = ex.toString();
        }
        return true;
    }

    public static int getCapacity() {
        return capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BinaryToolService getCardService(CardService realService, String[] args, PrintWriter log, PrintWriter ref) throws CardSystemException {
        GPCardService cardService = null;
        int count = 0;
        while (count++ < capacity) {
            try {
                StatefulCardTerminal terminal = null;
                LinkedBlockingQueue<StatefulCardTerminal> linkedBlockingQueue = terminalsQueue;
                synchronized (linkedBlockingQueue) {
                    terminal = terminalsQueue.poll(300L, TimeUnit.SECONDS);
                    if (terminal == null) {
                        throw new CardSystemException(I18n.getString("pool.waiting.timeout"));
                    }
                    System.out.println("Terminal: " + terminal + " is requested");
                    cardService = new GPCardService();
                    cardService.setRealCardService((CJCKCardService)realService);
                    cardService.setCardTerminal(terminal);
                    cardService.init(args, log, ref);
                    CardServicesPool.checkCardServiceState(cardService);
                }
                if (cardService.getState() == StatefulCardTerminal.State.VERIFIED || cardService.getState() == StatefulCardTerminal.State.RECOVERED) {
                    System.out.println("Terminal: " + terminal + " is taken");
                    break;
                }
                cardService = null;
                System.out.println("Terminal: " + terminal + " is unavailable");
            }
            catch (InterruptedException ex) {
                throw new CardSystemException(I18n.getString("pool.waiting.interrupted", ex));
            }
        }
        if (cardService == null) {
            throw new CardSystemException("no.more.terminals.available");
        }
        return cardService;
    }

    public static void releaseTerminal(StatefulCardTerminal terminal) {
        System.out.println("Terminal: " + terminal + " is free");
        terminalsQueue.offer(terminal);
    }

    public static void checkState() throws CardSystemException {
        if (state == State.READY) {
            return;
        }
        if (state == State.INITIALIZED) {
            if (!CardServicesPool.identifyCardTerminals()) {
                throw new CardSystemException(I18n.getString("pool.not.identified"));
            }
        } else {
            if (state == State.NO_TERMINALS) {
                throw new CardSystemException(I18n.getString("pool.no.terminals"));
            }
            if (state == State.INITIALIZE_ERROR) {
                throw new CardSystemException(I18n.getString("pool.initialization.error", reason));
            }
            throw new CardSystemException(I18n.getString("pool.not.initialized"));
        }
        state = State.READY;
    }

    public static synchronized void requireReplacement(BinaryToolService cardService) throws CardSystemException {
        System.out.println("Card replacement required for card service: " + cardService);
        StatefulCardTerminal terminal = cardService.getCardTerminal();
        if (!ui.askForCardReplacement(terminal)) {
            CardServicesPool.replaceTerminal(terminal, cardService);
        } else if (CardServicesPool.checkConnection(terminal)) {
            CardServicesPool.setCardID(terminal);
        } else {
            CardServicesPool.replaceTerminal(terminal, cardService);
        }
        cardService.setState(StatefulCardTerminal.State.CREATED);
        CardServicesPool.checkCardServiceState(cardService);
    }

    private static void replaceTerminal(StatefulCardTerminal terminal, BinaryToolService cardService) throws CardSystemException {
        terminal.setState(StatefulCardTerminal.State.INVALID);
        if (--capacity == 0) {
            throw new CardSystemException("no.more.terminals.available");
        }
        try {
            StatefulCardTerminal anotherTerminal = terminalsQueue.poll(300L, TimeUnit.SECONDS);
            if (anotherTerminal == null) {
                throw new FatalException(FatalException.Scope.CAD_SYSTEM, "no.more.terminals.available");
            }
            cardService.setCardTerminal(anotherTerminal);
        }
        catch (InterruptedException ex) {
            throw new CardSystemException(I18n.getString("pool.waiting.interrupted", ex));
        }
    }

    private static void checkCardServiceState(BinaryToolService cardService) throws CardSystemException {
        if (cardService.getState() == StatefulCardTerminal.State.CREATED) {
            if (cardService.initializeCardService() && cardService.validateCardService()) {
                cardService.setState(StatefulCardTerminal.State.VERIFIED);
            } else {
                cardService.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
                CardServicesPool.requireReplacement(cardService);
            }
        } else if (cardService.getState() == StatefulCardTerminal.State.VERIFIED) {
            try {
                StatefulCardTerminal terminal = cardService.getCardTerminal();
                if (!terminal.checkCardPresent()) {
                    CardServicesPool.requireReplacement(cardService);
                    String cardID = ui.showCardIDSelectDialog(terminal.getLabel());
                    if (!CardServicesPool.checkCardID(cardID)) {
                        throw new CardSystemException(I18n.getString("card.id.incorrect", cardID));
                    }
                    terminal.setInsertedCardID(cardID);
                }
            }
            catch (CardSystemException ex) {
                cardService.setState(StatefulCardTerminal.State.REPLACEMENT_REQUIRED);
                CardServicesPool.requireReplacement(cardService);
            }
        }
    }

    private static void addTerminalToQueue(StatefulCardTerminal terminal) throws CardSystemException {
        if (CardServicesPool.checkConnection(terminal)) {
            CardServicesPool.setCardID(terminal);
            terminalsQueue.offer(terminal);
        } else {
            --capacity;
        }
    }

    private static void setCardID(StatefulCardTerminal terminal) throws CardSystemException {
        String cardID = ui.showCardIDSelectDialog(terminal.getLabel());
        if (!CardServicesPool.checkCardID(cardID)) {
            throw new CardSystemException(I18n.getString("card.id.incorrect", cardID));
        }
        terminal.setInsertedCardID(cardID);
    }

    public static List<StatefulCardTerminal> getAvailableTerminals() {
        return availableTerminals;
    }

    private static boolean identifyCardTerminals() throws CardSystemException {
        String terminalLabel;
        if (capacity == 1) {
            StatefulCardTerminal terminal = availableTerminals.get(0);
            terminalLabel = terminalLabels.elementAt(0);
            try {
                if (!terminal.isCardPresent()) {
                    ui.askForCardInsertion(terminalLabel, false);
                }
            }
            catch (CardException ex) {
                throw new CardSystemException(I18n.getString("pool.not.initialized"));
            }
            terminal.setLabel(terminalLabel);
            CardServicesPool.addTerminalToQueue(terminal);
        } else {
            StatefulCardTerminal identifiedTerminal;
            for (StatefulCardTerminal terminal : availableTerminals) {
                try {
                    if (!terminal.isCardPresent()) continue;
                    throw new CardSystemException(I18n.getString("pool.not.identified.nonempty"));
                }
                catch (CardException ex) {
                    throw new CardSystemException(I18n.getString("pool.initialization.error", ex.getMessage()));
                }
            }
            for (int i = 0; i < capacity && (identifiedTerminal = ui.askForCardInsertion(terminalLabel = terminalLabels.remove(0), false)) != null; ++i) {
                identifiedTerminal.setLabel(terminalLabel);
                CardServicesPool.addTerminalToQueue(identifiedTerminal);
            }
        }
        capacity = terminalsQueue.size();
        if (capacity < 1) {
            state = State.INITIALIZE_ERROR;
            return false;
        }
        for (StatefulCardTerminal terminal : terminalsQueue) {
            if (terminal.getLabel() != null && terminal.getInsertedCard() != null) continue;
            state = State.INITIALIZE_ERROR;
            return false;
        }
        return true;
    }

    private static boolean checkConnection(StatefulCardTerminal terminal) throws CardSystemException {
        int connectionAttempts = 0;
        boolean connectOK = false;
        while (!(connectOK = terminal.checkConnection()) && ++connectionAttempts < 3) {
            if (ui.askForRetryAfterFailedConnection(terminal.getLabel())) {
                if (ui.askForCardReplacement(terminal)) continue;
                throw new CardSystemException(I18n.getString("card.reinsertion.failed"));
            }
            return false;
        }
        return connectOK;
    }

    private static boolean checkCardID(String cardID) {
        return cardID != null;
    }

    static {
        CardServicesPool.initTerminals();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NON_INITIALIZED,
        INITIALIZED,
        READY,
        NO_TERMINALS,
        INITIALIZE_ERROR;

    }
}

