/*
 * Decompiled with CFR 0.152.
 */
package com.sun.bvt.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class Main {
    private static final long COLLECTOR_SLEEP_TIME = 200L;
    private static final long CHECKER_SLEEP_TIME = 100L;
    private static final long SLEEP_TIME = 2000L;
    private static final int STATE_ERROR = -1;
    private static final String PROC_NAME = "Binary Verification Tool";
    private static final String JAR_NAME = "bvt-launcher.jar";
    private static Descriptor descriptor;
    private static Collector collector;
    private static String cmdArgs;
    private static String jvmArgs;
    private static String tckHome;

    public static void main(String[] args) {
        Main.parseArgs(args);
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            javaHome = System.getenv("JAVA_HOME");
        }
        if (tckHome == null) {
            tckHome = System.getenv("TCK_HOME");
        }
        String classPath = System.getProperty("java.class.path");
        String[] elements = classPath.split(File.pathSeparator);
        String jarLocation = null;
        for (String element : elements) {
            int endIdx = element.indexOf(JAR_NAME);
            if (endIdx == -1) continue;
            jarLocation = endIdx == 0 ? "./" : element.substring(0, endIdx);
        }
        if (jarLocation == null) {
            jarLocation = tckHome + "/lib/";
        }
        String cmd = javaHome + "\\bin\\java " + jvmArgs + " -Xbootclasspath/p:" + jarLocation + "bvt-scio.jar " + " -Djavatest.security.noSecurityManager=true" + " -jar " + jarLocation + "javatest.jar " + cmdArgs;
        int status = Main.execute(PROC_NAME, cmd, null);
        System.exit(status);
    }

    private static void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if ("-testsuite".equals(args[i].toLowerCase())) {
                tckHome = args[i + 1];
            }
            if (args[i].startsWith("-D") || args[i].startsWith("-X")) {
                jvmArgs = jvmArgs + args[i] + " ";
                continue;
            }
            cmdArgs = cmdArgs + args[i] + " ";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int execute(String processName, String cmd, String[] env) {
        try {
            descriptor = new Descriptor(processName, cmd, env);
            if (!collector.isAlive()) {
                collector.start();
            }
        }
        finally {
            return Main.waitUntilDone(descriptor);
        }
    }

    private static int waitUntilDone(Descriptor current) {
        if (current == null || current.process == null) {
            return -1;
        }
        try {
            int status = current.close(false);
            Main.collector.finish();
            return status;
        }
        catch (RuntimeException ex) {
            return -1;
        }
    }

    private static String readAll(InputStream in) {
        int pos;
        if (in == null) {
            return "";
        }
        byte[] buff = new byte[]{};
        try {
            int length = in.available();
            if (length == 0) {
                return "";
            }
            buff = new byte[in.available()];
            int bytesRead = 0;
            for (pos = 0; (bytesRead = in.read(buff, pos, buff.length - pos)) > 0 && pos < buff.length; pos += bytesRead) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new String(buff, 0, pos);
    }

    private static void readBuffers(Descriptor item) {
        String data;
        String errData;
        if (item == null || !item.isActive) {
            return;
        }
        if (item.err != null && (errData = Main.readAll(item.err)) != null) {
            System.err.print(errData);
        }
        if (item.out != null && (data = Main.readAll(item.out)) != null) {
            System.out.print(data);
        }
    }

    static {
        collector = new Collector();
        cmdArgs = "";
        jvmArgs = "";
        tckHome = null;
    }

    private static class Descriptor {
        private boolean isActive = true;
        private String name;
        private Process process;
        private InputStream out;
        private InputStream err;
        private int state;

        public Descriptor(String name, String cmd, String[] env) {
            this.name = name;
            while (true) {
                try {
                    this.process = Runtime.getRuntime().exec(cmd, env, null);
                    this.err = this.process.getErrorStream();
                    this.out = this.process.getInputStream();
                    this.checkProcess(100L);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        Runtime run = Runtime.getRuntime();
                        run.gc();
                        run.runFinalization();
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        if (this.process != null) {
                            this.close(true);
                        }
                        this.state = -1;
                        return;
                    }
                }
            }
        }

        public void checkProcess(long waitTime) {
            ProcessChecker checker = new ProcessChecker(this.process);
            checker.start();
            try {
                Thread.sleep(waitTime);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            if (!checker.isInterrupted()) {
                checker.interrupt();
            }
            if (checker.isProcessAlive()) {
                checker = null;
                return;
            }
            String errMessage = Main.readAll(this.err);
            int exitCode = this.process.exitValue();
            this.process.destroy();
            checker = null;
            this.close(true);
            this.state = -1;
            System.err.println("Process ends with status '" + exitCode + "'.\nError message: " + errMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int close(boolean isDestroy) {
            if (!this.isActive) {
                return this.state;
            }
            try {
                this.state = isDestroy ? this.process.exitValue() : this.process.waitFor();
                int n = this.state;
                return n;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(this.name + "  have been interrupted");
            }
            catch (IllegalThreadStateException e) {
                int n = this.state = -1;
                return n;
            }
            finally {
                this.process.destroy();
                Descriptor descriptor = this;
                synchronized (descriptor) {
                    Main.readBuffers(this);
                    this.isActive = false;
                }
            }
        }

        private static class ProcessChecker
        extends Thread {
            Process process;
            boolean isProcessAlive = true;

            public ProcessChecker(Process process) {
                super("ProcessCheckerThread");
                this.process = process;
            }

            public void run() {
                try {
                    this.process.waitFor();
                    this.isProcessAlive = false;
                }
                catch (InterruptedException ex) {
                    return;
                }
            }

            public boolean isProcessAlive() {
                return this.isProcessAlive;
            }
        }
    }

    private static class Collector
    extends Thread {
        private boolean stopped = false;

        public Collector() {
            super("CollectorThread");
        }

        public void run() {
            try {
                while (!this.stopped) {
                    Main.readBuffers(descriptor);
                    Thread.sleep(200L);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }

        private void finish() {
            this.stopped = true;
        }
    }
}

