/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.exportfile.EfConstant;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfConstantUtf8;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class EfConstantClassRef
extends EfConstant {
    private int name_index;
    private String name;
    private EfConstantPool constant_pool;

    public EfConstantClassRef(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfConstantClassRef(EfConstantPool efConstantPool, String string) {
        this.constant_pool = efConstantPool;
        EfConstant[] efConstantArray = this.constant_pool.getConstants();
        this.name = string;
        int n = 0;
        while (n < efConstantArray.length) {
            EfConstantUtf8 efConstantUtf8;
            if (efConstantArray[n] instanceof EfConstantUtf8 && (efConstantUtf8 = (EfConstantUtf8)efConstantArray[n]).getUtf8String().equals(string)) {
                this.name_index = n;
                return;
            }
            ++n;
        }
        this.name_index = efConstantPool.addConstantUtf8(string);
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.name_index = dataInputStream.readUnsignedShort();
    }

    public void resolve() {
        this.name = this.constant_pool.getConstantUtf8(this.name_index).getUtf8String();
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        String string = stringBuffer.toString();
        printWriter.println(String.valueOf(string) + "Constant_Classref_info {");
        printWriter.println(String.valueOf(string) + "\ttag\t" + 7);
        printWriter.println(String.valueOf(string) + "\tname_index\t" + this.name_index + "\t\t// " + this.name);
        printWriter.println(String.valueOf(string) + "}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(7);
        dataOutputStream.writeShort(this.name_index);
    }

    public int getClassNameIndex() {
        return this.name_index;
    }

    public String getClassName() {
        return this.name;
    }
}

