/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.exportfile;

import com.sun.javacard.basicstructure.ClassDefinition;
import com.sun.javacard.exportfile.EfConstantPool;
import com.sun.javacard.exportfile.EfField;
import com.sun.javacard.exportfile.EfMethod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

public class EfClass
extends ClassDefinition {
    public static final short ACC_SHAREABLE = 2048;
    private int name_index;
    private int[] super_class_indexes;
    private String[] super_class_names;
    private int[] interface_indexes;
    private String[] interface_names;
    private EfField[] fields;
    private EfMethod[] methods;
    private EfConstantPool constant_pool;

    public EfClass(EfConstantPool efConstantPool) {
        this.constant_pool = efConstantPool;
    }

    public EfClass(ClassDefinition classDefinition, boolean bl, String[] stringArray, String[] stringArray2, EfConstantPool efConstantPool, EfField[] efFieldArray, EfMethod[] efMethodArray) {
        super(classDefinition);
        this.access_flags &= 0xFFFFFFDF;
        if (bl) {
            this.access_flags |= 0x800;
        }
        if (Modifier.isInterface(this.access_flags)) {
            this.access_flags |= 0x400;
        }
        this.constant_pool = efConstantPool;
        this.name_index = efConstantPool.addConstantClassRef(this.class_name);
        this.super_class_names = stringArray;
        this.super_class_indexes = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.super_class_indexes[n] = efConstantPool.addConstantClassRef(stringArray[n]);
            ++n;
        }
        this.interface_names = stringArray2;
        this.interface_indexes = new int[stringArray2.length];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            this.interface_indexes[n2] = efConstantPool.addConstantClassRef(stringArray2[n2]);
            ++n2;
        }
        this.fields = efFieldArray;
        this.methods = efMethodArray;
    }

    public void parse(DataInputStream dataInputStream) throws IOException {
        this.token = dataInputStream.readUnsignedByte();
        this.access_flags = dataInputStream.readShort();
        this.name_index = dataInputStream.readUnsignedShort();
        this.super_class_indexes = new int[dataInputStream.readUnsignedShort()];
        int n = 0;
        while (n < this.super_class_indexes.length) {
            this.super_class_indexes[n] = dataInputStream.readUnsignedShort();
            ++n;
        }
        this.interface_indexes = new int[dataInputStream.readUnsignedByte()];
        int n2 = 0;
        while (n2 < this.interface_indexes.length) {
            this.interface_indexes[n2] = dataInputStream.readUnsignedShort();
            ++n2;
        }
        this.fields = new EfField[dataInputStream.readUnsignedShort()];
        int n3 = 0;
        while (n3 < this.fields.length) {
            this.fields[n3] = new EfField(this.constant_pool);
            this.fields[n3].parse(dataInputStream);
            ++n3;
        }
        this.methods = new EfMethod[dataInputStream.readUnsignedShort()];
        int n4 = 0;
        while (n4 < this.methods.length) {
            this.methods[n4] = new EfMethod(this.constant_pool);
            this.methods[n4].parse(dataInputStream);
            ++n4;
        }
    }

    public void resolve() {
        this.class_name = this.constant_pool.getConstantClassRef(this.name_index).getClassName();
        this.super_class_names = new String[this.super_class_indexes.length];
        int n = 0;
        while (n < this.super_class_indexes.length) {
            this.super_class_names[n] = this.constant_pool.getConstantClassRef(this.super_class_indexes[n]).getClassName();
            ++n;
        }
        this.interface_names = new String[this.interface_indexes.length];
        int n2 = 0;
        while (n2 < this.interface_indexes.length) {
            this.interface_names[n2] = this.constant_pool.getConstantClassRef(this.interface_indexes[n2]).getClassName();
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.fields.length) {
            this.fields[n3].resolve();
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.methods.length) {
            this.methods[n4].resolve();
            ++n4;
        }
    }

    public void toText(PrintWriter printWriter, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        String string = stringBuffer.toString();
        printWriter.println(String.valueOf(string) + "class_info {" + "\t\t// " + this.class_name);
        printWriter.println(String.valueOf(string) + "\ttoken\t" + this.token);
        printWriter.print(String.valueOf(string) + "\taccess_flags\t" + Modifier.toString(this.access_flags));
        if ((this.access_flags & 0x800) != 0) {
            printWriter.println(" shareable");
        } else {
            printWriter.println();
        }
        printWriter.println(String.valueOf(string) + "\tname_index\t" + this.name_index + "\t\t// " + this.class_name);
        printWriter.println(String.valueOf(string) + "\texport_supers_count\t" + this.super_class_indexes.length);
        printWriter.println(String.valueOf(string) + "\texport_super_classes {");
        int n3 = 0;
        while (n3 < this.super_class_indexes.length) {
            printWriter.println(String.valueOf(string) + "\t\tconstant_pool_index\t" + this.super_class_indexes[n3] + "\t\t// " + this.super_class_names[n3]);
            ++n3;
        }
        printWriter.println(String.valueOf(string) + "\t}");
        printWriter.println(String.valueOf(string) + "\texport_interfaces_count\t" + this.interface_indexes.length);
        printWriter.println(String.valueOf(string) + "\texport_interfaces {");
        int n4 = 0;
        while (n4 < this.interface_indexes.length) {
            printWriter.println(String.valueOf(string) + "\t\tconstant_pool_index\t" + this.interface_indexes[n4] + "\t\t// " + this.interface_names[n4]);
            ++n4;
        }
        printWriter.println(String.valueOf(string) + "\t}");
        printWriter.println(String.valueOf(string) + "\texport_fields_count\t" + this.fields.length);
        printWriter.println(String.valueOf(string) + "\texport_fields {");
        int n5 = 0;
        while (n5 < this.fields.length) {
            this.fields[n5].toText(printWriter, n + 1);
            ++n5;
        }
        printWriter.println(String.valueOf(string) + "\t}");
        printWriter.println(String.valueOf(string) + "\texport_methods_count\t" + this.methods.length);
        printWriter.println(String.valueOf(string) + "\texport_methods {");
        int n6 = 0;
        while (n6 < this.methods.length) {
            this.methods[n6].toText(printWriter, n + 2);
            ++n6;
        }
        printWriter.println(String.valueOf(string) + "\t}");
        printWriter.println(String.valueOf(string) + "}");
    }

    public void toBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.token);
        dataOutputStream.writeShort(this.access_flags);
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.super_class_indexes.length);
        int n = 0;
        while (n < this.super_class_indexes.length) {
            dataOutputStream.writeShort(this.super_class_indexes[n]);
            ++n;
        }
        dataOutputStream.writeByte(this.interface_indexes.length);
        int n2 = 0;
        while (n2 < this.interface_indexes.length) {
            dataOutputStream.writeShort(this.interface_indexes[n2]);
            ++n2;
        }
        dataOutputStream.writeShort(this.fields.length);
        int n3 = 0;
        while (n3 < this.fields.length) {
            this.fields[n3].toBinary(dataOutputStream);
            ++n3;
        }
        dataOutputStream.writeShort(this.methods.length);
        int n4 = 0;
        while (n4 < this.methods.length) {
            this.methods[n4].toBinary(dataOutputStream);
            ++n4;
        }
        dataOutputStream.flush();
    }

    public int getNameIndex() {
        return this.name_index;
    }

    public int[] getSuperClasses() {
        return this.super_class_indexes;
    }

    public String[] getSuperClassNames() {
        return this.super_class_names;
    }

    public int[] getInterfaces() {
        return this.interface_indexes;
    }

    public String[] getInterfaceNames() {
        return this.interface_names;
    }

    public EfMethod getMethod(String string, String string2) {
        int n = 0;
        while (n < this.methods.length) {
            if (this.methods[n].getMethodName().equals(string) && this.methods[n].getMethodDescriptor().equals(string2)) {
                return this.methods[n];
            }
            ++n;
        }
        return null;
    }

    public EfMethod[] getMethods() {
        return this.methods;
    }

    public EfField getField(String string, String string2) {
        int n = 0;
        while (n < this.fields.length) {
            if (this.fields[n].getFieldName().equals(string) && this.fields[n].getFieldDescriptor().equals(string2)) {
                return this.fields[n];
            }
            ++n;
        }
        return null;
    }

    public EfField[] getFields() {
        return this.fields;
    }
}

