/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.optimizers;

import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class WideInstrOptimizer {
    JcPackage jc_package;

    public WideInstrOptimizer(JcPackage jcPackage) {
        this.jc_package = jcPackage;
    }

    public JcPackage optimize() {
        JcConstantPool jcConstantPool = this.jc_package.getConstantPool();
        jcConstantPool.order();
        JcClass[] jcClassArray = this.jc_package.getClasses();
        int n = 0;
        while (n < jcClassArray.length) {
            JcMethod[] jcMethodArray = jcClassArray[n].getMethods();
            int n2 = 0;
            while (n2 < jcMethodArray.length) {
                JcMethod jcMethod = jcMethodArray[n2];
                this.passOne(jcMethod);
                this.passTwo(jcMethod);
                ++n2;
            }
            ++n;
        }
        return this.jc_package;
    }

    private void passOne(JcMethod jcMethod) {
        JcInstruction jcInstruction = jcMethod.getCode();
        while (jcInstruction != null) {
            int n = jcInstruction.getOpcode();
            switch (n) {
                case 169: {
                    this.optimizeFieldInstr(jcInstruction, 131);
                    break;
                }
                case 170: {
                    this.optimizeFieldInstr(jcInstruction, 132);
                    break;
                }
                case 171: {
                    this.optimizeFieldInstr(jcInstruction, 133);
                    break;
                }
                case 172: {
                    this.optimizeFieldInstr(jcInstruction, 134);
                    break;
                }
                case 177: {
                    this.optimizeFieldInstr(jcInstruction, 135);
                    break;
                }
                case 178: {
                    this.optimizeFieldInstr(jcInstruction, 136);
                    break;
                }
                case 179: {
                    this.optimizeFieldInstr(jcInstruction, 137);
                    break;
                }
                case 180: {
                    this.optimizeFieldInstr(jcInstruction, 138);
                    break;
                }
                case 152: {
                    this.setBranchInstr(jcInstruction, 96);
                    break;
                }
                case 153: {
                    this.setBranchInstr(jcInstruction, 97);
                    break;
                }
                case 154: {
                    this.setBranchInstr(jcInstruction, 98);
                    break;
                }
                case 155: {
                    this.setBranchInstr(jcInstruction, 99);
                    break;
                }
                case 156: {
                    this.setBranchInstr(jcInstruction, 100);
                    break;
                }
                case 157: {
                    this.setBranchInstr(jcInstruction, 101);
                    break;
                }
                case 158: {
                    this.setBranchInstr(jcInstruction, 102);
                    break;
                }
                case 159: {
                    this.setBranchInstr(jcInstruction, 103);
                    break;
                }
                case 160: {
                    this.setBranchInstr(jcInstruction, 104);
                    break;
                }
                case 161: {
                    this.setBranchInstr(jcInstruction, 105);
                    break;
                }
                case 162: {
                    this.setBranchInstr(jcInstruction, 106);
                    break;
                }
                case 163: {
                    this.setBranchInstr(jcInstruction, 107);
                    break;
                }
                case 164: {
                    this.setBranchInstr(jcInstruction, 108);
                    break;
                }
                case 165: {
                    this.setBranchInstr(jcInstruction, 109);
                    break;
                }
                case 166: {
                    this.setBranchInstr(jcInstruction, 110);
                    break;
                }
                case 167: {
                    this.setBranchInstr(jcInstruction, 111);
                    break;
                }
                case 168: {
                    this.setBranchInstr(jcInstruction, 112);
                }
            }
            jcInstruction = jcInstruction.getNextInstr();
        }
    }

    private void optimizeFieldInstr(JcInstruction jcInstruction, int n) {
        JcInstrFieldRef jcInstrFieldRef = (JcInstrFieldRef)jcInstruction;
        JcConstantFieldRef jcConstantFieldRef = jcInstrFieldRef.getFieldRef();
        if ((jcConstantFieldRef.getIndex() & 0xFF00) == 0) {
            jcInstrFieldRef.setWideInstr(false);
            jcInstrFieldRef.setOpcode(n);
        }
    }

    private void setBranchInstr(JcInstruction jcInstruction, int n) {
        JcInstrBranch jcInstrBranch = (JcInstrBranch)jcInstruction;
        jcInstrBranch.setWideInstr(false);
        jcInstrBranch.setOpcode(n);
    }

    private void passTwo(JcMethod jcMethod) {
        JcInstruction jcInstruction = jcMethod.getCode();
        if (jcInstruction == null) {
            return;
        }
        boolean bl = true;
        while (bl) {
            JcInstruction jcInstruction2 = jcInstruction;
            bl = false;
            while (jcInstruction2 != null) {
                int n = jcInstruction2.getOpcode();
                switch (n) {
                    case 96: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 152, jcMethod);
                        break;
                    }
                    case 97: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 153, jcMethod);
                        break;
                    }
                    case 98: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 154, jcMethod);
                        break;
                    }
                    case 99: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 155, jcMethod);
                        break;
                    }
                    case 100: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 156, jcMethod);
                        break;
                    }
                    case 101: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 157, jcMethod);
                        break;
                    }
                    case 102: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 158, jcMethod);
                        break;
                    }
                    case 103: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 159, jcMethod);
                        break;
                    }
                    case 104: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 160, jcMethod);
                        break;
                    }
                    case 105: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 161, jcMethod);
                        break;
                    }
                    case 106: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 162, jcMethod);
                        break;
                    }
                    case 107: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 163, jcMethod);
                        break;
                    }
                    case 108: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 164, jcMethod);
                        break;
                    }
                    case 109: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 165, jcMethod);
                        break;
                    }
                    case 110: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 166, jcMethod);
                        break;
                    }
                    case 111: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 167, jcMethod);
                        break;
                    }
                    case 112: {
                        bl = this.optimizeBranchInstr(jcInstruction2, 168, jcMethod);
                    }
                }
                jcInstruction2 = jcInstruction2.getNextInstr();
            }
        }
    }

    private boolean optimizeBranchInstr(JcInstruction jcInstruction, int n, JcMethod jcMethod) {
        JcInstrBranch jcInstrBranch = (JcInstrBranch)jcInstruction;
        int n2 = jcInstrBranch.getBranchLabel();
        int n3 = this.computeOffset(jcInstruction, n2, jcMethod);
        if (DataType.getType(n3) != 1) {
            jcInstrBranch.setWideInstr(true);
            jcInstrBranch.setOpcode(n);
            return true;
        }
        return false;
    }

    private int computeOffset(JcInstruction jcInstruction, int n, JcMethod jcMethod) {
        JcInstruction jcInstruction2 = jcMethod.getCode();
        JcInstruction jcInstruction3 = null;
        while (jcInstruction2 != null) {
            if (jcInstruction2.getLabel() == n) {
                jcInstruction3 = jcInstruction2;
                break;
            }
            jcInstruction2 = jcInstruction2.getNextInstr();
        }
        if (jcInstruction3 == null) {
            throw new ConverterInternalError();
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        jcInstruction2 = jcMethod.getCode();
        while (jcInstruction2 != null) {
            if (jcInstruction2 == jcInstruction) {
                n2 = n4;
            }
            if (jcInstruction2 == jcInstruction3) {
                n3 = n4;
            }
            n4 += jcInstruction2.getSizeInBytes();
            jcInstruction2 = jcInstruction2.getNextInstr();
        }
        return n3 - n2;
    }
}

