/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.jcawriter;

import com.sun.javacard.basicstructure.MethodDefinition;
import com.sun.javacard.basicstructure.PackageDefinition;
import com.sun.javacard.converter.AppletProfile;
import com.sun.javacard.converter.ConversionProfile;
import com.sun.javacard.converter.ConverterException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.PackageProfile;
import com.sun.javacard.converter.jcawriter.Comment;
import com.sun.javacard.converter.util.DataType;
import com.sun.javacard.converter.util.MethodDescriptor;
import com.sun.javacard.converter.util.Names;
import com.sun.javacard.converter.util.Strings;
import com.sun.javacard.exportfile.ExportFileManager;
import com.sun.javacard.jcfile.JcAppletInfo;
import com.sun.javacard.jcfile.JcClass;
import com.sun.javacard.jcfile.JcException;
import com.sun.javacard.jcfile.JcField;
import com.sun.javacard.jcfile.JcImplementedInterfaceInfo;
import com.sun.javacard.jcfile.JcImportTokenTable;
import com.sun.javacard.jcfile.JcImportTokenTableEntry;
import com.sun.javacard.jcfile.JcMethod;
import com.sun.javacard.jcfile.JcMethodTable;
import com.sun.javacard.jcfile.JcPackage;
import com.sun.javacard.jcfile.constants.JcConstant;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantInstanceFieldRef;
import com.sun.javacard.jcfile.constants.JcConstantMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantSuperMethodRef;
import com.sun.javacard.jcfile.constants.JcConstantVirtualMethodRef;
import com.sun.javacard.jcfile.instructions.JcByteCode;
import com.sun.javacard.jcfile.instructions.JcInstrBranch;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrByteValue;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrFieldRef;
import com.sun.javacard.jcfile.instructions.JcInstrIncrement;
import com.sun.javacard.jcfile.instructions.JcInstrIntValue;
import com.sun.javacard.jcfile.instructions.JcInstrInterfaceRef;
import com.sun.javacard.jcfile.instructions.JcInstrLookupSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrMethodRef;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstrShortValue;
import com.sun.javacard.jcfile.instructions.JcInstrTableSwitch;
import com.sun.javacard.jcfile.instructions.JcInstrTypeClassRef;
import com.sun.javacard.jcfile.instructions.JcInstruction;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.util.Date;

public class JcaWriter {
    private JcPackage jc_package;
    private JcImportTokenTable token_table;
    private ExportFileManager export_file_manager;
    private PackageProfile package_profile;
    private AppletProfile[] applets_profile;
    private PrintWriter pw;

    public JcaWriter(JcPackage jcPackage, ConversionProfile conversionProfile, ExportFileManager exportFileManager) {
        this.jc_package = jcPackage;
        this.token_table = jcPackage.getImportTokenTable();
        this.package_profile = conversionProfile.package_profile;
        this.applets_profile = conversionProfile.applets_profile;
        this.export_file_manager = exportFileManager;
    }

    public void write(PrintWriter printWriter) {
        try {
            this.pw = printWriter;
            printWriter.println("// converted by version " + 1 + "." + 0);
            printWriter.println("// on " + new Date());
            printWriter.println();
            this.writePackage(0);
            return;
        }
        catch (ConverterException converterException) {
            return;
        }
    }

    private String getIndent(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        return stringBuffer.toString();
    }

    private void writePackage(int n) {
        String string = this.getIndent(n);
        this.pw.println(".package " + this.jc_package.getPackageName() + " {");
        byte[] byArray = this.package_profile.aid;
        this.pw.println("\t.aid " + Strings.toHexString(byArray, ":") + ";");
        this.pw.print(String.valueOf(string) + "\t.version " + Integer.toString(this.jc_package.getPackageMajorVersion()));
        this.pw.println("." + Integer.toString(this.jc_package.getPackageMinorVersion()) + ";");
        this.pw.println();
        this.writeImportPackages(n + 1);
        this.writeApplets(n + 1);
        this.writeConstantPool(n + 1);
        this.writeClasses(n + 1);
        this.pw.println("}");
        this.pw.flush();
    }

    private void writeImportPackages(int n) {
        PackageDefinition[] packageDefinitionArray = this.token_table.getImportPackageInfos();
        if (packageDefinitionArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(String.valueOf(string) + ".imports {");
        int n2 = 0;
        while (n2 < packageDefinitionArray.length) {
            String string2 = Strings.toHexString(packageDefinitionArray[n2].getAID(), ":");
            String string3 = String.valueOf(Integer.toString(packageDefinitionArray[n2].getPackageMajorVersion())) + "." + Integer.toString(packageDefinitionArray[n2].getPackageMinorVersion());
            this.pw.print(String.valueOf(string) + "\t" + string2 + " " + string3 + ";");
            this.pw.println("\t\t//" + packageDefinitionArray[n2].getPackageName());
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeApplets(int n) {
        JcAppletInfo[] jcAppletInfoArray = this.jc_package.getAppletInfos();
        if (jcAppletInfoArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(String.valueOf(string) + ".applet {");
        int n2 = 0;
        while (n2 < jcAppletInfoArray.length) {
            String string2 = Strings.toHexString(jcAppletInfoArray[n2].getAppletAID(), ":");
            String string3 = Names.getClassName(jcAppletInfoArray[n2].getInstallClass());
            this.pw.println(String.valueOf(string) + "\t" + string2 + " " + string3 + ";");
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeConstantPool(int n) {
        String string = this.getIndent(n);
        JcConstant[] jcConstantArray = this.jc_package.getConstantPool().getConstants();
        if (jcConstantArray.length == 0) {
            return;
        }
        this.pw.println(String.valueOf(string) + ".constantPool {");
        int n2 = 0;
        while (n2 < jcConstantArray.length) {
            String string2;
            String string3;
            JcConstant jcConstant;
            JcConstant jcConstant2 = jcConstantArray[n2];
            this.pw.println(String.valueOf(string) + "\t// " + n2);
            if (jcConstant2 instanceof JcConstantClassRef) {
                jcConstant = (JcConstantClassRef)jcConstant2;
                string3 = ((JcConstantClassRef)jcConstant).getClassName();
                this.pw.print(String.valueOf(string) + "\tclassRef " + this.getClassRep(string3) + ";");
                if (this.thisPackage(string3)) {
                    this.pw.println();
                } else {
                    this.pw.println(new String("\t\t// " + ((JcConstantClassRef)jcConstant).getClassName()));
                }
            } else if (jcConstant2 instanceof JcConstantMethodRef) {
                jcConstant = (JcConstantMethodRef)jcConstant2;
                string3 = jcConstant2 instanceof JcConstantVirtualMethodRef ? new String("virtualMethodRef ") : (jcConstant2 instanceof JcConstantSuperMethodRef ? new String("superMethodRef ") : new String("staticMethodRef "));
                string2 = this.getMethodRep(((JcConstantMethodRef)jcConstant).getClassName(), ((JcConstantMethodRef)jcConstant).getMethodName(), ((JcConstantMethodRef)jcConstant).getDescriptor());
                this.pw.print(String.valueOf(string) + "\t" + string3 + string2 + ";");
                if (this.thisPackage(((JcConstantMethodRef)jcConstant).getClassName())) {
                    this.pw.println();
                } else {
                    this.pw.println(Comment.getComment((JcConstantMethodRef)jcConstant));
                }
                this.writeMethodDescriptor(((JcConstantMethodRef)jcConstant).getDescriptor(), n + 2);
            } else if (jcConstant2 instanceof JcConstantFieldRef) {
                jcConstant = (JcConstantFieldRef)jcConstant2;
                string3 = jcConstant instanceof JcConstantInstanceFieldRef ? new String("instanceFieldRef ") : new String("staticFieldRef ");
                string2 = this.getFieldRep(((JcConstantFieldRef)jcConstant).getClassName(), ((JcConstantFieldRef)jcConstant).getFieldName(), ((JcConstantFieldRef)jcConstant).getDescriptor());
                String string4 = this.getFieldDescriptorString(((JcConstantFieldRef)jcConstant).getDescriptor());
                this.pw.print(String.valueOf(string) + "\t" + string3 + string4 + " " + string2 + ";");
                if (this.thisPackage(((JcConstantFieldRef)jcConstant).getClassName())) {
                    this.pw.println();
                } else {
                    this.pw.println(Comment.getComment((JcConstantFieldRef)jcConstant));
                }
            }
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeClasses(int n) {
        JcClass[] jcClassArray = this.jc_package.getClasses();
        if (jcClassArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < jcClassArray.length) {
            JcClass jcClass = jcClassArray[n2];
            if (jcClass.isInterfaceType()) {
                this.writeInterface(jcClass, n);
            } else {
                this.writeClass(jcClass, n);
            }
            ++n2;
        }
    }

    private void writeInterface(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        String string2 = Modifier.toString(jcClass.getAccessFlags() & 0xFFFFFDFF);
        String string3 = this.getClassTokenString(jcClass.getAccessFlags(), jcClass.getClassToken());
        this.pw.println(String.valueOf(string) + ".interface " + string2 + " " + Names.getClassName(jcClass.getClassName()) + string3 + " {");
        this.pw.println();
        if (jcClass.isShareableType()) {
            this.pw.println(String.valueOf(string) + "\t" + ".shareable;");
            this.pw.println();
        }
        this.writeSuperInterfaces(jcClass, n + 1);
        this.writeFields(jcClass, n + 1);
        this.writeMethods(jcClass, n + 1);
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeClass(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        String string2 = Modifier.toString(jcClass.getAccessFlags());
        String string3 = this.getClassTokenString(jcClass.getAccessFlags(), jcClass.getClassToken());
        this.pw.print(String.valueOf(string) + ".class " + string2 + " " + Names.getClassName(jcClass.getClassName()) + string3 + " ");
        String string4 = jcClass.getSuperClassName();
        if (string4 != null) {
            String string5 = this.getClassRep(string4);
            this.pw.print("extends " + string5 + " {");
            if (this.thisPackage(string4)) {
                this.pw.println();
            } else {
                String string6 = "extends " + string4;
                this.pw.println(new String("\t\t// " + string6));
            }
        } else {
            this.pw.println("{");
        }
        this.pw.println();
        if (jcClass.isShareableType()) {
            this.pw.println(String.valueOf(string) + "\t" + ".shareable;");
            this.pw.println();
        }
        this.writeFields(jcClass, n + 1);
        this.writeMethodTables(jcClass, n + 1);
        this.writeImplementedInterfaceInfos(jcClass, n + 1);
        this.writeMethods(jcClass, n + 1);
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeSuperInterfaces(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        String[] stringArray = jcClass.getSuperInterfaces();
        if (stringArray.length == 0) {
            return;
        }
        this.pw.println(String.valueOf(string) + ".superInterfaces {");
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            String string3 = this.getClassRep(string2);
            this.pw.print(String.valueOf(string) + "\t" + string3 + ";");
            if (this.thisPackage(string2)) {
                this.pw.println();
            } else {
                this.pw.println(new String("\t\t// " + string2));
            }
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeImplementedInterfaceInfos(JcClass jcClass, int n) {
        JcImplementedInterfaceInfo[] jcImplementedInterfaceInfoArray = jcClass.getImplementedInterfaceInfos();
        if (jcImplementedInterfaceInfoArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(String.valueOf(string) + ".implementedInterfaceInfoTable { ");
        int n2 = 0;
        while (n2 < jcImplementedInterfaceInfoArray.length) {
            MethodDefinition[] methodDefinitionArray;
            JcImplementedInterfaceInfo jcImplementedInterfaceInfo = jcImplementedInterfaceInfoArray[n2];
            String string2 = this.getClassRep(jcImplementedInterfaceInfo.getInterfaceName());
            this.pw.print(String.valueOf(string) + "\t" + ".interface " + string2 + " { ");
            if (this.thisPackage(jcImplementedInterfaceInfo.getInterfaceName())) {
                this.pw.println();
            } else {
                methodDefinitionArray = jcImplementedInterfaceInfo.getInterfaceName();
                this.pw.println(new String("\t\t// " + (String)methodDefinitionArray));
            }
            methodDefinitionArray = jcImplementedInterfaceInfo.getInterfaceMethods();
            int[] nArray = jcImplementedInterfaceInfo.getMethodTableIndexes();
            int n3 = 0;
            while (n3 < methodDefinitionArray.length) {
                this.pw.print(String.valueOf(string) + "\t\t" + nArray[n3] + ";");
                this.pw.println(Comment.getComment(methodDefinitionArray[n3]));
                ++n3;
            }
            this.pw.println(String.valueOf(string) + "\t" + "}");
            this.pw.println();
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
    }

    private void writeFields(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        JcField[] jcFieldArray = jcClass.getFields();
        if (jcFieldArray.length == 0) {
            return;
        }
        this.pw.println(String.valueOf(string) + ".fields {");
        int n2 = 0;
        while (n2 < jcFieldArray.length) {
            JcField jcField = jcFieldArray[n2];
            int n3 = jcField.getAccessFlags();
            String string2 = Modifier.toString(n3);
            String string3 = this.getFieldTokenString(n3, jcField.getFieldDescriptor(), jcField.getFieldToken());
            String string4 = this.getFieldDescriptorString(jcField.getFieldDescriptor());
            this.pw.print(String.valueOf(string) + "\t" + string2 + " " + string4 + " " + jcField.getFieldName() + string3);
            int[] nArray = jcField.getValue();
            if (nArray != null) {
                if (nArray.length == 0) {
                    this.pw.print(" = ");
                } else {
                    this.pw.print(" = " + nArray[0]);
                    int n4 = 1;
                    while (n4 < nArray.length) {
                        this.pw.print(":" + nArray[n4]);
                        ++n4;
                    }
                }
            }
            this.pw.println(";\t\t// " + jcField.getFieldDescriptor());
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeMethodTables(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        JcMethodTable jcMethodTable = jcClass.getPublicMethodTable();
        MethodDefinition[] methodDefinitionArray = jcMethodTable.getMethods();
        int n2 = jcMethodTable.getMethodTableBase();
        this.pw.println(String.valueOf(string) + ".publicMethodTable " + Integer.toString(n2) + " {");
        int n3 = 0;
        while (n3 < methodDefinitionArray.length) {
            this.pw.println(String.valueOf(string) + "\t" + methodDefinitionArray[n3].getMethodName() + methodDefinitionArray[n3].getMethodDescriptor() + ";");
            ++n3;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        JcMethodTable jcMethodTable2 = jcClass.getPackageMethodTable();
        MethodDefinition[] methodDefinitionArray2 = jcMethodTable2.getMethods();
        int n4 = jcMethodTable2.getMethodTableBase();
        this.pw.println(String.valueOf(string) + ".packageMethodTable " + Integer.toString(n4) + " {");
        int n5 = 0;
        while (n5 < methodDefinitionArray2.length) {
            this.pw.println(String.valueOf(string) + "\t" + methodDefinitionArray2[n5].getMethodName() + methodDefinitionArray2[n5].getMethodDescriptor() + ";");
            ++n5;
        }
        this.pw.println(String.valueOf(string) + "}");
        this.pw.println();
        this.pw.flush();
    }

    private void writeMethods(JcClass jcClass, int n) {
        String string = this.getIndent(n);
        JcMethod[] jcMethodArray = jcClass.getMethods();
        if (jcMethodArray.length == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < jcMethodArray.length) {
            JcMethod jcMethod = jcMethodArray[n2];
            int n3 = jcMethod.getAccessFlags();
            String string2 = Modifier.toString(n3);
            String string3 = this.getMethodTokenString(jcMethod.getMethodName(), jcMethod.getAccessFlags(), jcMethod.getMethodToken());
            this.pw.println(String.valueOf(string) + ".method " + string2 + " " + jcMethod.getMethodName() + jcMethod.getMethodDescriptor() + string3 + " {");
            if (!Modifier.isNative(n3) && !Modifier.isAbstract(n3)) {
                this.pw.println(String.valueOf(string) + "\t.stack " + Integer.toString(jcMethod.getMaxStack()) + ";");
                this.pw.println(String.valueOf(string) + "\t.locals " + Integer.toString(jcMethod.getMaxLocals()) + ";");
                this.pw.println();
                this.writeMethodDescriptor(jcMethod.getMethodDescriptor(), n + 1);
                this.writeInstructions(jcMethod, n + 1);
                this.writeExceptionTable(jcMethod, n + 1);
            }
            this.pw.println(String.valueOf(string) + "}");
            this.pw.println();
            ++n2;
        }
        this.pw.flush();
    }

    private void writeMethodDescriptor(String string, int n) {
        String string2;
        String[] stringArray = MethodDescriptor.getParamDescriptors(string);
        int n2 = 0;
        String[] stringArray2 = new String[stringArray.length + 1];
        int n3 = 0;
        while (n3 < stringArray.length) {
            string2 = Names.getClassNameFromDescriptor(stringArray[n3]);
            if (string2 != null && !this.thisPackage(string2)) {
                stringArray2[n2++] = string2;
            }
            ++n3;
        }
        string2 = MethodDescriptor.getReturnDescriptor(string);
        String string3 = Names.getClassNameFromDescriptor(string2);
        if (string3 != null && !this.thisPackage(string3)) {
            stringArray2[n2++] = string3;
        }
        if (n2 == 0) {
            return;
        }
        String string4 = this.getIndent(n);
        int n4 = 0;
        while (n4 < n2) {
            JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getClassEntry(stringArray2[n4]);
            this.pw.println(String.valueOf(string4) + ".descriptor\t" + "L" + stringArray2[n4] + ";" + "\t" + jcImportTokenTableEntry.getTokenString() + ";");
            ++n4;
        }
        this.pw.println();
    }

    private void writeInstructions(JcMethod jcMethod, int n) {
        String string = this.getIndent(n);
        JcInstruction jcInstruction = jcMethod.getCode();
        while (jcInstruction != null) {
            int n2;
            int n3;
            Object object;
            Object object2;
            String string2 = jcInstruction.getLabel() == -1 ? new String("\t\t") : new String("\tL" + jcInstruction.getLabel() + ":" + "\t");
            String string3 = JcByteCode.getMnemonic(jcInstruction.getOpcode());
            String string4 = String.valueOf(string) + string2 + string3 + " ";
            if (jcInstruction instanceof JcInstrNoOperands) {
                this.pw.println(String.valueOf(string) + string2 + string3 + ";");
            } else if (jcInstruction instanceof JcInstrBranch) {
                this.pw.println(String.valueOf(string4) + "L" + ((JcInstrBranch)jcInstruction).getBranchLabel() + ";");
            } else if (jcInstruction instanceof JcInstrByteIndex) {
                this.pw.println(String.valueOf(string4) + ((JcInstrByteIndex)jcInstruction).getIndex() + ";");
            } else if (jcInstruction instanceof JcInstrByteValue) {
                this.pw.println(String.valueOf(string4) + ((JcInstrByteValue)jcInstruction).getValue() + ";");
            } else if (jcInstruction instanceof JcInstrInterfaceRef) {
                object2 = (JcInstrInterfaceRef)jcInstruction;
                object = ((JcInstrClassRef)object2).getClassRef();
                n3 = ((JcInstrInterfaceRef)object2).getNargs();
                n2 = ((JcInstrInterfaceRef)object2).getMethodToken();
                this.pw.println(String.valueOf(string4) + n3 + " " + ((JcConstant)object).getIndex() + " " + n2 + ";" + new String("\t\t// " + ((JcConstantClassRef)object).getClassName()));
            } else if (jcInstruction instanceof JcInstrTypeClassRef) {
                object2 = (JcInstrTypeClassRef)jcInstruction;
                object = ((JcInstrClassRef)object2).getClassRef();
                if (object == null) {
                    this.pw.println(String.valueOf(string4) + ((JcInstrTypeClassRef)object2).getAtype() + " " + 0 + ";" + Comment.getComment(((JcInstrTypeClassRef)object2).getAtype(), (JcConstantClassRef)object));
                } else {
                    this.pw.println(String.valueOf(string4) + ((JcInstrTypeClassRef)object2).getAtype() + " " + ((JcConstant)object).getIndex() + ";" + Comment.getComment(((JcInstrTypeClassRef)object2).getAtype(), (JcConstantClassRef)object));
                }
            } else if (jcInstruction instanceof JcInstrClassRef) {
                object2 = ((JcInstrClassRef)jcInstruction).getClassRef();
                this.pw.println(String.valueOf(string4) + ((JcConstant)object2).getIndex() + ";" + new String("\t\t// " + ((JcConstantClassRef)object2).getClassName()));
            } else if (jcInstruction instanceof JcInstrFieldRef) {
                object2 = ((JcInstrFieldRef)jcInstruction).getFieldRef();
                this.pw.println(String.valueOf(string4) + ((JcConstant)object2).getIndex() + ";" + Comment.getComment((JcConstantFieldRef)object2));
            } else if (jcInstruction instanceof JcInstrIntValue) {
                this.pw.println(String.valueOf(string4) + ((JcInstrIntValue)jcInstruction).getValue() + ";");
            } else if (jcInstruction instanceof JcInstrLookupSwitch) {
                object2 = (JcInstrLookupSwitch)jcInstruction;
                object = ((JcInstrLookupSwitch)object2).getMatchValues();
                int[] nArray = ((JcInstrLookupSwitch)object2).getMatchLabels();
                this.pw.print(String.valueOf(string4) + "L" + ((JcInstrLookupSwitch)object2).getDefaultLabel() + " " + ((JcInstrLookupSwitch)object2).getNumMatchPairs());
                n2 = 0;
                while (n2 < ((Object)object).length) {
                    this.pw.print(" " + (int)object[n2] + " " + "L" + nArray[n2]);
                    ++n2;
                }
                this.pw.println(";");
            } else if (jcInstruction instanceof JcInstrMethodRef) {
                object2 = (JcInstrMethodRef)jcInstruction;
                object = ((JcInstrMethodRef)object2).getMethodRef();
                this.pw.println(String.valueOf(string4) + ((JcConstant)object).getIndex() + ";" + Comment.getComment((JcConstantMethodRef)object));
            } else if (jcInstruction instanceof JcInstrShortValue) {
                this.pw.println(String.valueOf(string4) + ((JcInstrShortValue)jcInstruction).getValue() + ";");
            } else if (jcInstruction instanceof JcInstrTableSwitch) {
                object2 = (JcInstrTableSwitch)jcInstruction;
                this.pw.print(String.valueOf(string4) + "L" + ((JcInstrTableSwitch)object2).getDefaultLabel() + " ");
                this.pw.print(String.valueOf(((JcInstrTableSwitch)object2).getLowValue()) + " " + ((JcInstrTableSwitch)object2).getHighValue());
                object = ((JcInstrTableSwitch)object2).getBranchLabels();
                n3 = 0;
                while (n3 < ((Object)object).length) {
                    this.pw.print(" L" + (int)object[n3]);
                    ++n3;
                }
                this.pw.println(";");
            } else if (jcInstruction instanceof JcInstrIncrement) {
                object2 = (JcInstrIncrement)jcInstruction;
                this.pw.println(String.valueOf(string4) + ((JcInstrIncrement)object2).getIndex() + " " + ((JcInstrIncrement)object2).getConstant() + ";");
            } else {
                throw new ConverterInternalError();
            }
            jcInstruction = jcInstruction.getNextInstr();
        }
    }

    private void writeExceptionTable(JcMethod jcMethod, int n) {
        JcException[] jcExceptionArray = jcMethod.getExceptions();
        if (jcExceptionArray.length == 0) {
            return;
        }
        String string = this.getIndent(n);
        this.pw.println(String.valueOf(string) + ".exceptionTable {");
        this.pw.println(String.valueOf(string) + "\t// start_block end_block handler_block catch_type_index");
        int n2 = 0;
        while (n2 < jcExceptionArray.length) {
            int n3 = jcExceptionArray[n2].getStartBlock();
            int n4 = jcExceptionArray[n2].getEndBlock();
            int n5 = jcExceptionArray[n2].getHandlerBlock();
            int n6 = jcExceptionArray[n2].getCatchTypeClassRef().getIndex();
            this.pw.println(String.valueOf(string) + "\t" + "L" + n3 + " L" + n4 + " L" + n5 + " " + n6 + ";");
            ++n2;
        }
        this.pw.println(String.valueOf(string) + "}");
    }

    private String getClassRep(String string) {
        if (this.thisPackage(string)) {
            return Names.getClassName(string);
        }
        this.export_file_manager.getClass(string);
        JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getClassEntry(string);
        if (jcImportTokenTableEntry == null) {
            throw new ConverterInternalError();
        }
        return jcImportTokenTableEntry.getTokenString();
    }

    private String getMethodRep(String string, String string2, String string3) {
        if (this.thisPackage(string)) {
            return new String(String.valueOf(Names.getClassName(string)) + "/" + string2 + string3);
        }
        JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getMethodEntry(string, string2, string3);
        if (jcImportTokenTableEntry == null) {
            throw new ConverterInternalError();
        }
        return String.valueOf(jcImportTokenTableEntry.getTokenString()) + string3;
    }

    private String getFieldRep(String string, String string2, String string3) {
        if (this.thisPackage(string)) {
            return new String(String.valueOf(Names.getClassName(string)) + "/" + string2);
        }
        JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getFieldEntry(string, string2);
        if (jcImportTokenTableEntry == null) {
            throw new ConverterInternalError();
        }
        return jcImportTokenTableEntry.getTokenString();
    }

    private String getClassTokenString(int n, int n2) {
        if (Modifier.isPublic(n)) {
            return new String(" " + Integer.toString(n2));
        }
        return new String("");
    }

    private String getFieldTokenString(int n, String string, int n2) {
        if (Modifier.isStatic(n)) {
            if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                if (Modifier.isFinal(n)) {
                    if (string.startsWith("[")) {
                        return new String(" " + Integer.toString(n2));
                    }
                    return new String("");
                }
                return new String(" " + Integer.toString(n2));
            }
            return new String("");
        }
        return new String(" " + Integer.toString(n2));
    }

    private String getMethodTokenString(String string, int n, int n2) {
        if (string.equals("<init>")) {
            if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                return new String(" " + Integer.toString(n2));
            }
            return new String("");
        }
        if (Modifier.isStatic(n)) {
            if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
                return new String(" " + Integer.toString(n2));
            }
            return new String("");
        }
        if (Modifier.isPrivate(n)) {
            return new String("");
        }
        return new String(" " + Integer.toString(n2));
    }

    private boolean thisPackage(String string) {
        String string2 = Names.getPackageName(string);
        return this.jc_package.getPackageName().equals(string2);
    }

    private String getFieldDescriptorString(String string) {
        int n = DataType.getType(string);
        switch (n) {
            case 1: {
                if (DataType.isBooleanType(string)) {
                    return "boolean";
                }
                return "byte";
            }
            case 2: {
                return "short";
            }
            case 3: {
                return "int";
            }
            case 10: {
                String string2;
                String string3;
                if (string.equals("[B")) {
                    return "byte[]";
                }
                if (string.equals("[Z")) {
                    return "boolean[]";
                }
                if (string.equals("[S")) {
                    return "short[]";
                }
                if (string.equals("[I")) {
                    return "int[]";
                }
                boolean bl = false;
                if (string.startsWith("[")) {
                    bl = true;
                    string = string.substring(1);
                }
                if (this.thisPackage(string3 = string.substring(1, string.length() - 1))) {
                    string2 = Names.getClassName(string3);
                } else {
                    JcImportTokenTableEntry jcImportTokenTableEntry = this.token_table.getClassEntry(string3);
                    if (jcImportTokenTableEntry == null) {
                        throw new ConverterInternalError();
                    }
                    string2 = jcImportTokenTableEntry.getTokenString();
                }
                if (bl) {
                    return String.valueOf(string2) + "[]";
                }
                return string2;
            }
        }
        throw new ConverterInternalError();
    }
}

