/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.BCConversionTable;
import com.sun.javacard.converter.converters.InstrArithmeticConverter;
import com.sun.javacard.converter.converters.InstrArrayConverter;
import com.sun.javacard.converter.converters.InstrBranchConverter;
import com.sun.javacard.converter.converters.InstrClassRefConverter;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstrExceptionConverter;
import com.sun.javacard.converter.converters.InstrFieldRefConverter;
import com.sun.javacard.converter.converters.InstrIncrementConverter;
import com.sun.javacard.converter.converters.InstrLoadConstConverter;
import com.sun.javacard.converter.converters.InstrLoadConverter;
import com.sun.javacard.converter.converters.InstrMethodRefConverter;
import com.sun.javacard.converter.converters.InstrReturnConverter;
import com.sun.javacard.converter.converters.InstrStackConverter;
import com.sun.javacard.converter.converters.InstrStoreConverter;
import com.sun.javacard.converter.converters.InstrSwitchConverter;
import com.sun.javacard.converter.converters.InstrTypeConversionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.jcfile.instructions.JcInstruction;

abstract class InstructionConverter {
    protected JInstruction java_instr;
    protected JcInstruction jc_instr;
    protected OperandStack operand_stack;
    protected MethodConverter method_converter;
    protected InstrContainer instr_container;

    public InstructionConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        this.instr_container = instrContainer;
        this.java_instr = instrContainer.getJInstr();
        this.operand_stack = instrContainer.getOperandStack();
        this.method_converter = methodConverter;
    }

    public abstract JcInstruction convert();

    public static final InstructionConverter create(InstrContainer instrContainer, MethodConverter methodConverter) {
        int n = instrContainer.getJInstr().getOpcode();
        int n2 = BCConversionTable.bc_details[n].getConverterType();
        switch (n2) {
            case 0: {
                return new InstrArithmeticConverter(instrContainer, methodConverter);
            }
            case 1: {
                return new InstrArrayConverter(instrContainer, methodConverter);
            }
            case 2: {
                return new InstrClassRefConverter(instrContainer, methodConverter);
            }
            case 3: {
                return new InstrMethodRefConverter(instrContainer, methodConverter);
            }
            case 4: {
                return new InstrFieldRefConverter(instrContainer, methodConverter);
            }
            case 5: {
                return new InstrLoadConstConverter(instrContainer, methodConverter);
            }
            case 6: {
                return new InstrLoadConverter(instrContainer, methodConverter);
            }
            case 7: {
                return new InstrStoreConverter(instrContainer, methodConverter);
            }
            case 8: {
                return new InstrBranchConverter(instrContainer, methodConverter);
            }
            case 9: {
                return new InstrIncrementConverter(instrContainer, methodConverter);
            }
            case 10: {
                return new InstrReturnConverter(instrContainer, methodConverter);
            }
            case 11: {
                return new InstrStackConverter(instrContainer, methodConverter);
            }
            case 12: {
                return new InstrSwitchConverter(instrContainer, methodConverter);
            }
            case 13: {
                return new InstrTypeConversionConverter(instrContainer, methodConverter);
            }
            case 14: {
                return new InstrExceptionConverter(instrContainer, methodConverter);
            }
        }
        throw new ConverterInternalError();
    }
}

