/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.JcLocalVariable;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrLoadConverter
extends InstructionConverter {
    public InstrLoadConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    public JcInstruction convert() {
        int n;
        int n2 = this.java_instr.getOpcode();
        switch (n2) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n = n2 - 26;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                n = n2 - 42;
                break;
            }
            case 21: {
                n = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            case 25: {
                n = ((JInstrByteIndex)this.java_instr).getIndex();
                break;
            }
            default: {
                throw new ConverterInternalError();
            }
        }
        JcLocalVariable jcLocalVariable = this.method_converter.getLocalVariableConverter().getJcLocalVariable(n, this.java_instr);
        if (jcLocalVariable == null) {
            throw new ConverterInternalError();
        }
        this.jc_instr = this.createLoadInstruction(jcLocalVariable);
        int n3 = jcLocalVariable.getType();
        this.operand_stack.push(n3, this.instr_container);
        return this.jc_instr;
    }

    private JcInstruction createLoadInstruction(JcLocalVariable jcLocalVariable) {
        int n = jcLocalVariable.getType();
        int n2 = jcLocalVariable.getJcIndex();
        switch (n) {
            case 1: 
            case 2: {
                if (n2 < 4) {
                    return new JcInstrNoOperands(28 + n2);
                }
                return new JcInstrByteIndex(22, n2);
            }
            case 3: {
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", this.method_converter.getClassName().replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", this.method_converter.getClassName().replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (n2 < 4) {
                    return new JcInstrNoOperands(32 + n2);
                }
                return new JcInstrByteIndex(23, n2);
            }
            case 10: {
                if (n2 < 4) {
                    return new JcInstrNoOperands(24 + n2);
                }
                return new JcInstrByteIndex(21, n2);
            }
        }
        throw new ConverterInternalError();
    }
}

