/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstruction;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.OperandStack;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.jcfile.instructions.JcInstruction;

public class InstrContainer {
    private int forced_type;
    private OperandStack parent_operand_stack;
    private OperandStack working_operand_stack;
    private JInstruction j_instr;
    private JcInstruction jc_instr;
    private InstrContainer prev_instr_container;
    private InstrContainer next_instr_container;
    private InstrContainer[] out_instr_containers;
    private boolean label_flag;
    private int label = -1;
    private boolean catch_finally_block_leader;
    private boolean changed_flag = false;

    public InstrContainer(JInstruction jInstruction) {
        this.j_instr = jInstruction;
        this.out_instr_containers = new InstrContainer[0];
    }

    public JInstruction getJInstr() {
        return this.j_instr;
    }

    public void setJInstr(JInstruction jInstruction) {
        this.j_instr = jInstruction;
    }

    public JcInstruction getJcInstr() {
        return this.jc_instr;
    }

    public void setJcInstr(JcInstruction jcInstruction) {
        this.jc_instr = jcInstruction;
    }

    public InstrContainer getPrevInstrContainer() {
        return this.prev_instr_container;
    }

    public void setPrevInstrContainer(InstrContainer instrContainer) {
        this.prev_instr_container = instrContainer;
    }

    public InstrContainer getNextInstrContainer() {
        return this.next_instr_container;
    }

    public void setNextInstrContainer(InstrContainer instrContainer) {
        this.next_instr_container = instrContainer;
    }

    public InstrContainer[] getOutInstrContainers() {
        return this.out_instr_containers;
    }

    public void link(InstrContainer instrContainer) {
        int n = this.out_instr_containers.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.out_instr_containers[n2].getJInstr().getPC() == instrContainer.getJInstr().getPC()) {
                return;
            }
            ++n2;
        }
        InstrContainer[] instrContainerArray = new InstrContainer[n + 1];
        System.arraycopy(this.out_instr_containers, 0, instrContainerArray, 0, n);
        instrContainerArray[n] = instrContainer;
        this.out_instr_containers = instrContainerArray;
    }

    public OperandStack getOperandStack() {
        return this.working_operand_stack;
    }

    public void setOperandStack(OperandStack operandStack) {
        if (this.parent_operand_stack == null) {
            this.parent_operand_stack = operandStack;
            this.changed_flag = true;
        } else {
            this.merge(operandStack);
        }
        this.working_operand_stack = (OperandStack)this.parent_operand_stack.clone();
    }

    public int getForcedType() {
        return this.forced_type;
    }

    public void setForcedType(int n) {
        this.forced_type = n;
    }

    public int getLabel() {
        return this.label;
    }

    public void setLabel(int n) {
        this.label = n;
    }

    public boolean hasLabel() {
        return this.label_flag;
    }

    public void setLabelFlag(boolean bl) {
        this.label_flag = bl;
    }

    public boolean isCatchFinallyBlockLeader() {
        return this.catch_finally_block_leader;
    }

    public void setCatchFinallyBlockLeader(boolean bl) {
        this.catch_finally_block_leader = bl;
    }

    public void setChangedFlag(boolean bl) {
        this.changed_flag = bl;
    }

    public boolean hasChanged() {
        return this.changed_flag;
    }

    private void merge(OperandStack operandStack) {
        OperandStackEntry[] operandStackEntryArray;
        OperandStackEntry[] operandStackEntryArray2 = this.parent_operand_stack.getStackEntries();
        if (operandStackEntryArray2.length != (operandStackEntryArray = operandStack.getStackEntries()).length) {
            throw new ConverterInternalError();
        }
        int n = operandStackEntryArray2.length - 1;
        while (n >= 0) {
            if (operandStackEntryArray2[n].getType() != operandStackEntryArray[n].getType()) {
                if (operandStackEntryArray2[n].getType() == 3) {
                    operandStackEntryArray[n].rollBack();
                }
                if (operandStackEntryArray[n].getType() == 3) {
                    this.parent_operand_stack = operandStack;
                    this.changed_flag = true;
                    operandStackEntryArray2[n].rollBack();
                }
                if (operandStackEntryArray2[n].getType() == 10) {
                    throw new ConverterInternalError();
                }
                if (operandStackEntryArray[n].getType() == 10) {
                    throw new ConverterInternalError();
                }
            }
            --n;
        }
    }

    public void reset() {
        this.working_operand_stack = (OperandStack)this.parent_operand_stack.clone();
        this.jc_instr = null;
    }

    public InstrContainer findRetInstrContainer() {
        if (this.j_instr.getOpcode() == 169) {
            return this;
        }
        int n = 0;
        while (n < this.out_instr_containers.length) {
            InstrContainer instrContainer = this.out_instr_containers[n].findRetInstrContainer();
            if (instrContainer != null) {
                return instrContainer;
            }
            ++n;
        }
        return null;
    }
}

