/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.converter.converters;

import com.sun.javacard.classfile.instructions.JInstrByteIndex;
import com.sun.javacard.classfile.instructions.JInstrClassRef;
import com.sun.javacard.converter.ConversionException;
import com.sun.javacard.converter.ConverterInternalError;
import com.sun.javacard.converter.converters.InstrContainer;
import com.sun.javacard.converter.converters.InstructionConverter;
import com.sun.javacard.converter.converters.MethodConverter;
import com.sun.javacard.converter.converters.OperandStackEntry;
import com.sun.javacard.converter.util.Notifier;
import com.sun.javacard.jcfile.constants.JcConstantClassRef;
import com.sun.javacard.jcfile.constants.JcConstantPool;
import com.sun.javacard.jcfile.instructions.JcInstrByteIndex;
import com.sun.javacard.jcfile.instructions.JcInstrClassRef;
import com.sun.javacard.jcfile.instructions.JcInstrNoOperands;
import com.sun.javacard.jcfile.instructions.JcInstruction;

class InstrArrayConverter
extends InstructionConverter {
    public InstrArrayConverter(InstrContainer instrContainer, MethodConverter methodConverter) {
        super(instrContainer, methodConverter);
    }

    public JcInstruction convert() {
        int n = this.java_instr.getOpcode();
        switch (n) {
            case 188: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                int n2 = ((JInstrByteIndex)this.java_instr).getIndex();
                if (n2 == 10) {
                    String string = this.method_converter.getClassName();
                    if (this.method_converter.getPackageConverter().isIntSupported()) {
                        Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.4", string.replace('/', '.'));
                        this.method_converter.getPackageConverter().setIntFlag(true);
                    } else {
                        Notifier.error(this.java_instr.getSourceLineNumber(), "int.4", string.replace('/', '.'));
                        throw new ConversionException();
                    }
                }
                int n3 = this.getAtype(n2);
                this.jc_instr = new JcInstrByteIndex(144, n3);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 189: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                String string = ((JInstrClassRef)this.java_instr).getClassName();
                JcConstantPool jcConstantPool = this.method_converter.getJcConstantPool();
                JcConstantClassRef jcConstantClassRef = jcConstantPool.addConstantClassRef(string);
                this.jc_instr = new JcInstrClassRef(145, jcConstantClassRef);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 51: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(37);
                this.operand_stack.push(1, this.instr_container);
                return this.jc_instr;
            }
            case 53: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(38);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
            case 50: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(36);
                this.operand_stack.push(10, this.instr_container);
                return this.jc_instr;
            }
            case 46: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                String string = this.method_converter.getClassName();
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", string.replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", string.replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                this.jc_instr = new JcInstrNoOperands(39);
                this.operand_stack.push(3, this.instr_container);
                return this.jc_instr;
            }
            case 84: {
                this.operand_stack.pop();
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(56);
                return this.jc_instr;
            }
            case 86: {
                this.operand_stack.pop();
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(57);
                return this.jc_instr;
            }
            case 83: {
                this.operand_stack.pop();
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry);
                this.jc_instr = new JcInstrNoOperands(55);
                return this.jc_instr;
            }
            case 79: {
                OperandStackEntry operandStackEntry = this.operand_stack.pop();
                OperandStackEntry operandStackEntry2 = this.operand_stack.pop();
                this.operand_stack.pop();
                this.checkArrayCountOrIndexType(operandStackEntry2);
                String string = this.method_converter.getClassName();
                if (!this.method_converter.isIntSupported()) {
                    Notifier.error(this.java_instr.getSourceLineNumber(), "int.5", string.replace('/', '.'));
                    throw new ConversionException();
                }
                Notifier.warning(this.java_instr.getSourceLineNumber(), "warning.5", string.replace('/', '.'));
                this.method_converter.getPackageConverter().setIntFlag(true);
                if (operandStackEntry.getType() != 3) {
                    operandStackEntry.rollBack();
                }
                this.jc_instr = new JcInstrNoOperands(58);
                return this.jc_instr;
            }
            case 190: {
                this.operand_stack.pop();
                this.jc_instr = new JcInstrNoOperands(146);
                this.operand_stack.push(2, this.instr_container);
                return this.jc_instr;
            }
        }
        throw new ConverterInternalError();
    }

    private void checkArrayCountOrIndexType(OperandStackEntry operandStackEntry) {
        String string = this.method_converter.getClassName();
        if (operandStackEntry.getType() == 3) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.20", string.replace('/', '.'));
            throw new ConversionException();
        }
        if (operandStackEntry.hasOverflowPotential()) {
            Notifier.error(this.java_instr.getSourceLineNumber(), "int.20", string.replace('/', '.'));
            throw new ConversionException();
        }
    }

    private int getAtype(int n) {
        switch (n) {
            case 4: {
                return 10;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return 13;
            }
        }
        throw new ConversionException("not supported type");
    }
}

